/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.splitter;

import com.intellij.openapi.diff.impl.splitter.Interval;
import com.intellij.openapi.diff.impl.splitter.Transformation;

class LinearTransformation
implements Transformation {
    private final int myK;
    private final int myX0;

    LinearTransformation(int offset, int lineHeight) {
        this.myK = lineHeight;
        this.myX0 = -offset;
    }

    @Override
    public int transform(int line) {
        return LinearTransformation.linear(line, this.myX0, this.myK);
    }

    private static int linear(int x, int x0, int k) {
        return k * x + x0;
    }

    public static int oneToOne(int x, int x0, Interval range2) {
        if (range2.getLength() == 0) {
            return range2.getStart();
        }
        return range2.getStart() + Math.min(x - x0, range2.getLength() - 1);
    }
}

