/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.merge;

import com.intellij.CommonBundle;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.mergeTool.MergeVersion;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupport;
import com.intellij.openapi.vcs.changes.ui.NoneChangesGroupingFactory;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.merge.MergeProvider2;
import com.intellij.openapi.vcs.merge.MergeSession;
import com.intellij.openapi.vcs.merge.MergeSessionEx;
import com.intellij.openapi.vcs.merge.MultipleFileMergeDialog;
import com.intellij.openapi.vcs.merge.MultipleFileMergeDialog$WhenMappings;
import com.intellij.openapi.vcs.merge.MultipleFileMergeDialog$sam$com_intellij_util_Consumer$0;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.layout.BooleanPropertyUiManager;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmSuppressWildcards;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a1\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e*\u0001!\b\u0016\u0018\u0000 G2\u00020\u0001:\u0003FGHB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0016\u0010'\u001a\u00020\u00102\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060(H\u0015J\u0010\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020\u0006H\u0002J\u0013\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0014\u00a2\u0006\u0002\u0010.J\b\u0010/\u001a\u000200H\u0014J\u001b\u00101\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u0003020,H\u0002\u00a2\u0006\u0002\u00103J\b\u00104\u001a\u00020$H\u0014J\b\u00105\u001a\u000206H\u0015J\n\u00107\u001a\u0004\u0018\u000100H\u0016J\u000e\u00108\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0010\u00109\u001a\u00020&2\u0006\u0010:\u001a\u00020;H\u0002J\u0018\u0010<\u001a\u00020$2\u0006\u0010*\u001a\u00020\u00062\u0006\u0010%\u001a\u00020&H\u0002J\u001e\u0010=\u001a\u00020$2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010>\u001a\u00020$2\u0006\u0010*\u001a\u00020\u00062\u0006\u0010%\u001a\u00020&H\u0002J\b\u0010?\u001a\u00020$H\u0002J\b\u0010@\u001a\u00020$H\u0002J\u0010\u0010A\u001a\u00020$2\u0006\u0010B\u001a\u00020\u0010H\u0002J\b\u0010C\u001a\u00020$H\u0002J\b\u0010D\u001a\u00020$H\u0002J\b\u0010E\u001a\u00020$H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\"\u00a8\u0006I"}, d2={"Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "mergeProvider", "Lcom/intellij/openapi/vcs/merge/MergeProvider;", "mergeDialogCustomizer", "Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/openapi/vcs/merge/MergeProvider;Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer;)V", "acceptTheirsButton", "Ljavax/swing/JButton;", "acceptYoursButton", "groupByDirectory", "", "mergeButton", "mergeSession", "Lcom/intellij/openapi/vcs/merge/MergeSession;", "processedFiles", "", "getProcessedFiles", "()Ljava/util/List;", "projectManager", "Lcom/intellij/openapi/project/ex/ProjectManagerEx;", "kotlin.jvm.PlatformType", "table", "Lcom/intellij/ui/treeStructure/treetable/TreeTable;", "tableModel", "Lcom/intellij/ui/treeStructure/treetable/ListTreeTableModelOnColumns;", "unresolvedFiles", "virtualFileRenderer", "com/intellij/openapi/vcs/merge/MultipleFileMergeDialog$virtualFileRenderer$1", "Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$virtualFileRenderer$1;", "acceptRevision", "", "resolution", "Lcom/intellij/openapi/vcs/merge/MergeSession$Resolution;", "beforeResolve", "", "checkMarkModifiedProject", "file", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createCenterPanel", "Ljavax/swing/JComponent;", "createColumns", "Lcom/intellij/util/ui/ColumnInfo;", "()[Lcom/intellij/util/ui/ColumnInfo;", "dispose", "getDimensionServiceKey", "", "getPreferredFocusedComponent", "getSelectedFiles", "getSessionResolution", "result", "Lcom/intellij/diff/merge/MergeResult;", "markFileProcessed", "markFilesProcessed", "resolveFileViaContent", "selectFirstFile", "showMergeDialog", "toggleGroupByDirectory", "state", "updateButtonState", "updateModelFromFiles", "updateTree", "ColumnInfoAdapter", "Companion", "MyTable", "intellij.platform.vcs.impl"})
public class MultipleFileMergeDialog
extends DialogWrapper {
    private List<VirtualFile> unresolvedFiles;
    private final MergeSession mergeSession;
    @NotNull
    private final List<VirtualFile> processedFiles;
    private TreeTable table;
    private JButton acceptYoursButton;
    private JButton acceptTheirsButton;
    private JButton mergeButton;
    private final ListTreeTableModelOnColumns tableModel;
    private final ProjectManagerEx projectManager;
    private boolean groupByDirectory;
    private final virtualFileRenderer.1 virtualFileRenderer;
    private final Project project;
    private final MergeProvider mergeProvider;
    private final MergeDialogCustomizer mergeDialogCustomizer;
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public final List<VirtualFile> getProcessedFiles() {
        return this.processedFiles;
    }

    private final void selectFirstFile() {
        if (!this.groupByDirectory) {
            TreeTable treeTable = this.table;
            if (treeTable == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            }
            treeTable.getSelectionModel().setSelectionInterval(0, 0);
        } else {
            TreeTable treeTable = this.table;
            if (treeTable == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            }
            TreeTableTree treeTableTree = treeTable.getTree();
            Intrinsics.checkExpressionValueIsNotNull((Object)treeTableTree, (String)"table.tree");
            TreeTable treeTable2 = this.table;
            if (treeTable2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            }
            treeTableTree.setSelectionPath(TreeUtil.getFirstLeafNodePath((JTree)((JTree)treeTable2.getTree())));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected JComponent createCenterPanel() {
        void isSelected$iv;
        void text$iv;
        JButton it;
        Row this_$iv;
        Row $receiver;
        Row row$iv;
        boolean separated$iv;
        JLabel label$iv;
        LayoutBuilder this_$iv2;
        LayoutBuilder builder$iv;
        LCFlags[] constraints$iv = new LCFlags[]{LCFlags.disableMagic};
        String title$iv = null;
        LayoutBuilder $receiver2 = builder$iv = LayoutImplKt.createLayoutBuilder(!ArraysKt.contains((Object[])constraints$iv, (Object)((Object)LCFlags.disableMagic)));
        String string = this.mergeDialogCustomizer.getMultipleFileMergeDescription((Collection)this.unresolvedFiles);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mergeDialogCustomizer.ge\u2026cription(unresolvedFiles)");
        String description = string;
        if (!StringsKt.isBlank((CharSequence)description)) {
            this_$iv2 = $receiver2;
            label$iv = null;
            separated$iv = false;
            $receiver = row$iv = this_$iv2.getBuilder().newRow(label$iv, this_$iv2.getButtonGroup(), separated$iv);
            Row.label$default($receiver, description, 0, null, null, false, 30, null);
        }
        this_$iv2 = $receiver2;
        label$iv = null;
        separated$iv = false;
        $receiver = row$iv = this_$iv2.getBuilder().newRow(label$iv, this_$iv2.getButtonGroup(), separated$iv);
        Object $i$a$1$row = new MyTable(this.tableModel);
        Object object = $receiver;
        MyTable it2 = $i$a$1$row;
        this.table = it2;
        TreeTableTree treeTableTree = it2.getTree();
        Intrinsics.checkExpressionValueIsNotNull((Object)treeTableTree, (String)"it.tree");
        treeTableTree.setRootVisible(false);
        it2.setTreeCellRenderer((TreeCellRenderer)((Object)this.virtualFileRenderer));
        if (this.tableModel.getColumnCount() > 1) {
            it2.setShowColumns(true);
        }
        it2.setRowHeight(this.virtualFileRenderer.getPreferredSize().height);
        MyTable myTable = $i$a$1$row;
        ((Cell)object).scrollPane((Component)((Object)myTable), $receiver.getGrowX(), $receiver.getGrowY(), $receiver.getPushX(), $receiver.getPushY());
        $i$a$1$row = $receiver;
        boolean isVerticalFlow$iv = true;
        this_$iv.setCellMode(true, isVerticalFlow$iv);
        Cell $receiver3 = this_$iv;
        JButton jButton = new JButton("Accept Yours");
        Cell cell = $receiver3;
        JButton it3 = jButton;
        it3.addActionListener(new ActionListener(this){
            final /* synthetic */ MultipleFileMergeDialog this$0;
            {
                this.this$0 = multipleFileMergeDialog;
            }

            public final void actionPerformed(ActionEvent it) {
                MultipleFileMergeDialog.access$acceptRevision(this.this$0, MergeSession.Resolution.AcceptedYours);
            }
        });
        this.acceptYoursButton = it3;
        JButton jButton2 = jButton;
        Cell.invoke$default(cell, jButton2, new CCFlags[]{$receiver3.getGrowX()}, 0, null, null, 14, null);
        jButton = new JButton("Accept Theirs");
        cell = $receiver3;
        it3 = jButton;
        it3.addActionListener(new ActionListener(this){
            final /* synthetic */ MultipleFileMergeDialog this$0;
            {
                this.this$0 = multipleFileMergeDialog;
            }

            public final void actionPerformed(ActionEvent it) {
                MultipleFileMergeDialog.access$acceptRevision(this.this$0, MergeSession.Resolution.AcceptedTheirs);
            }
        });
        this.acceptTheirsButton = it3;
        jButton2 = jButton;
        Cell.invoke$default(cell, jButton2, new CCFlags[]{$receiver3.getGrowX()}, 0, null, null, 14, null);
        AbstractAction mergeAction = new AbstractAction(this){
            final /* synthetic */ MultipleFileMergeDialog this$0;
            {
                this.this$0 = multipleFileMergeDialog;
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                MultipleFileMergeDialog.access$showMergeDialog(this.this$0);
            }
        };
        mergeAction.putValue("DefaultAction", Boolean.TRUE);
        it3 = this.createJButtonForAction(mergeAction);
        cell = $receiver3;
        JButton jButton3 = it = it3;
        Intrinsics.checkExpressionValueIsNotNull((Object)jButton3, (String)"it");
        jButton3.setText("Merge...");
        this.mergeButton = it;
        JButton jButton4 = jButton2 = it3;
        Intrinsics.checkExpressionValueIsNotNull((Object)jButton4, (String)"createJButtonForAction(m\u2026geButton = it\n          }");
        Cell.invoke$default(cell, jButton4, new CCFlags[]{$receiver3.getGrowX()}, 0, null, null, 14, null);
        this_$iv.setCellMode(false, isVerticalFlow$iv);
        this_$iv2 = $receiver2;
        label$iv = null;
        separated$iv = false;
        this_$iv = $receiver = (row$iv = this_$iv2.getBuilder().newRow(label$iv, this_$iv2.getButtonGroup(), separated$iv));
        object = "Group files by directory";
        isVerticalFlow$iv = this.groupByDirectory;
        CCFlags[] constraints$iv2 = new CCFlags[]{};
        String comment$iv = null;
        BooleanPropertyUiManager propertyUiManager$iv = null;
        JCheckBox component$iv = this_$iv.checkBox((String)text$iv, (boolean)isSelected$iv, comment$iv, propertyUiManager$iv, Arrays.copyOf(constraints$iv2, constraints$iv2.length));
        component$iv.addActionListener(new ActionListener(component$iv, this){
            final /* synthetic */ JCheckBox $component;
            final /* synthetic */ MultipleFileMergeDialog this$0;
            {
                this.$component = jCheckBox;
                this.this$0 = multipleFileMergeDialog;
            }

            public final void actionPerformed(ActionEvent it) {
                ActionEvent actionEvent = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)actionEvent, (String)"it");
                JCheckBox component = this.$component;
                ActionEvent $noName_0 = actionEvent;
                MultipleFileMergeDialog.access$toggleGroupByDirectory(this.this$0, component.isSelected());
            }
        });
        JPanel panel$iv = ComponentsKt.Panel(title$iv, null);
        builder$iv.getBuilder().build(panel$iv, constraints$iv);
        return panel$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final ColumnInfo<?, ?>[] createColumns() {
        Collection $receiver$iv;
        ColumnInfo[] mergeInfoColumns;
        ArrayList<createColumns.1> columns = new ArrayList<createColumns.1>();
        columns.add(new ColumnInfo<DefaultMutableTreeNode, Object>(VcsBundle.message((String)"multiple.file.merge.column.name", (Object[])new Object[0])){

            public Object valueOf(@NotNull DefaultMutableTreeNode node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                return node.getUserObject();
            }

            @NotNull
            public Class<?> getColumnClass() {
                return TreeTableModel.class;
            }
        });
        MergeSession mergeSession = this.mergeSession;
        Object object = mergeInfoColumns = mergeSession != null ? mergeSession.getMergeInfoColumns() : null;
        if (mergeInfoColumns != null) {
            List customColumnNames = this.mergeDialogCustomizer.getColumnNames();
            if (customColumnNames != null && customColumnNames.size() != mergeInfoColumns.length) {
                LOG.error("Custom column names (" + customColumnNames + ") don't match default columns (" + mergeInfoColumns + ')');
                customColumnNames = null;
            }
            ColumnInfo[] $receiver$iv2 = mergeInfoColumns;
            int index$iv = 0;
            for (ColumnInfo item$iv : $receiver$iv2) {
                void index;
                void columnInfo;
                int n = index$iv++;
                ColumnInfo columnInfo2 = item$iv;
                int n2 = n;
                Collection collection = columns;
                void v3 = columnInfo;
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"columnInfo");
                Object object2 = customColumnNames;
                if (object2 == null || (object2 = (String)object2.get((int)index)) == null) {
                    String string = columnInfo.getName();
                    object2 = string;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"columnInfo.name");
                }
                ColumnInfoAdapter columnInfoAdapter = new ColumnInfoAdapter((ColumnInfo<Object, Object>)v3, (String)object2);
                collection.add(columnInfoAdapter);
            }
        }
        Collection thisCollection$iv = $receiver$iv = (Collection)columns;
        ColumnInfo[] columnInfoArray = thisCollection$iv.toArray(new ColumnInfo[0]);
        if (columnInfoArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return columnInfoArray;
    }

    private final void toggleGroupByDirectory(boolean state) {
        block3: {
            DefaultMutableTreeNode node;
            VcsConfiguration.getInstance((Project)this.project).GROUP_MULTIFILE_MERGE_BY_DIRECTORY = this.groupByDirectory = state;
            VirtualFile firstSelectedFile = (VirtualFile)CollectionsKt.firstOrNull(this.getSelectedFiles());
            this.updateTree();
            if (firstSelectedFile == null) break block3;
            Object object = this.tableModel.getRoot();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            }
            DefaultMutableTreeNode defaultMutableTreeNode = node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)((DefaultMutableTreeNode)object), (Object)firstSelectedFile);
            if (defaultMutableTreeNode != null) {
                DefaultMutableTreeNode defaultMutableTreeNode2;
                DefaultMutableTreeNode it = defaultMutableTreeNode2 = defaultMutableTreeNode;
                TreeTable treeTable = this.table;
                if (treeTable == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"table");
                }
                TreeUtil.selectNode((JTree)((JTree)treeTable.getTree()), (TreeNode)node);
            }
        }
    }

    private final void updateTree() {
        ChangesGroupingPolicyFactory factory = this.groupByDirectory ? (ChangesGroupingPolicyFactory)ChangesGroupingSupport.Companion.collectFactories(this.project).getByKey((Object)"directory") : (ChangesGroupingPolicyFactory)NoneChangesGroupingFactory.INSTANCE;
        DefaultTreeModel defaultTreeModel = TreeModelBuilder.buildFromVirtualFiles(this.project, factory, (Collection<VirtualFile>)this.unresolvedFiles);
        Intrinsics.checkExpressionValueIsNotNull((Object)defaultTreeModel, (String)"TreeModelBuilder.buildFr\u2026factory, unresolvedFiles)");
        DefaultTreeModel model = defaultTreeModel;
        Object object = model.getRoot();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type javax.swing.tree.TreeNode");
        }
        this.tableModel.setRoot((TreeNode)object);
        TreeTable treeTable = this.table;
        if (treeTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
        }
        TreeUtil.expandAll((JTree)((JTree)treeTable.getTree()));
    }

    private final void updateButtonState() {
        boolean bl;
        boolean haveUnmergeableFiles;
        boolean haveSelection;
        block10: {
            boolean bl2;
            List<VirtualFile> selectedFiles;
            block9: {
                selectedFiles = this.getSelectedFiles();
                haveSelection = CollectionsKt.any((Iterable)selectedFiles);
                Iterable $receiver$iv = selectedFiles;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        VirtualFile it = (VirtualFile)element$iv;
                        MergeSession mergeSession = this.mergeSession;
                        if (!(mergeSession != null && !mergeSession.canMerge(it))) continue;
                        bl2 = true;
                        break block9;
                    }
                    bl2 = false;
                }
            }
            haveUnmergeableFiles = bl2;
            Iterable $receiver$iv = selectedFiles;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    if (!(this.mergeSession != null && !(this.mergeSession instanceof MergeSessionEx) && !this.mergeSession.canMerge(it))) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        boolean haveUnacceptableFiles = bl;
        JButton jButton = this.acceptYoursButton;
        if (jButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"acceptYoursButton");
        }
        jButton.setEnabled(haveSelection && !haveUnacceptableFiles);
        JButton jButton2 = this.acceptTheirsButton;
        if (jButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"acceptTheirsButton");
        }
        jButton2.setEnabled(haveSelection && !haveUnacceptableFiles);
        JButton jButton3 = this.mergeButton;
        if (jButton3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mergeButton");
        }
        jButton3.setEnabled(haveSelection && !haveUnmergeableFiles);
    }

    private final List<VirtualFile> getSelectedFiles() {
        TreeTable treeTable = this.table;
        if (treeTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
        }
        List list2 = TreeUtil.collectSelectedObjectsOfType((JTree)((JTree)treeTable.getTree()), VirtualFile.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"TreeUtil.collectSelected\u2026 VirtualFile::class.java)");
        return list2;
    }

    @NotNull
    protected Action[] createActions() {
        this.getCancelAction().putValue("Name", CommonBundle.getCloseButtonText());
        Action[] actionArray = new Action[1];
        Action action = this.getCancelAction();
        Intrinsics.checkExpressionValueIsNotNull((Object)action, (String)"cancelAction");
        actionArray[0] = action;
        return actionArray;
    }

    protected void dispose() {
        this.projectManager.unblockReloadingProjectOnExternalChanges();
        super.dispose();
    }

    @NonNls
    @NotNull
    protected String getDimensionServiceKey() {
        return "MultipleFileMergeDialog";
    }

    @JvmSuppressWildcards
    protected boolean beforeResolve(@NotNull Collection<VirtualFile> files2) {
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        return true;
    }

    private final void acceptRevision(MergeSession.Resolution resolution) {
        boolean bl;
        boolean bl2 = bl = resolution == MergeSession.Resolution.AcceptedYours || resolution == MergeSession.Resolution.AcceptedTheirs;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        List<VirtualFile> files2 = this.getSelectedFiles();
        if (!this.beforeResolve((Collection<VirtualFile>)files2)) {
            return;
        }
        try {
            if (this.mergeSession instanceof MergeSessionEx) {
                ((MergeSessionEx)this.mergeSession).acceptFilesRevisions(files2, resolution);
                for (VirtualFile file2 : files2) {
                    this.checkMarkModifiedProject(file2);
                }
                this.markFilesProcessed(files2, resolution);
            } else {
                for (VirtualFile file3 : files2) {
                    this.resolveFileViaContent(file3, resolution);
                    this.checkMarkModifiedProject(file3);
                    this.markFileProcessed(file3, resolution);
                }
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            Messages.showErrorDialog((Component)this.getContentPanel(), (String)("Error saving merged data: " + e.getMessage()));
        }
        this.updateModelFromFiles();
    }

    private final void resolveFileViaContent(VirtualFile file2, MergeSession.Resolution resolution) {
        if (!DiffUtil.makeWritable(this.project, file2)) {
            throw (Throwable)new IOException("File is read-only: " + file2.getPresentableName());
        }
        boolean isCurrent = resolution == MergeSession.Resolution.AcceptedYours;
        MergeData mergeData = this.mergeProvider.loadRevisions(file2);
        Intrinsics.checkExpressionValueIsNotNull((Object)mergeData, (String)"mergeProvider.loadRevisions(file)");
        MergeData data = mergeData;
        WriteCommandAction.writeCommandAction((Project)this.project).withName("Accept " + (isCurrent ? "Yours" : "Theirs")).run((ThrowableRunnable)new ThrowableRunnable<Exception>(isCurrent, file2, data){
            final /* synthetic */ boolean $isCurrent;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ MergeData $data;

            public final void run() {
                if (this.$isCurrent) {
                    this.$file.setBinaryContent(this.$data.CURRENT);
                } else {
                    this.$file.setBinaryContent(this.$data.LAST);
                }
            }
            {
                this.$isCurrent = bl;
                this.$file = virtualFile;
                this.$data = mergeData;
            }
        });
    }

    private final void markFilesProcessed(List<? extends VirtualFile> files2, MergeSession.Resolution resolution) {
        this.unresolvedFiles.removeAll((Collection)files2);
        if (this.mergeSession instanceof MergeSessionEx) {
            ((MergeSessionEx)this.mergeSession).conflictResolvedForFiles(files2, resolution);
        } else if (this.mergeSession != null) {
            Iterable $receiver$iv = files2;
            for (Object element$iv : $receiver$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                this.mergeSession.conflictResolvedForFile(it, resolution);
            }
        } else {
            Iterable $receiver$iv = files2;
            for (Object element$iv : $receiver$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                this.mergeProvider.conflictResolvedForFile(it);
            }
        }
        this.processedFiles.addAll((Collection<VirtualFile>)files2);
        VcsDirtyScopeManager.getInstance((Project)this.project).filesDirty((Collection)files2, (Collection)CollectionsKt.emptyList());
    }

    private final void markFileProcessed(VirtualFile file2, MergeSession.Resolution resolution) {
        this.markFilesProcessed(CollectionsKt.listOf((Object)file2), resolution);
    }

    private final void updateModelFromFiles() {
        if (this.unresolvedFiles.isEmpty()) {
            this.doCancelAction();
        } else {
            TreeTable treeTable = this.table;
            if (treeTable == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            }
            ListSelectionModel listSelectionModel = treeTable.getSelectionModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)listSelectionModel, (String)"table.selectionModel");
            int selIndex = listSelectionModel.getMinSelectionIndex();
            this.updateTree();
            TreeTable treeTable2 = this.table;
            if (treeTable2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            }
            if (selIndex >= treeTable2.getRowCount()) {
                TreeTable treeTable3 = this.table;
                if (treeTable3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"table");
                }
                selIndex = treeTable3.getRowCount() - 1;
            }
            TreeTable treeTable4 = this.table;
            if (treeTable4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            }
            treeTable4.getSelectionModel().setSelectionInterval(selIndex, selIndex);
        }
    }

    private final void showMergeDialog() {
        DiffRequestFactory diffRequestFactory = DiffRequestFactory.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)diffRequestFactory, (String)"DiffRequestFactory.getInstance()");
        DiffRequestFactory requestFactory = diffRequestFactory;
        List<VirtualFile> files2 = this.getSelectedFiles();
        if (files2.isEmpty()) {
            return;
        }
        if (!this.beforeResolve((Collection<VirtualFile>)files2)) {
            return;
        }
        for (VirtualFile file2 : files2) {
            MergeRequest request;
            String rightTitle;
            String baseTitle;
            String leftTitle;
            MergeData mergeData;
            try {
                Intrinsics.checkExpressionValueIsNotNull((Object)this.mergeProvider.loadRevisions(file2), (String)"mergeProvider.loadRevisions(file)");
            }
            catch (VcsException ex) {
                Messages.showErrorDialog((Component)this.getContentPanel(), (String)("Error loading revisions to merge: " + ex.getMessage()));
                break;
            }
            if (mergeData.CURRENT == null || mergeData.LAST == null || mergeData.ORIGINAL == null) {
                Messages.showErrorDialog((Component)this.getContentPanel(), (String)"Error loading revisions to merge");
                break;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)this.mergeDialogCustomizer.getLeftPanelTitle(file2), (String)"mergeDialogCustomizer.getLeftPanelTitle(file)");
            Intrinsics.checkExpressionValueIsNotNull((Object)this.mergeDialogCustomizer.getCenterPanelTitle(file2), (String)"mergeDialogCustomizer.getCenterPanelTitle(file)");
            Intrinsics.checkExpressionValueIsNotNull((Object)this.mergeDialogCustomizer.getRightPanelTitle(file2, mergeData.LAST_REVISION_NUMBER), (String)"mergeDialogCustomizer.ge\u2026ata.LAST_REVISION_NUMBER)");
            Intrinsics.checkExpressionValueIsNotNull((Object)this.mergeDialogCustomizer.getMergeWindowTitle(file2), (String)"mergeDialogCustomizer.getMergeWindowTitle(file)");
            List byteContents = CollectionsKt.listOf((Object[])new byte[][]{mergeData.CURRENT, mergeData.ORIGINAL, mergeData.LAST});
            List contentTitles = CollectionsKt.listOf((Object[])new String[]{leftTitle, baseTitle, rightTitle});
            Function1 callback2 = (Function1)new Function1<MergeResult, Unit>(this, file2){
                final /* synthetic */ MultipleFileMergeDialog this$0;
                final /* synthetic */ VirtualFile $file;

                public final void invoke(@NotNull MergeResult result2) {
                    Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
                    Document document = FileDocumentManager.getInstance().getCachedDocument(this.$file);
                    if (document != null) {
                        FileDocumentManager.getInstance().saveDocument(document);
                    }
                    MultipleFileMergeDialog.access$checkMarkModifiedProject(this.this$0, this.$file);
                    if (result2 != MergeResult.CANCEL) {
                        MultipleFileMergeDialog.access$markFileProcessed(this.this$0, this.$file, MultipleFileMergeDialog.access$getSessionResolution(this.this$0, result2));
                    }
                }
                {
                    this.this$0 = multipleFileMergeDialog;
                    this.$file = virtualFile;
                    super(1);
                }
            };
            try {
                String title;
                Function1 function1;
                if (this.mergeProvider.isBinary(file2)) {
                    function1 = callback2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)requestFactory.createBinaryMergeRequest(this.project, file2, byteContents, title, contentTitles, (Consumer)new MultipleFileMergeDialog$sam$com_intellij_util_Consumer$0(function1)), (String)"requestFactory.createBin\u2026 contentTitles, callback)");
                } else {
                    function1 = callback2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)requestFactory.createMergeRequest(this.project, file2, byteContents, title, contentTitles, (Consumer)new MultipleFileMergeDialog$sam$com_intellij_util_Consumer$0(function1)), (String)"requestFactory.createMer\u2026 contentTitles, callback)");
                }
                MergeUtil.putRevisionInfos(request, mergeData);
            }
            catch (InvalidDiffRequestException e) {
                if (e.getCause() instanceof FileTooBigException) {
                    Messages.showErrorDialog((Component)this.getContentPanel(), (String)"File is too big to be loaded.", (String)"Can't Show Merge Dialog");
                    break;
                }
                LOG.error((Throwable)e);
                Messages.showErrorDialog((Component)this.getContentPanel(), (String)e.getMessage(), (String)"Can't Show Merge Dialog");
                break;
            }
            DiffManager.getInstance().showMerge(this.project, request);
        }
        this.updateModelFromFiles();
        IdeFocusManager ideFocusManager = IdeFocusManager.getInstance((Project)this.project);
        TreeTable treeTable = this.table;
        if (treeTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
        }
        ideFocusManager.requestFocus((Component)treeTable, false);
    }

    private final MergeSession.Resolution getSessionResolution(MergeResult result2) {
        MergeSession.Resolution resolution;
        switch (MultipleFileMergeDialog$WhenMappings.$EnumSwitchMapping$0[result2.ordinal()]) {
            case 1: {
                resolution = MergeSession.Resolution.AcceptedYours;
                break;
            }
            case 2: {
                resolution = MergeSession.Resolution.AcceptedTheirs;
                break;
            }
            case 3: {
                resolution = MergeSession.Resolution.Merged;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException(result2.name());
            }
        }
        return resolution;
    }

    private final void checkMarkModifiedProject(VirtualFile file2) {
        MergeVersion.MergeDocumentVersion.reportProjectFileChangeIfNeeded(this.project, file2);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        TreeTable treeTable = this.table;
        if (treeTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
        }
        return (JComponent)treeTable;
    }

    public MultipleFileMergeDialog(@NotNull Project project, @NotNull List<? extends VirtualFile> files2, @NotNull MergeProvider mergeProvider, @NotNull MergeDialogCustomizer mergeDialogCustomizer) {
        List list2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)mergeProvider, (String)"mergeProvider");
        Intrinsics.checkParameterIsNotNull((Object)mergeDialogCustomizer, (String)"mergeDialogCustomizer");
        super(project);
        this.project = project;
        this.mergeProvider = mergeProvider;
        this.mergeDialogCustomizer = mergeDialogCustomizer;
        this.unresolvedFiles = CollectionsKt.toMutableList((Collection)files2);
        MergeProvider mergeProvider2 = this.mergeProvider;
        if (!(mergeProvider2 instanceof MergeProvider2)) {
            mergeProvider2 = null;
        }
        MergeProvider2 mergeProvider22 = (MergeProvider2)mergeProvider2;
        this.mergeSession = mergeProvider22 != null ? mergeProvider22.createMergeSession(files2) : null;
        MultipleFileMergeDialog multipleFileMergeDialog = this;
        multipleFileMergeDialog.processedFiles = list2 = (List)new ArrayList();
        this.tableModel = new ListTreeTableModelOnColumns((TreeNode)new DefaultMutableTreeNode(), this.createColumns());
        this.projectManager = ProjectManagerEx.getInstanceEx();
        this.groupByDirectory = VcsConfiguration.getInstance((Project)this.project).GROUP_MULTIFILE_MERGE_BY_DIRECTORY;
        this.virtualFileRenderer = new ChangesBrowserNodeRenderer(this, this.project, new BooleanGetter(this){
            final /* synthetic */ MultipleFileMergeDialog this$0;

            public final boolean get() {
                return !MultipleFileMergeDialog.access$getGroupByDirectory$p(this.this$0);
            }
            {
                this.this$0 = multipleFileMergeDialog;
            }
        }, false){
            final /* synthetic */ MultipleFileMergeDialog this$0;

            protected boolean calcFocusedState() {
                DialogWrapperPeer dialogWrapperPeer = this.this$0.getPeer();
                Intrinsics.checkExpressionValueIsNotNull((Object)dialogWrapperPeer, (String)"this@MultipleFileMergeDialog.peer");
                Component component = dialogWrapperPeer.getWindow();
                IdeFocusManager ideFocusManager = IdeFocusManager.getInstance((Project)MultipleFileMergeDialog.access$getProject$p(this.this$0));
                Intrinsics.checkExpressionValueIsNotNull((Object)ideFocusManager, (String)"IdeFocusManager.getInstance(project)");
                return UIUtil.isAncestor((Component)component, (Component)ideFocusManager.getFocusOwner());
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        };
        this.projectManager.blockReloadingProjectOnExternalChanges();
        this.setTitle(this.mergeDialogCustomizer.getMultipleFileDialogTitle());
        this.virtualFileRenderer.setFont(UIUtil.getListFont());
        this.init();
        this.updateTree();
        TreeTable treeTable = this.table;
        if (treeTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
        }
        TreeTableTree treeTableTree = treeTable.getTree();
        Intrinsics.checkExpressionValueIsNotNull((Object)treeTableTree, (String)"table.tree");
        treeTableTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public final void valueChanged(TreeSelectionEvent it) {
                this.updateButtonState();
            }
        });
        this.selectFirstFile();
        DoubleClickListener doubleClickListener = new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                this.showMergeDialog();
                return true;
            }
        };
        TreeTable treeTable2 = this.table;
        if (treeTable2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
        }
        doubleClickListener.installOn((Component)treeTable2);
        TreeTable treeTable3 = this.table;
        if (treeTable3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
        }
        new TableSpeedSearch((JTable)treeTable3, (Convertor<Object, String>)((Convertor)3.INSTANCE));
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(MultipleFileMergeDialog.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Multi\u2026eMergeDialog::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$acceptRevision(MultipleFileMergeDialog $this, @NotNull MergeSession.Resolution resolution) {
        $this.acceptRevision(resolution);
    }

    public static final /* synthetic */ void access$toggleGroupByDirectory(MultipleFileMergeDialog $this, boolean state) {
        $this.toggleGroupByDirectory(state);
    }

    public static final /* synthetic */ void access$checkMarkModifiedProject(MultipleFileMergeDialog $this, @NotNull VirtualFile file2) {
        $this.checkMarkModifiedProject(file2);
    }

    public static final /* synthetic */ void access$markFileProcessed(MultipleFileMergeDialog $this, @NotNull VirtualFile file2, @NotNull MergeSession.Resolution resolution) {
        $this.markFileProcessed(file2, resolution);
    }

    @NotNull
    public static final /* synthetic */ MergeSession.Resolution access$getSessionResolution(MultipleFileMergeDialog $this, @NotNull MergeResult result2) {
        return $this.getSessionResolution(result2);
    }

    @NotNull
    public static final /* synthetic */ Project access$getProject$p(MultipleFileMergeDialog $this) {
        return $this.project;
    }

    public static final /* synthetic */ boolean access$getGroupByDirectory$p(MultipleFileMergeDialog $this) {
        return $this.groupByDirectory;
    }

    public static final /* synthetic */ void access$setGroupByDirectory$p(MultipleFileMergeDialog $this, boolean bl) {
        $this.groupByDirectory = bl;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B!\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u000b\u001a\u00020\u0006H\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$ColumnInfoAdapter;", "Lcom/intellij/util/ui/ColumnInfo;", "Ljavax/swing/tree/DefaultMutableTreeNode;", "", "base", "columnName", "", "(Lcom/intellij/util/ui/ColumnInfo;Ljava/lang/String;)V", "getAdditionalWidth", "", "getMaxStringValue", "getTooltipText", "valueOf", "node", "intellij.platform.vcs.impl"})
    private static final class ColumnInfoAdapter
    extends ColumnInfo<DefaultMutableTreeNode, Object> {
        private final ColumnInfo<Object, Object> base;
        private final String columnName;

        @Nullable
        public Object valueOf(@NotNull DefaultMutableTreeNode node) {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Object object2 = node.getUserObject();
            if (!(object2 instanceof VirtualFile)) {
                object2 = null;
            }
            VirtualFile virtualFile = (VirtualFile)object2;
            if (virtualFile != null) {
                VirtualFile virtualFile2;
                VirtualFile it = virtualFile2 = virtualFile;
                object = this.base.valueOf((Object)it);
            } else {
                object = null;
            }
            return object;
        }

        @Nullable
        public String getMaxStringValue() {
            return this.base.getMaxStringValue();
        }

        public int getAdditionalWidth() {
            return this.base.getAdditionalWidth();
        }

        @NotNull
        public String getTooltipText() {
            String string = this.base.getTooltipText();
            if (string == null) {
                string = this.columnName;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"base.tooltipText ?: columnName");
            return string;
        }

        public ColumnInfoAdapter(@NotNull ColumnInfo<Object, Object> base, @NotNull String columnName) {
            Intrinsics.checkParameterIsNotNull(base, (String)"base");
            Intrinsics.checkParameterIsNotNull((Object)columnName, (String)"columnName");
            super(columnName);
            this.base = base;
            this.columnName = columnName;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$MyTable;", "Lcom/intellij/ui/treeStructure/treetable/TreeTable;", "tableModel", "Lcom/intellij/ui/treeStructure/treetable/ListTreeTableModelOnColumns;", "(Lcom/intellij/ui/treeStructure/treetable/ListTreeTableModelOnColumns;)V", "calcColumnWidth", "", "maxStringValue", "", "columnInfo", "Lcom/intellij/util/ui/ColumnInfo;", "", "doLayout", "", "updateColumnSizes", "intellij.platform.vcs.impl"})
    private static final class MyTable
    extends TreeTable {
        private final ListTreeTableModelOnColumns tableModel;

        public void doLayout() {
            JTableHeader jTableHeader = this.getTableHeader();
            Intrinsics.checkExpressionValueIsNotNull((Object)jTableHeader, (String)"getTableHeader()");
            if (jTableHeader.getResizingColumn() == null) {
                this.updateColumnSizes();
            }
            super.doLayout();
        }

        /*
         * WARNING - void declaration
         */
        private final void updateColumnSizes() {
            ColumnInfo[] columnInfoArray = this.tableModel.getColumns();
            Intrinsics.checkExpressionValueIsNotNull((Object)columnInfoArray, (String)"tableModel.columns");
            ColumnInfo[] columnInfoArray2 = columnInfoArray;
            int n = columnInfoArray2.length;
            int n2 = 0;
            while (n2 < n) {
                void index;
                ColumnInfo columnInfo = columnInfoArray2[n2];
                TableColumn column = this.columnModel.getColumn((int)index);
                ColumnInfo columnInfo2 = columnInfo;
                Intrinsics.checkExpressionValueIsNotNull((Object)columnInfo2, (String)"columnInfo");
                if (columnInfo2.getMaxStringValue() != null) {
                    String string;
                    String it;
                    String string2 = it = string;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it");
                    int width = this.calcColumnWidth(string2, (ColumnInfo<Object, Object>)columnInfo);
                    TableColumn tableColumn = column;
                    Intrinsics.checkExpressionValueIsNotNull((Object)tableColumn, (String)"column");
                    tableColumn.setPreferredWidth(width);
                }
                ++index;
            }
            int size = this.getWidth();
            int fileColumn = 0;
            int n3 = 0;
            n = this.tableModel.getColumns().length;
            while (n3 < n) {
                void i;
                if (i != false) {
                    TableColumn tableColumn = this.columnModel.getColumn((int)i);
                    Intrinsics.checkExpressionValueIsNotNull((Object)tableColumn, (String)"columnModel.getColumn(i)");
                    size -= tableColumn.getPreferredWidth();
                }
                ++i;
            }
            TableColumn tableColumn = this.columnModel.getColumn(fileColumn);
            Intrinsics.checkExpressionValueIsNotNull((Object)tableColumn, (String)"columnModel.getColumn(fileColumn)");
            tableColumn.setPreferredWidth(Math.max(size, JBUI.scale((int)200)));
        }

        private final int calcColumnWidth(String maxStringValue, ColumnInfo<Object, Object> columnInfo) {
            String string = StringUtil.shortenTextWithEllipsis((String)columnInfo.getName(), (int)15, (int)7, (boolean)true);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.shortenTextWi\u2026mnInfo.name, 15, 7, true)");
            String columnName = string;
            int n = this.getFontMetrics(this.getFont()).stringWidth(maxStringValue);
            JTableHeader jTableHeader = this.tableHeader;
            Intrinsics.checkExpressionValueIsNotNull((Object)jTableHeader, (String)"tableHeader");
            return Math.max(n, this.getFontMetrics(jTableHeader.getFont()).stringWidth(columnName)) + columnInfo.getAdditionalWidth();
        }

        public MyTable(@NotNull ListTreeTableModelOnColumns tableModel) {
            Intrinsics.checkParameterIsNotNull((Object)tableModel, (String)"tableModel");
            super((TreeTableModel)tableModel);
            this.tableModel = tableModel;
            JTableHeader jTableHeader = this.getTableHeader();
            Intrinsics.checkExpressionValueIsNotNull((Object)jTableHeader, (String)"getTableHeader()");
            jTableHeader.setReorderingAllowed(false);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

