/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.CachedValueBase;
import com.intellij.util.CachedValueLeakChecker;
import com.intellij.util.CachedValuesFactory;
import com.intellij.util.DefaultCachedValuesFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedValuesManagerImpl
extends CachedValuesManager {
    private final Project myProject;
    private final CachedValuesFactory myFactory;

    public CachedValuesManagerImpl(Project project, CachedValuesFactory factory) {
        this.myProject = project;
        this.myFactory = factory == null ? new DefaultCachedValuesFactory(project) : factory;
    }

    @NotNull
    public <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> provider, boolean trackValue) {
        if (provider == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(0);
        }
        CachedValue<T> cachedValue = this.myFactory.createCachedValue(provider, trackValue);
        if (cachedValue == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(1);
        }
        return cachedValue;
    }

    @NotNull
    public <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull ParameterizedCachedValueProvider<T, P> provider, boolean trackValue) {
        if (provider == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(2);
        }
        ParameterizedCachedValue<T, P> parameterizedCachedValue = this.myFactory.createParameterizedCachedValue(provider, trackValue);
        if (parameterizedCachedValue == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(3);
        }
        return parameterizedCachedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T, D extends UserDataHolder> T getCachedValue(@NotNull D dataHolder, @NotNull Key<CachedValue<T>> key, @NotNull CachedValueProvider<T> provider, boolean trackValue) {
        CachedValue value;
        if (dataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(4);
        }
        if (key == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(5);
        }
        if (provider == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(6);
        }
        if (dataHolder instanceof UserDataHolderEx) {
            UserDataHolderEx dh = (UserDataHolderEx)dataHolder;
            value = (CachedValue)dh.getUserData(key);
            while (this.isOutdated(value)) {
                if (dh.replace(key, (Object)value, null)) {
                    value = null;
                    break;
                }
                value = (CachedValue)dh.getUserData(key);
            }
            if (value == null) {
                CachedValueLeakChecker.checkProvider(provider, key, dataHolder);
                value = this.createCachedValue(provider, trackValue);
                assert (((CachedValueBase)value).isFromMyProject(this.myProject));
                value = (CachedValue)dh.putUserDataIfAbsent(key, value);
            }
        } else {
            D d = dataHolder;
            synchronized (d) {
                value = (CachedValue)dataHolder.getUserData(key);
                if (this.isOutdated(value)) {
                    value = null;
                }
                if (value == null) {
                    CachedValueLeakChecker.checkProvider(provider, key, dataHolder);
                    value = this.createCachedValue(provider, trackValue);
                    dataHolder.putUserData(key, value);
                }
            }
        }
        return (T)value.getValue();
    }

    private boolean isOutdated(CachedValue<?> value) {
        return value instanceof CachedValueBase && (!((CachedValueBase)value).isFromMyProject(this.myProject) || CachedValuesManagerImpl.hasOutdatedValue((CachedValueBase)value));
    }

    private static boolean hasOutdatedValue(CachedValueBase base) {
        return !base.hasUpToDateValue() && base.getRawData() != null;
    }

    public Project getProject() {
        return this.myProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/CachedValuesManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHolder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/CachedValuesManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCachedValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterizedCachedValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCachedValue";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createParameterizedCachedValue";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCachedValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

