/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.table;

import java.awt.Component;
import java.awt.Container;
import java.util.List;
import javax.swing.LayoutFocusTraversalPolicy;
import org.jetbrains.annotations.NotNull;

public abstract class ComponentsListFocusTraversalPolicy
extends LayoutFocusTraversalPolicy {
    private static final int FORWARD = 1;
    private static final int BACKWARD = -1;

    @Override
    public Component getComponentAfter(Container aContainer, Component aComponent) {
        Component after2;
        List<Component> components = this.getOrderedComponents();
        int i = components.indexOf(aComponent);
        Component component = after2 = i != -1 ? ComponentsListFocusTraversalPolicy.searchShowing(components, i + 1, 1) : null;
        if (after2 == null) {
            return super.getComponentAfter(aContainer, aComponent);
        }
        return after2;
    }

    @Override
    public Component getComponentBefore(Container aContainer, Component aComponent) {
        Component before;
        List<Component> components = this.getOrderedComponents();
        int i = components.indexOf(aComponent);
        Component component = before = i != -1 ? ComponentsListFocusTraversalPolicy.searchShowing(components, i - 1, -1) : null;
        if (before == null) {
            return super.getComponentBefore(aContainer, aComponent);
        }
        return before;
    }

    @Override
    public Component getFirstComponent(Container aContainer) {
        List<Component> components = this.getOrderedComponents();
        return components.isEmpty() ? null : ComponentsListFocusTraversalPolicy.searchShowing(components, 0, 1);
    }

    @Override
    public Component getLastComponent(Container aContainer) {
        List<Component> components = this.getOrderedComponents();
        return components.isEmpty() ? null : ComponentsListFocusTraversalPolicy.searchShowing(components, components.size() - 1, -1);
    }

    @Override
    public Component getDefaultComponent(Container aContainer) {
        List<Component> components = this.getOrderedComponents();
        return components.isEmpty() ? null : ComponentsListFocusTraversalPolicy.searchShowing(components, 0, 1);
    }

    @NotNull
    protected abstract List<Component> getOrderedComponents();

    private static Component searchShowing(@NotNull List<Component> components, int start2, int direction) {
        if (components == null) {
            ComponentsListFocusTraversalPolicy.$$$reportNull$$$0(0);
        }
        for (int i = start2; i >= 0 && i < components.size(); i += direction) {
            Component c = components.get(i);
            if (c == null || !c.isShowing()) continue;
            return c;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/util/ui/table/ComponentsListFocusTraversalPolicy", "searchShowing"));
    }
}

