/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import gnu.trove.TObjectIntHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSRecursionGuard {
    private static boolean ourAssertOnPrevention = false;
    @NotNull
    private final List<Pair<PsiElement, JSEvaluateContext.JSEvaluationPlace>> processingItems = new SmartList();
    @NotNull
    private final TObjectIntHashMap<PsiElement> processingItemsSet = new TObjectIntHashMap();

    public static void assertOnRecursionPrevention(@NotNull Disposable disposable) {
        if (disposable == null) {
            JSRecursionGuard.$$$reportNull$$$0(0);
        }
        ourAssertOnPrevention = true;
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

            public void dispose() {
                ourAssertOnPrevention = false;
            }
        });
    }

    public boolean isAlreadyProcessingItem(@NotNull PsiElement element) {
        if (element == null) {
            JSRecursionGuard.$$$reportNull$$$0(1);
        }
        return this.isAlreadyProcessingItem(element, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
    }

    public boolean isAlreadyProcessingItem(@NotNull PsiElement element, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        if (element == null) {
            JSRecursionGuard.$$$reportNull$$$0(2);
        }
        if (place == null) {
            JSRecursionGuard.$$$reportNull$$$0(3);
        }
        if (!this.processingItemsSet.contains((Object)element)) {
            return false;
        }
        for (int i = this.processingItems.size() - 1; i >= 0; --i) {
            Pair<PsiElement, JSEvaluateContext.JSEvaluationPlace> pair = this.processingItems.get(i);
            if (element.equals(pair.first) && place.equals(pair.second)) {
                if (ourAssertOnPrevention) {
                    throw new AssertionError((Object)("Guard recursion is forbidden. Element text: " + element.getText()));
                }
                return true;
            }
            if (((JSEvaluateContext.JSEvaluationPlace)((Object)pair.second)).ordinal() >= place.ordinal()) continue;
            return false;
        }
        return false;
    }

    public void addProcessingItem(@NotNull PsiElement element) {
        if (element == null) {
            JSRecursionGuard.$$$reportNull$$$0(4);
        }
        this.addProcessingItem(element, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
    }

    public void addProcessingItem(@NotNull PsiElement element, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        if (element == null) {
            JSRecursionGuard.$$$reportNull$$$0(5);
        }
        if (place == null) {
            JSRecursionGuard.$$$reportNull$$$0(6);
        }
        if (this.processingItemsSet.contains((Object)element)) {
            this.processingItemsSet.increment((Object)element);
        } else {
            this.processingItemsSet.put((Object)element, 1);
        }
        this.processingItems.add((Pair<PsiElement, JSEvaluateContext.JSEvaluationPlace>)Pair.create((Object)element, (Object)((Object)place)));
    }

    public void removeProcessingItem(@NotNull PsiElement element) {
        if (element == null) {
            JSRecursionGuard.$$$reportNull$$$0(7);
        }
        this.removeProcessingItem(element, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
    }

    public void removeProcessingItem(@NotNull PsiElement element, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        if (element == null) {
            JSRecursionGuard.$$$reportNull$$$0(8);
        }
        if (place == null) {
            JSRecursionGuard.$$$reportNull$$$0(9);
        }
        Pair<PsiElement, JSEvaluateContext.JSEvaluationPlace> removed = this.processingItems.remove(this.processingItems.size() - 1);
        int i = this.processingItemsSet.get((Object)element);
        assert (i >= 1);
        if (i == 1) {
            this.processingItemsSet.remove((Object)element);
        } else {
            this.processingItemsSet.adjustValue((Object)element, -1);
        }
        assert (((PsiElement)removed.first).equals(element) && ((JSEvaluateContext.JSEvaluationPlace)((Object)removed.second)).equals((Object)place)) : "wrong element removed";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSRecursionGuard";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "assertOnRecursionPrevention";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isAlreadyProcessingItem";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addProcessingItem";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "removeProcessingItem";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

