/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfoImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeWithWidening;
import com.intellij.lang.javascript.psi.types.JSWrapperType;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigInteger;
import java.text.CharacterIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTypeImpl
extends JSNamedType
implements JSResolvableType,
JSTypeWithWidening {
    public static final JSType.LocalTypeKey RECORD_TYPE_CACHE = JSType.createLocalTypeKey((String)"js.resolve.qualified.type");
    private static final Key<Ref<JSType>> ourTypedefsExpandedKey = Key.create((String)"typedefs.expanded");
    @NotNull
    private final String myType;
    private final boolean myAllowWidening;
    private final boolean myInheritsFunction;
    private final boolean myIsWidened;
    @NotNull
    private final CachedValue<JSResolvedTypeInfo> myCachedValue;

    protected JSTypeImpl(@NotNull String type, @NotNull JSTypeSource source, @NotNull JSTypeContext staticOrInstance, boolean inheritsFunction, boolean isWidened) {
        if (type == null) {
            JSTypeImpl.$$$reportNull$$$0(0);
        }
        if (source == null) {
            JSTypeImpl.$$$reportNull$$$0(1);
        }
        if (staticOrInstance == null) {
            JSTypeImpl.$$$reportNull$$$0(2);
        }
        this(type, source, staticOrInstance, inheritsFunction, isWidened, false, null);
    }

    protected JSTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator serialized) {
        if (source == null) {
            JSTypeImpl.$$$reportNull$$$0(3);
        }
        if (serialized == null) {
            JSTypeImpl.$$$reportNull$$$0(4);
        }
        super(source, serialized);
        this.myType = JSTypeSerializer.readString(serialized);
        this.myInheritsFunction = JSTypeSerializer.readBoolean(serialized);
        this.myIsWidened = JSTypeSerializer.readBoolean(serialized);
        this.myAllowWidening = JSTypeSerializer.readBoolean(serialized);
        this.myCachedValue = JSTypeImpl.createResolvedTypeInfoCachedValue(source.getSourceElement(), (Getter<JSResolvedTypeInfo>)((Getter)() -> this.resolveTypeImpl()), null);
    }

    private JSTypeImpl(@NotNull String type, @NotNull JSTypeSource source, @NotNull JSTypeContext staticOrInstance, boolean inheritsFunction, boolean isWidened, boolean allowWidening, @Nullable JSResolvedTypeInfo prevInfo) {
        if (type == null) {
            JSTypeImpl.$$$reportNull$$$0(5);
        }
        if (source == null) {
            JSTypeImpl.$$$reportNull$$$0(6);
        }
        if (staticOrInstance == null) {
            JSTypeImpl.$$$reportNull$$$0(7);
        }
        super(source, staticOrInstance);
        this.myType = type;
        this.myInheritsFunction = inheritsFunction;
        this.myIsWidened = isWidened;
        this.myAllowWidening = allowWidening;
        PsiElement element = source.getSourceElement();
        this.myCachedValue = JSTypeImpl.createResolvedTypeInfoCachedValue(element, (Getter<JSResolvedTypeInfo>)((Getter)() -> this.resolveTypeImpl()), prevInfo);
    }

    @Override
    public void serialize(@NotNull StringBuilder builder) {
        if (builder == null) {
            JSTypeImpl.$$$reportNull$$$0(8);
        }
        super.serialize(builder);
        JSTypeSerializer.writeString(this.myType, builder);
        JSTypeSerializer.writeBoolean(this.myInheritsFunction, builder);
        JSTypeSerializer.writeBoolean(this.myIsWidened, builder);
        JSTypeSerializer.writeBoolean(this.myAllowWidening, builder);
    }

    private static long calcModification(@NotNull PsiElement element) {
        if (element == null) {
            JSTypeImpl.$$$reportNull$$$0(9);
        }
        return PsiModificationTracker.SERVICE.getInstance((Project)element.getProject()).getModificationCount();
    }

    @NotNull
    private static CachedValue<JSResolvedTypeInfo> createResolvedTypeInfoCachedValue(@Nullable PsiElement element, @NotNull Getter<JSResolvedTypeInfo> builder, @Nullable JSResolvedTypeInfo prevValue) {
        if (builder == null) {
            JSTypeImpl.$$$reportNull$$$0(10);
        }
        if (JSTypeImpl.isSourceElementNotValid(element)) {
            CachedValueImpl cachedValueImpl = new CachedValueImpl(() -> {
                if (builder == null) {
                    JSTypeImpl.$$$reportNull$$$0(45);
                }
                return CachedValueProvider.Result.create((Object)builder.get(), (Object[])new Object[]{ModificationTracker.NEVER_CHANGED});
            });
            if (cachedValueImpl == null) {
                JSTypeImpl.$$$reportNull$$$0(11);
            }
            return cachedValueImpl;
        }
        long startModification = prevValue == null ? -1L : JSTypeImpl.calcModification(element);
        CachedValue cachedValue = CachedValuesManager.getManager((Project)element.getProject()).createCachedValue(() -> {
            void builder;
            if (builder == null) {
                JSTypeImpl.$$$reportNull$$$0(44);
            }
            if (prevValue != null && JSTypeImpl.calcModification(element) == startModification) {
                return CachedValueProvider.Result.create((Object)prevValue, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
            }
            return CachedValueProvider.Result.create((Object)builder.get(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
        }, false);
        if (cachedValue == null) {
            JSTypeImpl.$$$reportNull$$$0(12);
        }
        return cachedValue;
    }

    @Override
    @NotNull
    public final JSResolvedTypeInfo resolveType() {
        JSResolvedTypeInfo jSResolvedTypeInfo = (JSResolvedTypeInfo)this.myCachedValue.getValue();
        if (jSResolvedTypeInfo == null) {
            JSTypeImpl.$$$reportNull$$$0(13);
        }
        return jSResolvedTypeInfo;
    }

    @NotNull
    private JSResolvedTypeInfo resolveTypeImpl() {
        PsiElement sourceElement = this.getSource().getSourceElement();
        if (JSTypeImpl.isSourceElementNotValid(sourceElement)) {
            JSResolvedTypeInfoImpl jSResolvedTypeInfoImpl = new JSResolvedTypeInfoImpl(this.myType, ContainerUtil.emptyList());
            if (jSResolvedTypeInfoImpl == null) {
                JSTypeImpl.$$$reportNull$$$0(14);
            }
            return jSResolvedTypeInfoImpl;
        }
        JSContext context = this.getTypeContext().toJSContext();
        JSTypeResolveResult result2 = JSDialectSpecificHandlersFactory.forElement(sourceElement).getImportHandler().resolveMainElementName(this.myType, sourceElement, context);
        JSResolvedTypeInfoImpl jSResolvedTypeInfoImpl = new JSResolvedTypeInfoImpl(result2.getQualifiedName(), result2.getElements());
        if (jSResolvedTypeInfoImpl == null) {
            JSTypeImpl.$$$reportNull$$$0(15);
        }
        return jSResolvedTypeInfoImpl;
    }

    @Override
    @Deprecated
    @Nullable
    public JSClass resolveClass() {
        PsiElement clazz;
        if (!this.isEcma()) {
            return null;
        }
        ProgressManager.checkCanceled();
        String qualifiedType = this.myType;
        JSTypeSource source = this.getSource();
        PsiElement element = source.getSourceElement();
        PsiElement resolvedElement = null;
        if (element != null) {
            JSImportHandler importHandler = JSDialectSpecificHandlersFactory.forElement((PsiElement)this.getScope()).getImportHandler();
            JSTypeResolveResult result2 = importHandler.resolveTypeName(this.myType, element);
            qualifiedType = result2.getQualifiedName();
            Iterator<? extends PsiElement> iterator = result2.getElements().iterator();
            if (iterator.hasNext()) {
                resolvedElement = iterator.next();
            }
        }
        PsiElement psiElement = clazz = resolvedElement != null ? resolvedElement : JSResolveUtil.findType(qualifiedType, (PsiElement)this.getScope(), true);
        if (clazz instanceof JSClass) {
            return (JSClass)clazz;
        }
        return null;
    }

    @Override
    @NotNull
    public final String getResolvedTypeText() {
        PsiElement sourceElement = this.getSource().getSourceElement();
        if (JSTypeImpl.isSourceElementNotValid(sourceElement)) {
            String string = this.myType;
            if (string == null) {
                JSTypeImpl.$$$reportNull$$$0(16);
            }
            return string;
        }
        JSResolvedTypeInfo resolvedType = this.resolveType();
        String string = resolvedType.getResolvedTypeText();
        if (string == null) {
            JSTypeImpl.$$$reportNull$$$0(17);
        }
        return string;
    }

    public static boolean isSourceElementNotValid(PsiElement sourceElement) {
        return sourceElement == null || !sourceElement.isValid();
    }

    @Nullable
    public static JSType fromElement(PsiElement element, PsiElement context) {
        JSType type = null;
        if (element instanceof JSVariable) {
            type = ((JSVariable)element).getType();
        } else if (element instanceof JSFunction) {
            type = JSFunctionImpl.getReturnTypeInContext((JSFunctionItem)((JSFunction)element), JSTypeUtils.getScopeInOriginalTree(context));
        }
        return type;
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if (format == JSType.TypeTextFormat.RESOLVED || format == JSType.TypeTextFormat.CODE) {
            String qualifiedName = this.getResolvedTypeText();
            if (format == JSType.TypeTextFormat.CODE && TypeScriptUtil.hasAmbientExternalModuleInQName(qualifiedName)) {
                String string = this.myType;
                if (string == null) {
                    JSTypeImpl.$$$reportNull$$$0(18);
                }
                return string;
            }
            String string = qualifiedName;
            if (string == null) {
                JSTypeImpl.$$$reportNull$$$0(19);
            }
            return string;
        }
        String string = this.myType;
        if (string == null) {
            JSTypeImpl.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        String qualifiedName;
        TypeScriptEnum parentEnumElement;
        TypeScriptEnumField field;
        JSType typedefValue;
        if (elementType == null) {
            JSTypeImpl.$$$reportNull$$$0(21);
        }
        if (processingContext == null) {
            JSTypeImpl.$$$reportNull$$$0(22);
        }
        if (this.getSource().isStrict() && !this.isEcma() && (typedefValue = this.getJSTypedef()) != null) {
            return typedefValue.isDirectlyAssignableType(elementType, processingContext);
        }
        JSResolvedTypeInfo resolvedType = this.resolveType();
        if (elementType instanceof JSNumberType && resolvedType.isEnum()) {
            return true;
        }
        boolean isEnumLiteral = resolvedType.isEnumLiteral();
        boolean otherIsEnumLiteral = false;
        boolean otherIsEnum = false;
        JSResolvedTypeInfo resolvedOtherType = null;
        if (elementType instanceof JSTypeImpl) {
            resolvedOtherType = ((JSTypeImpl)elementType).resolveType();
            otherIsEnumLiteral = resolvedOtherType.isEnumLiteral();
            otherIsEnum = resolvedOtherType.isEnum();
        }
        if (isEnumLiteral && otherIsEnumLiteral) {
            TypeScriptEnum otherEnum;
            TypeScriptEnumField ownField = resolvedType.getDeclarationOfType(TypeScriptEnumField.class);
            TypeScriptEnumField otherField = resolvedOtherType.getDeclarationOfType(TypeScriptEnumField.class);
            if (ownField == null || otherField == null) {
                return false;
            }
            TypeScriptEnum ownEnum = ownField.getOwner();
            if (!Objects.equals(ownEnum, otherEnum = otherField.getOwner())) {
                return false;
            }
            EnumConstantValue ownConstantValue = ownField.getConstantValue();
            EnumConstantValue otherConstantValue = otherField.getConstantValue();
            Double ownDouble = ownConstantValue.getNumericValue();
            Double otherDouble = otherConstantValue.getNumericValue();
            if (ownDouble != null && otherDouble != null && Objects.equals(ownDouble, otherDouble)) {
                return true;
            }
            String ownString = ownConstantValue.getStringValue();
            String otherString = otherConstantValue.getStringValue();
            if (ownString != null && otherString != null && Objects.equals(ownString, otherString)) {
                return true;
            }
            BigInteger ownBigInt = ownConstantValue.getBigIntValue();
            BigInteger otherBigInt = otherConstantValue.getBigIntValue();
            return ownBigInt != null && otherBigInt != null && Objects.equals(ownBigInt, otherBigInt);
        }
        if (otherIsEnumLiteral && resolvedType.isEnum() && (field = resolvedOtherType.getDeclarationOfType(TypeScriptEnumField.class)) != null && (parentEnumElement = (TypeScriptEnum)PsiTreeUtil.getContextOfType((PsiElement)field, (Class[])new Class[]{TypeScriptEnum.class})) != null && (qualifiedName = parentEnumElement.getQualifiedName()) != null) {
            return this.isDirectlyAssignableType(JSNamedTypeFactory.createExplicitlyDeclaredType(qualifiedName, (PsiElement)parentEnumElement), processingContext);
        }
        if (isEnumLiteral && otherIsEnum) {
            return false;
        }
        if (elementType instanceof JSNumberType && isEnumLiteral) {
            field = resolvedType.getDeclarationOfType(TypeScriptEnumField.class);
            if (field == null) {
                return false;
            }
            Double value = field.getConstantValue().getNumericValue();
            return value != null;
        }
        if (elementType instanceof JSStringLiteralTypeImpl && isEnumLiteral) {
            return false;
        }
        if (!otherIsEnum && isEnumLiteral && !JSTypeUtils.hasForeignGenericParameter(elementType)) {
            return false;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult result2;
        if (elementType == null) {
            JSTypeImpl.$$$reportNull$$$0(23);
        }
        if (processingContext == null) {
            JSTypeImpl.$$$reportNull$$$0(24);
        }
        if ((result2 = super.isDirectlyAssignableTypeCommon(elementType, processingContext)).isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult = result2;
            if (assignableResult == null) {
                JSTypeImpl.$$$reportNull$$$0(25);
            }
            return assignableResult;
        }
        if (elementType instanceof JSTypeImpl) {
            JSTypeImpl elementTypeImpl = (JSTypeImpl)elementType;
            JSTypeContext elementTypeContext = elementTypeImpl.getTypeContext();
            if (this.getTypeContext() == JSTypeContext.STATIC && elementTypeContext == JSTypeContext.STATIC) {
                JSResolvedTypeInfo resolvedType1 = this.resolveType();
                JSResolvedTypeInfo resolvedType2 = ((JSTypeImpl)elementType).resolveType();
                if (!resolvedType1.isAbstract() && resolvedType2.isAbstract()) {
                    JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.NOT_ASSIGNABLE;
                    if (assignableResult == null) {
                        JSTypeImpl.$$$reportNull$$$0(26);
                    }
                    return assignableResult;
                }
            }
        }
        JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(this.getTypeHelper().isAssignableToNamedType(this, elementType, processingContext));
        if (assignableResult == null) {
            JSTypeImpl.$$$reportNull$$$0(27);
        }
        return assignableResult;
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSTypeImpl.$$$reportNull$$$0(28);
        }
        if (!super.isEquivalentToWithSameClass(type, processingContext, allowResolve)) {
            return false;
        }
        if (this.getSource().getLanguage() != type.getSource().getLanguage()) {
            return false;
        }
        JSTypeImpl jsType = (JSTypeImpl)type;
        if (this.getJSContext() != jsType.getJSContext()) {
            return false;
        }
        if (!allowResolve) {
            return this.getTypeText().equals(type.getTypeText());
        }
        return this.getResolvedTypeText().equals(type.getResolvedTypeText()) && (this.isEcma() || Objects.equals(this.resolveType(), jsType.resolveType()));
    }

    @Nullable
    public JSType getJSTypedef() {
        JSResolvedTypeInfo resolvedType = this.resolveType();
        if (resolvedType.getAliasedType() != null) {
            return null;
        }
        String text = resolvedType.getResolvedTypeText();
        JSResolvedTypeId id = this.getResolvedTypeId();
        Ref value = id.getLocalCachedValue(ourTypedefsExpandedKey, () -> Ref.create((Object)JSTypeEvaluateManager.expandTypedefs((PsiElement)this.getScope(), text)));
        assert (value != null);
        return (JSType)value.get();
    }

    @Override
    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSTypeImpl((JSType)this);
    }

    public boolean inheritsFunction() {
        return this.myInheritsFunction;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeImpl.$$$reportNull$$$0(29);
        }
        boolean sameContext = source.getSourceElement() == this.getSource().getSourceElement();
        JSTypeImpl jSTypeImpl = new JSTypeImpl(this.getTypeText(), source, this.getTypeContext(), this.myInheritsFunction, this.myIsWidened, false, sameContext ? this.getCachedResolvedTypeInfo() : null);
        if (jSTypeImpl == null) {
            JSTypeImpl.$$$reportNull$$$0(30);
        }
        return jSTypeImpl;
    }

    @Nullable
    private JSResolvedTypeInfo getCachedResolvedTypeInfo() {
        return this.myCachedValue.hasUpToDateValue() ? this.resolveType() : null;
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType jSType = JSTypeImpl.expandTypeOrBuildRecordTypeWithCache(this);
        if (jSType == null) {
            JSTypeImpl.$$$reportNull$$$0(31);
        }
        return jSType;
    }

    @NotNull
    public static JSType expandTypeOrBuildRecordTypeWithCache(@NotNull JSTypeBaseImpl type) {
        if (type == null) {
            JSTypeImpl.$$$reportNull$$$0(32);
        }
        if (type.isEcma()) {
            JSTypeBaseImpl jSTypeBaseImpl = type;
            if (jSTypeBaseImpl == null) {
                JSTypeImpl.$$$reportNull$$$0(33);
            }
            return jSTypeBaseImpl;
        }
        JSType expanded = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type);
        if (expanded instanceof JSWrapperType) {
            expanded = ((JSWrapperType)expanded).getOriginalType();
        }
        if (expanded != type || type.isJavaScript()) {
            JSType jSType = expanded;
            if (jSType == null) {
                JSTypeImpl.$$$reportNull$$$0(34);
            }
            return jSType;
        }
        if (type instanceof JSTypeImpl) {
            type = ((JSTypeImpl)type).copyWithAllowWidening(false);
        }
        JSTypeBaseImpl finalType = type;
        JSType jSType = type.getLocalCachedType(() -> {
            Collection<? extends PsiElement> elements = TypeScriptTypeParser.resolveElementsByType(finalType);
            if (elements.size() == 0 && TypeScriptUtil.isImportType(finalType)) {
                return JSAnyType.get(finalType.getSource());
            }
            return TypeScriptTypeParser.buildResolvedType(elements, finalType);
        }, RECORD_TYPE_CACHE);
        if (jSType == null) {
            JSTypeImpl.$$$reportNull$$$0(35);
        }
        return jSType;
    }

    @NotNull
    public JSTypeImpl copyWithAllowWidening(boolean allowWidening) {
        if (this.myAllowWidening == allowWidening) {
            JSTypeImpl jSTypeImpl = this;
            if (jSTypeImpl == null) {
                JSTypeImpl.$$$reportNull$$$0(36);
            }
            return jSTypeImpl;
        }
        if (allowWidening && !this.myType.contains(".")) {
            JSTypeImpl jSTypeImpl = this;
            if (jSTypeImpl == null) {
                JSTypeImpl.$$$reportNull$$$0(37);
            }
            return jSTypeImpl;
        }
        JSResolvedTypeInfo info = this.getCachedResolvedTypeInfo();
        JSTypeImpl jSTypeImpl = new JSTypeImpl(this.getTypeText(), this.getSource(), this.getTypeContext(), this.myInheritsFunction, this.myIsWidened, allowWidening, info);
        if (jSTypeImpl == null) {
            JSTypeImpl.$$$reportNull$$$0(38);
        }
        return jSTypeImpl;
    }

    @Override
    protected int resolvedHashCodeImpl() {
        return Objects.hash(this.getClass(), this.myInheritsFunction, this.isTypeScript(), super.resolvedHashCodeImpl(), this.allowWidening(), this.isWidened());
    }

    @NotNull
    public JSType widen(boolean allowResolve) {
        if (!this.myAllowWidening) {
            JSTypeImpl jSTypeImpl = this;
            if (jSTypeImpl == null) {
                JSTypeImpl.$$$reportNull$$$0(39);
            }
            return jSTypeImpl;
        }
        if (allowResolve) {
            JSResolvedTypeInfo info = this.resolveType();
            if (info.isEnumLiteral()) {
                JSType jSType = TypeScriptUtil.getBaseTypeOfEnumLiteralType(this);
                if (jSType == null) {
                    JSTypeImpl.$$$reportNull$$$0(40);
                }
                return jSType;
            }
            JSTypeImpl jSTypeImpl = this;
            if (jSTypeImpl == null) {
                JSTypeImpl.$$$reportNull$$$0(41);
            }
            return jSTypeImpl;
        }
        if (this.myIsWidened) {
            JSTypeImpl jSTypeImpl = this;
            if (jSTypeImpl == null) {
                JSTypeImpl.$$$reportNull$$$0(42);
            }
            return jSTypeImpl;
        }
        JSTypeImpl jSTypeImpl = new JSTypeImpl(this.getTypeText(), this.getSource(), this.getTypeContext(), this.myInheritsFunction, true, false, this.getCachedResolvedTypeInfo());
        if (jSTypeImpl == null) {
            JSTypeImpl.$$$reportNull$$$0(43);
        }
        return jSTypeImpl;
    }

    public boolean allowWidening() {
        return this.myAllowWidening;
    }

    public boolean isWidened() {
        return this.myIsWidened;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticOrInstance";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serialized";
                break;
            }
            case 8: 
            case 10: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeImpl";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeImpl";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createResolvedTypeInfoCachedValue";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTypeImpl";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedTypeText";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "expandTypeOrBuildRecordTypeWithCache";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithAllowWidening";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "widen";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calcModification";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createResolvedTypeInfoCachedValue";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "expandTypeOrBuildRecordTypeWithCache";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createResolvedTypeInfoCachedValue$3";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createResolvedTypeInfoCachedValue$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

