/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.functionmetrics;

import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmptyStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSStatement;
import org.jetbrains.annotations.NotNull;

class StatementCountVisitor
extends JSRecursiveElementVisitor {
    private int statementCount = 0;

    StatementCountVisitor() {
    }

    public void visitJSElement(JSElement jsElement) {
        int oldCount = 0;
        if (jsElement instanceof JSFunction) {
            oldCount = this.statementCount;
        }
        super.visitJSElement(jsElement);
        if (jsElement instanceof JSFunction) {
            this.statementCount = oldCount;
        }
    }

    public void visitJSStatement(@NotNull JSStatement statement) {
        if (statement == null) {
            StatementCountVisitor.$$$reportNull$$$0(0);
        }
        super.visitJSStatement(statement);
        if (statement instanceof JSEmptyStatement || statement instanceof JSBlockStatement) {
            return;
        }
        ++this.statementCount;
    }

    public int getStatementCount() {
        return this.statementCount;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/functionmetrics/StatementCountVisitor", "visitJSStatement"));
    }
}

