/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha.execution;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.javascript.testFramework.JsTestFileByTestNameIndex;
import com.intellij.javascript.testFramework.exports.ExportsTestFileStructure;
import com.intellij.javascript.testFramework.exports.ExportsTestFileStructureBuilder;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructure;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructureBuilder;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructure;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructureBuilder;
import com.intellij.javascript.testFramework.util.EscapeUtils;
import com.intellij.javascript.testFramework.util.JsTestFqn;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTestFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MochaTestLocationProvider
implements SMTestLocator {
    private static final String SUITE_PROTOCOL_ID = "suite";
    private static final String TEST_PROTOCOL_ID = "test";
    private static final char SPLIT_CHAR = '.';
    private final String myUi;

    public MochaTestLocationProvider(@NotNull String ui) {
        if (ui == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(0);
        }
        this.myUi = ui;
    }

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        boolean suite;
        if (protocol == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(1);
        }
        if (path == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(4);
        }
        if ((suite = SUITE_PROTOCOL_ID.equals(protocol)) || TEST_PROTOCOL_ID.equals(protocol)) {
            Location location = this.getTestLocation(project, path, suite);
            List list = ContainerUtil.createMaybeSingletonList((Object)location);
            if (list == null) {
                MochaTestLocationProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<Location> list = Collections.emptyList();
        if (list == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    private Location getTestLocation(@NotNull Project project, @NotNull String locationData, boolean isSuite) {
        List path;
        if (project == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(7);
        }
        if (locationData == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(8);
        }
        if ((path = EscapeUtils.split((String)locationData, (char)'.')).size() < 2) {
            return null;
        }
        PsiElement psiElement = "bdd".equals(this.myUi) ? MochaTestLocationProvider.findJasmineElement(project, path, isSuite) : ("qunit".equals(this.myUi) ? MochaTestLocationProvider.findQUnitElement(project, path, isSuite) : ("exports".equals(this.myUi) ? MochaTestLocationProvider.findExportsElement(project, path) : ("tdd".equals(this.myUi) || "mocha-typescript".equals(this.myUi) ? MochaTestLocationProvider.findTddElement(project, path, isSuite) : this.findAppropriateElement(project, path, isSuite))));
        if (psiElement != null) {
            return PsiLocation.fromPsiElement((PsiElement)psiElement);
        }
        return null;
    }

    private PsiElement findAppropriateElement(Project project, @NotNull List<String> path, boolean suite) {
        PsiElement element;
        if (path == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(9);
        }
        String lowerCasedUi = this.myUi.toLowerCase(Locale.ENGLISH);
        boolean bdd = false;
        boolean qUnit = false;
        boolean exports = false;
        if (lowerCasedUi.contains("bdd")) {
            bdd = true;
            element = MochaTestLocationProvider.findJasmineElement(project, path, suite);
            if (element != null) {
                return element;
            }
        }
        if (lowerCasedUi.contains("qunit")) {
            qUnit = true;
            element = MochaTestLocationProvider.findQUnitElement(project, path, suite);
            if (element != null) {
                return element;
            }
        }
        if (lowerCasedUi.contains("exports")) {
            exports = true;
            element = MochaTestLocationProvider.findExportsElement(project, path);
            if (element != null) {
                return element;
            }
        }
        if (!bdd && (element = MochaTestLocationProvider.findJasmineElement(project, path, suite)) != null) {
            return element;
        }
        if (!qUnit && (element = MochaTestLocationProvider.findQUnitElement(project, path, suite)) != null) {
            return element;
        }
        if (!exports && (element = MochaTestLocationProvider.findExportsElement(project, path)) != null) {
            return element;
        }
        return null;
    }

    @Nullable
    private static PsiElement findJasmineElement(Project project, @NotNull List<String> location, boolean suite) {
        if (location == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(10);
        }
        VirtualFile executedFile = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)location.get(0)));
        JsTestFqn testFqn = new JsTestFqn(JSTestFileType.JASMINE, location.subList(1, location.size()));
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        List jsTestVirtualFiles = JsTestFileByTestNameIndex.findFiles((JsTestFqn)testFqn, (GlobalSearchScope)scope, (VirtualFile)executedFile);
        for (VirtualFile file : jsTestVirtualFiles) {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (!(psiFile instanceof JSFile)) continue;
            JSFile jsFile = (JSFile)psiFile;
            JasmineFileStructureBuilder builder = JasmineFileStructureBuilder.getInstance();
            JasmineFileStructure jasmineFileStructure = (JasmineFileStructure)builder.fetchCachedTestFileStructure(jsFile);
            PsiElement element = jasmineFileStructure.findPsiElement(testFqn.getNames(), null);
            if (element == null || !element.isValid()) continue;
            return element;
        }
        return null;
    }

    @Nullable
    private static PsiElement findQUnitElement(@NotNull Project project, @NotNull List<String> location, boolean suite) {
        String testName;
        String moduleName;
        if (project == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(11);
        }
        if (location == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(12);
        }
        VirtualFile executedFile = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)location.get(0)));
        if (suite) {
            moduleName = location.get(1);
            testName = null;
        } else if (location.size() > 2) {
            moduleName = location.get(1);
            testName = location.get(2);
        } else {
            moduleName = "Default Module";
            testName = location.get(1);
        }
        String key = JsTestFileByTestNameIndex.createQUnitKey((String)moduleName, testName);
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        List jsTestVirtualFiles = JsTestFileByTestNameIndex.findFilesByKey((String)key, (GlobalSearchScope)scope, (VirtualFile)executedFile);
        for (VirtualFile file : jsTestVirtualFiles) {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (!(psiFile instanceof JSFile)) continue;
            JSFile jsFile = (JSFile)psiFile;
            QUnitFileStructureBuilder builder = QUnitFileStructureBuilder.getInstance();
            QUnitFileStructure qunitFileStructure = (QUnitFileStructure)builder.fetchCachedTestFileStructure(jsFile);
            PsiElement element = qunitFileStructure.findPsiElement(moduleName, testName);
            if (element == null || !element.isValid()) continue;
            return element;
        }
        return null;
    }

    @Nullable
    private static PsiElement findExportsElement(@NotNull Project project, @NotNull List<String> location) {
        JSFile file;
        if (project == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(13);
        }
        if (location == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(14);
        }
        if ((file = MochaTestLocationProvider.findJSFile(project, location)) == null) {
            return null;
        }
        ExportsTestFileStructure structure = (ExportsTestFileStructure)ExportsTestFileStructureBuilder.getInstance().fetchCachedTestFileStructure(file);
        List<String> path = location.subList(1, location.size());
        return structure.findPsiElement(path);
    }

    @Nullable
    private static PsiElement findTddElement(@NotNull Project project, @NotNull List<String> location, boolean suite) {
        if (project == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(15);
        }
        if (location == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(16);
        }
        VirtualFile executedFile = LocalFileSystem.getInstance().findFileByPath(location.get(0));
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        List<String> names = location.subList(1, location.size());
        JsTestFqn testFqn = new JsTestFqn(JSTestFileType.TDD, names);
        List jsTestVirtualFiles = JsTestFileByTestNameIndex.findFiles((JsTestFqn)testFqn, (GlobalSearchScope)scope, (VirtualFile)executedFile);
        for (VirtualFile file : jsTestVirtualFiles) {
            String testName;
            List<String> suiteNames;
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (!(psiFile instanceof JSFile)) continue;
            JSFile jsFile = (JSFile)psiFile;
            MochaTddFileStructure structure = (MochaTddFileStructure)MochaTddFileStructureBuilder.getInstance().fetchCachedTestFileStructure(jsFile);
            PsiElement element = structure.findPsiElement(suiteNames = suite ? names : names.subList(0, names.size() - 1), testName = suite ? null : (String)ContainerUtil.getLastItem(names));
            if (element == null || !element.isValid()) continue;
            return element;
        }
        return null;
    }

    @Nullable
    private static JSFile findJSFile(@NotNull Project project, @NotNull List<String> location) {
        String filePath;
        if (project == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(17);
        }
        if (location == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(18);
        }
        if (StringUtil.isEmptyOrSpaces((String)(filePath = location.get(0)))) {
            return null;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (file == null || !file.isValid()) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        return (JSFile)ObjectUtils.tryCast((Object)psiFile, JSFile.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/mocha/execution/MochaTestLocationProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationData";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/mocha/execution/MochaTestLocationProvider";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTestLocation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findAppropriateElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findJasmineElement";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findQUnitElement";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findExportsElement";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findTddElement";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findJSFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

