/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.behat.run;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.php.behat.BehatUtil;
import com.jetbrains.php.behat.run.BehatRunConfiguration;
import com.jetbrains.php.behat.run.BehatRunConfigurationType;
import com.jetbrains.php.testFramework.run.PhpTestRunConfigurationSettings;
import com.jetbrains.php.testFramework.run.PhpTestRunnerSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinFeature;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinFileType;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;

public class BehatRuntimeConfigurationProducer
extends RunConfigurationProducer<BehatRunConfiguration> {
    public BehatRuntimeConfigurationProducer() {
        super((ConfigurationType)BehatRunConfigurationType.getInstance());
    }

    protected boolean setupConfigurationFromContext(BehatRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        Location location = context.getLocation();
        if (!(location instanceof PsiLocation)) {
            return false;
        }
        PsiElement originalElement = location.getPsiElement();
        PsiElement element = BehatRuntimeConfigurationProducer.findTestElement(originalElement);
        if (element == null) {
            return false;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (virtualFile == null) {
            return false;
        }
        PhpTestRunConfigurationSettings settings = (PhpTestRunConfigurationSettings)configuration.getSettings();
        PhpTestRunnerSettings testRunnerSettings = settings.getRunnerSettings();
        if (element instanceof GherkinFeature) {
            testRunnerSettings.setScope(PhpTestRunnerSettings.Scope.File);
            testRunnerSettings.setFilePath(virtualFile.getPresentableUrl());
        } else if (element instanceof PsiDirectory) {
            testRunnerSettings.setScope(PhpTestRunnerSettings.Scope.Directory);
            testRunnerSettings.setDirectoryPath(virtualFile.getPresentableUrl());
        } else if (element instanceof GherkinStepsHolder) {
            testRunnerSettings.setFilePath(virtualFile.getPresentableUrl());
            testRunnerSettings.setScope(PhpTestRunnerSettings.Scope.Method);
            testRunnerSettings.setFilePath(virtualFile.getPresentableUrl());
            testRunnerSettings.setMethodName(BehatUtil.getScenarioName((GherkinStepsHolder)element));
        } else {
            return false;
        }
        sourceElement.set((Object)element);
        configuration.setName(configuration.suggestedName());
        return true;
    }

    public boolean isConfigurationFromContext(BehatRunConfiguration configuration, ConfigurationContext context) {
        PsiFile psiFile;
        VirtualFile virtualFile;
        Location location = context.getLocation();
        if (location == null) {
            return false;
        }
        PsiElement psiElement = BehatRuntimeConfigurationProducer.findTestElement(location.getPsiElement());
        if (psiElement instanceof PsiDirectory) {
            String directoryPath = ((PsiDirectory)psiElement).getVirtualFile().getPath();
            PhpTestRunConfigurationSettings settings = (PhpTestRunConfigurationSettings)configuration.getSettings();
            PhpTestRunnerSettings testRunnerSettings = settings.getRunnerSettings();
            String path = testRunnerSettings.getDirectoryPath();
            return testRunnerSettings.getScope() == PhpTestRunnerSettings.Scope.Directory && path != null && FileUtil.comparePaths((String)directoryPath, (String)FileUtil.toSystemIndependentName((String)path)) == 0;
        }
        if (psiElement instanceof GherkinFeature) {
            PsiFile psiFile2 = psiElement.getContainingFile();
            VirtualFile virtualFile2 = psiFile2.getVirtualFile();
            if (virtualFile2 != null) {
                String path = virtualFile2.getPath();
                PhpTestRunConfigurationSettings settings = (PhpTestRunConfigurationSettings)configuration.getSettings();
                PhpTestRunnerSettings testRunnerSettings = settings.getRunnerSettings();
                String filePath = testRunnerSettings.getFilePath();
                return testRunnerSettings.getScope() == PhpTestRunnerSettings.Scope.File && filePath != null && FileUtil.comparePaths((String)path, (String)FileUtil.toSystemIndependentName((String)filePath)) == 0;
            }
        } else if (psiElement instanceof GherkinStepsHolder && (virtualFile = (psiFile = psiElement.getContainingFile()).getVirtualFile()) != null) {
            String path = virtualFile.getPath();
            PhpTestRunConfigurationSettings settings = (PhpTestRunConfigurationSettings)configuration.getSettings();
            PhpTestRunnerSettings testRunnerSettings = settings.getRunnerSettings();
            String filePath = testRunnerSettings.getFilePath();
            String scenarioName = BehatUtil.getScenarioName((GherkinStepsHolder)psiElement);
            return testRunnerSettings.getScope() == PhpTestRunnerSettings.Scope.Method && filePath != null && FileUtil.comparePaths((String)path, (String)FileUtil.toSystemIndependentName((String)filePath)) == 0 && StringUtil.equals((CharSequence)scenarioName, (CharSequence)testRunnerSettings.getMethodName());
        }
        return false;
    }

    @Nullable
    public static PsiElement findTestElement(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof PsiDirectory) {
            return BehatRuntimeConfigurationProducer.checkDirectoryContainsGherkinFiles(element.getProject(), ((PsiDirectory)element).getVirtualFile()) ? element : null;
        }
        GherkinStepsHolder stepsHolder = (GherkinStepsHolder)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{GherkinStepsHolder.class});
        if (stepsHolder != null && BehatUtil.isRunnableStepHolder(stepsHolder)) {
            return stepsHolder;
        }
        GherkinFeature feature = (GherkinFeature)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{GherkinFeature.class});
        if (feature != null) {
            return feature;
        }
        PsiFile file = element.getContainingFile();
        if (file != null && file.isValid() && file instanceof GherkinFile) {
            return PsiTreeUtil.getChildOfType((PsiElement)file, GherkinFeature.class);
        }
        return null;
    }

    public static boolean checkDirectoryContainsGherkinFiles(@NotNull Project project, @NotNull VirtualFile directory) {
        Module module;
        if (project == null) {
            BehatRuntimeConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (directory == null) {
            BehatRuntimeConfigurationProducer.$$$reportNull$$$0(1);
        }
        if ((module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(directory)) != null) {
            GlobalSearchScope scope = module.getModuleContentWithDependenciesScope().intersectWith(GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)directory, (boolean)true));
            return FileTypeIndex.getFiles((FileType)GherkinFileType.INSTANCE, (GlobalSearchScope)scope).size() > 0;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "directory";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/behat/run/BehatRuntimeConfigurationProducer";
        objectArray[2] = "checkDirectoryContainsGherkinFiles";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

