/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.ListUtil;
import com.intellij.ui.RowsDnDSupport;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.ui.EditableModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nullable;

class ListToolbarDecorator
extends ToolbarDecorator {
    private final JList myList;
    private final EditableModel myEditableModel;

    ListToolbarDecorator(JList list, @Nullable EditableModel editableModel) {
        this.myList = list;
        this.myEditableModel = editableModel;
        this.myDownActionEnabled = true;
        this.myUpActionEnabled = true;
        this.myRemoveActionEnabled = true;
        this.myAddActionEnabled = true;
        this.createActions();
        this.myList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListToolbarDecorator.this.updateButtons();
            }
        });
        this.myList.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ListToolbarDecorator.this.updateButtons();
            }
        });
    }

    private void createActions() {
        this.myRemoveAction = new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ListUtil.removeSelectedItems(ListToolbarDecorator.this.myList);
                ListToolbarDecorator.this.updateButtons();
            }
        };
        this.myUpAction = new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ListUtil.moveSelectedItemsUp(ListToolbarDecorator.this.myList);
                ListToolbarDecorator.this.updateButtons();
            }
        };
        this.myDownAction = new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ListUtil.moveSelectedItemsDown(ListToolbarDecorator.this.myList);
                ListToolbarDecorator.this.updateButtons();
            }
        };
    }

    @Override
    protected JComponent getComponent() {
        return this.myList;
    }

    @Override
    protected void updateButtons() {
        CommonActionsPanel p = this.getActionsPanel();
        if (p != null) {
            boolean someElementSelected;
            if (this.myList.isEnabled()) {
                int index2 = this.myList.getSelectedIndex();
                boolean bl = someElementSelected = 0 <= index2 && index2 < this.myList.getModel().getSize();
                if (someElementSelected) {
                    boolean downEnable = this.myList.getMaxSelectionIndex() < this.myList.getModel().getSize() - 1;
                    boolean upEnable = this.myList.getMinSelectionIndex() > 0;
                    boolean editEnabled = this.myList.getSelectedIndices().length == 1;
                    p.setEnabled(CommonActionsPanel.Buttons.EDIT, editEnabled);
                    p.setEnabled(CommonActionsPanel.Buttons.UP, upEnable);
                    p.setEnabled(CommonActionsPanel.Buttons.DOWN, downEnable);
                } else {
                    p.setEnabled(CommonActionsPanel.Buttons.EDIT, false);
                    p.setEnabled(CommonActionsPanel.Buttons.UP, false);
                    p.setEnabled(CommonActionsPanel.Buttons.DOWN, false);
                }
                p.setEnabled(CommonActionsPanel.Buttons.ADD, true);
            } else {
                someElementSelected = false;
                p.setEnabled(CommonActionsPanel.Buttons.ADD, false);
                p.setEnabled(CommonActionsPanel.Buttons.UP, false);
                p.setEnabled(CommonActionsPanel.Buttons.DOWN, false);
            }
            p.setEnabled(CommonActionsPanel.Buttons.REMOVE, someElementSelected);
            this.updateExtraElementActions(someElementSelected);
        }
    }

    @Override
    public ToolbarDecorator setVisibleRowCount(int rowCount) {
        this.myList.setVisibleRowCount(rowCount);
        return this;
    }

    @Override
    protected boolean isModelEditable() {
        return this.myEditableModel != null || this.myList.getModel() instanceof EditableModel;
    }

    @Override
    protected void installDnDSupport() {
        RowsDnDSupport.install(this.myList, this.myEditableModel != null ? this.myEditableModel : (EditableModel)this.myList.getModel());
    }
}

