/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser;

import java.io.IOException;
import java.io.Reader;
import org.jrubyparser.CompatVersion;
import org.jrubyparser.IRubyWarnings;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.Node;
import org.jrubyparser.lexer.LexerSource;
import org.jrubyparser.lexer.SyntaxException;
import org.jrubyparser.parser.ParserConfiguration;
import org.jrubyparser.parser.ParserResult;
import org.jrubyparser.parser.Ruby18Parser;
import org.jrubyparser.parser.Ruby19Parser;
import org.jrubyparser.parser.Ruby20Parser;
import org.jrubyparser.parser.RubyParser;

public class Parser {
    private volatile long totalTime;
    private volatile int totalBytes;

    public long getTotalTime() {
        return this.totalTime;
    }

    public int getTotalBytes() {
        return this.totalBytes;
    }

    public Node parse(String file, Reader content, ParserConfiguration configuration) throws SyntaxException {
        long startTime = System.nanoTime();
        RubyParser parser = configuration.getVersion() == CompatVersion.RUBY1_8 ? new Ruby18Parser() : (configuration.getVersion() == CompatVersion.RUBY1_9 ? new Ruby19Parser() : new Ruby20Parser());
        parser.setWarnings(new NullWarnings());
        LexerSource lexerSource = LexerSource.getSource(file, content, configuration);
        Node ast = null;
        try {
            ParserResult result = parser.parse(configuration, lexerSource);
            if (configuration.getSyntax() != ParserConfiguration.SyntaxGathering.NONE) {
                result.weaveInExtraSyntax();
            }
            ast = result.getAST();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.totalTime += System.nanoTime() - startTime;
        this.totalBytes += lexerSource.getOffset();
        return ast;
    }

    public static class NullWarnings
    implements IRubyWarnings {
        public boolean isVerbose() {
            return false;
        }

        public void warn(IRubyWarnings.ID id, String message, Object ... data) {
        }

        public void warning(IRubyWarnings.ID id, String message, Object ... data) {
        }

        public void warn(IRubyWarnings.ID id, SourcePosition position, String message, Object ... data) {
        }

        public void warn(IRubyWarnings.ID id, String fileName, int lineNumber, String message, Object ... data) {
        }

        public void warning(IRubyWarnings.ID id, SourcePosition position, String message, Object ... data) {
        }

        public void warning(IRubyWarnings.ID id, String fileName, int lineNumber, String message, Object ... data) {
        }
    }
}

