/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchPath {
    public final List<ObjectPath> elements;

    private SearchPath(@NotNull List<ObjectPath> elements) {
        if (elements == null) {
            SearchPath.$$$reportNull$$$0(0);
        }
        this.elements = elements;
    }

    @NotNull
    public ObjectPath getCurrent() {
        ObjectPath objectPath = this.elements.get(0);
        if (objectPath == null) {
            SearchPath.$$$reportNull$$$0(1);
        }
        return objectPath;
    }

    @Contract(value="!null->!null")
    public static SearchPath of(@Nullable ObjectPath p) {
        return p == null ? null : new SearchPath(Collections.singletonList(p));
    }

    @Nullable
    public static SearchPath of(@Nullable List<ObjectPath> p) {
        return p == null || p.isEmpty() ? null : new SearchPath(p);
    }

    @Contract(value="!null->!null")
    public static ObjectPath getCurrent(@Nullable SearchPath p) {
        return p == null ? null : p.getCurrent();
    }

    @NotNull
    public static List<ObjectPath> getElements(@Nullable SearchPath p) {
        List<Object> list = p == null ? Collections.emptyList() : p.elements;
        if (list == null) {
            SearchPath.$$$reportNull$$$0(2);
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchPath multi = (SearchPath)o;
        return this.elements.equals(multi.elements);
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    public String toString() {
        return StringUtil.join(this.elements, (Function)Functions.TO_STRING(), (String)",");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/SearchPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/SearchPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

