/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="ID")
public class ConnectionId {
    public final boolean myUseP4Config;
    public final String myP4ConfigFileName;
    public final String myWorkingDir;

    public ConnectionId(@Nullable String p4ConfigFileName, @NotNull String workingDir) {
        if (workingDir == null) {
            ConnectionId.$$$reportNull$$$0(0);
        }
        this.myP4ConfigFileName = p4ConfigFileName;
        this.myWorkingDir = workingDir;
        this.myUseP4Config = true;
    }

    public ConnectionId() {
        this.myUseP4Config = false;
        this.myP4ConfigFileName = null;
        this.myWorkingDir = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionId that = (ConnectionId)o;
        if (!this.myUseP4Config) {
            return !that.myUseP4Config;
        }
        if (this.myP4ConfigFileName != null ? !this.myP4ConfigFileName.equals(that.myP4ConfigFileName) : that.myP4ConfigFileName != null) {
            return false;
        }
        return !(this.myWorkingDir == null ? that.myWorkingDir != null : !this.myWorkingDir.equals(that.myWorkingDir));
    }

    public int hashCode() {
        if (!this.myUseP4Config) {
            return 0;
        }
        int result = 0;
        result = 29 * result + (this.myP4ConfigFileName != null ? this.myP4ConfigFileName.hashCode() : 0);
        result = 29 * result + (this.myWorkingDir != null ? this.myWorkingDir.hashCode() : 0);
        return result;
    }

    public void writeToStream(DataOutput stream) throws IOException {
        stream.writeByte(!this.myUseP4Config ? 0 : 1);
        if (this.myUseP4Config) {
            stream.writeUTF(StringUtil.notNullize((String)this.myP4ConfigFileName));
            stream.writeUTF((String)ObjectUtils.assertNotNull((Object)this.myWorkingDir));
        }
    }

    public static ConnectionId readFromStream(DataInput stream) throws IOException {
        byte useP4Config = stream.readByte();
        if (useP4Config == 0) {
            return new ConnectionId();
        }
        String configFileName = stream.readUTF();
        String workingDir = stream.readUTF();
        return new ConnectionId(configFileName.isEmpty() ? null : configFileName, workingDir);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDir", "org/jetbrains/idea/perforce/perforce/ConnectionId", "<init>"));
    }
}

