/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinElementTypes;
import org.jetbrains.plugins.cucumber.psi.GherkinElementVisitor;
import org.jetbrains.plugins.cucumber.psi.GherkinExamplesBlock;
import org.jetbrains.plugins.cucumber.psi.GherkinScenarioOutline;
import org.jetbrains.plugins.cucumber.psi.GherkinTable;
import org.jetbrains.plugins.cucumber.psi.GherkinTableCell;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinStepsHolderBase;

public class GherkinScenarioOutlineImpl
extends GherkinStepsHolderBase
implements GherkinScenarioOutline {
    private static final TokenSet EXAMPLES_BLOCK_FILTER = TokenSet.create((IElementType[])new IElementType[]{GherkinElementTypes.EXAMPLES_BLOCK});
    private Ref<Map<String, String>> myOutlineTableMap;

    public GherkinScenarioOutlineImpl(@NotNull ASTNode node) {
        if (node == null) {
            GherkinScenarioOutlineImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public String toString() {
        return "GherkinScenarioOutline:" + this.getElementText();
    }

    @Override
    protected String getPresentableText() {
        return this.buildPresentableText("Scenario Outline");
    }

    @Override
    protected void acceptGherkin(GherkinElementVisitor gherkinElementVisitor) {
        gherkinElementVisitor.visitScenarioOutline(this);
    }

    @Override
    @NotNull
    public List<GherkinExamplesBlock> getExamplesBlocks() {
        ASTNode[] nodes;
        ArrayList<GherkinExamplesBlock> result = new ArrayList<GherkinExamplesBlock>();
        for (ASTNode node : nodes = this.getNode().getChildren(EXAMPLES_BLOCK_FILTER)) {
            result.add((GherkinExamplesBlock)node.getPsi());
        }
        ArrayList<GherkinExamplesBlock> arrayList = result;
        if (arrayList == null) {
            GherkinScenarioOutlineImpl.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    @Nullable
    public Map<String, String> getOutlineTableMap() {
        if (this.myOutlineTableMap == null) {
            this.myOutlineTableMap = new Ref(this.buildOutlineTableMap());
        }
        return (Map)this.myOutlineTableMap.get();
    }

    @Nullable
    private Map<String, String> buildOutlineTableMap() {
        List<GherkinExamplesBlock> examplesBlocks = this.getExamplesBlocks();
        for (GherkinExamplesBlock examplesBlock : examplesBlocks) {
            GherkinTable table = examplesBlock.getTable();
            if (table == null || table.getHeaderRow() == null || table.getDataRows().size() == 0) continue;
            List<GherkinTableCell> headerCells = table.getHeaderRow().getPsiCells();
            List<GherkinTableCell> dataCells = table.getDataRows().get(0).getPsiCells();
            HashMap<String, String> result = new HashMap<String, String>();
            for (int i = 0; i < headerCells.size() && i < dataCells.size(); ++i) {
                result.put(headerCells.get(i).getText().trim(), dataCells.get(i).getText().trim());
            }
            return result;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/psi/impl/GherkinScenarioOutlineImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/psi/impl/GherkinScenarioOutlineImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExamplesBlocks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

