/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml;

import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.icons.AllIcons;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.uml.UmlFileEditorImpl;
import com.intellij.uml.UmlVirtualFileSystem;
import com.intellij.uml.utils.UmlFileConverter;
import com.intellij.uml.utils.VcsUtils;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UmlEditorProvider
implements FileEditorProvider,
DumbAware {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        UmlVirtualFileSystem.UmlVirtualFile umlVirtualFile;
        DiagramProvider provider;
        if (project == null) {
            UmlEditorProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            UmlEditorProvider.$$$reportNull$$$0(1);
        }
        if (file.getFileSystem() instanceof LocalFileSystem && "uml".equalsIgnoreCase(file.getExtension())) {
            if (UmlEditorProvider.isNewUmlFormat(file)) {
                return true;
            }
            if (UmlEditorProvider.isOldUmlFormat(file)) {
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    return this.convertFile(project, file);
                }
                SwingUtilities.invokeLater(() -> {
                    if (project == null) {
                        UmlEditorProvider.$$$reportNull$$$0(21);
                    }
                    if (file == null) {
                        UmlEditorProvider.$$$reportNull$$$0(22);
                    }
                    this.convertFile(project, file);
                });
            }
            return false;
        }
        if (file instanceof UmlVirtualFileSystem.UmlVirtualFile && (provider = (umlVirtualFile = (UmlVirtualFileSystem.UmlVirtualFile)file).getUmlProvider()) != null) {
            if (!DumbService.isDumbAware((Object)provider) && DumbService.isDumb((Project)project)) {
                return false;
            }
            return UmlEditorProvider.getElementFromFile(project, umlVirtualFile) != null || VcsUtils.isShowChangesFile(file);
        }
        return false;
    }

    private boolean convertFile(final Project project, final VirtualFile file) {
        Boolean success;
        if (Messages.showOkCancelDialog((Project)project, (String)"This file has old format. Would you like to convert it?", (String)"Old Diagram Format", (Icon)AllIcons.FileTypes.Diagram) == 0 && !(success = (Boolean)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                try {
                    VirtualFile copy = file.copy((Object)this, file.getParent(), file.getName() + ".bak.xml");
                    PsiFile xml = PsiManager.getInstance((Project)project).findFile(copy);
                    if (!(xml instanceof XmlFile)) {
                        throw new IOException();
                    }
                    Document doc = UmlFileConverter.convert(((XmlFile)xml).getDocument());
                    boolean result = DiagramState.writeXml((VirtualFile)file, (Project)project, (Document)doc);
                    copy.delete(null);
                    return result;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
        })).booleanValue()) {
            Messages.showErrorDialog((Project)project, (String)"Can't save converted content into file. Check read-only status.", (String)"Error");
            return true;
        }
        return false;
    }

    private static boolean isNewUmlFormat(VirtualFile file) {
        try {
            String beginning = VfsUtilCore.loadText((VirtualFile)file, (int)100);
            return beginning.contains("<Diagramm>") || beginning.contains("<Diagram>");
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean isOldUmlFormat(VirtualFile file) {
        try {
            return VfsUtilCore.loadText((VirtualFile)file, (int)100).contains("<ClassDiagramm>");
        }
        catch (Exception e) {
            return false;
        }
    }

    @Nullable
    private static Object getElementFromFile(Project project, @NotNull UmlVirtualFileSystem.UmlVirtualFile file) {
        DiagramProvider umlProvider;
        Object result;
        if (file == null) {
            UmlEditorProvider.$$$reportNull$$$0(2);
        }
        Object object = result = (umlProvider = file.getUmlProvider()) != null ? umlProvider.getVfsResolver().resolveElementByFQN(file.getFQN(), project) : null;
        if (result == null && umlProvider != null) {
            Object element = file.getUserData(DiagramProvider.ORIGINAL_ELEMENT);
            if (umlProvider.getElementManager().isAcceptableAsNode(element)) {
                if (!(element instanceof PsiElement)) {
                    return element;
                }
                PsiFile psiFile = ((PsiElement)element).getContainingFile();
                if (psiFile != null && ScratchUtil.isScratch((VirtualFile)psiFile.getVirtualFile())) {
                    return element;
                }
            }
        }
        return result;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            UmlEditorProvider.$$$reportNull$$$0(3);
        }
        if (file == null) {
            UmlEditorProvider.$$$reportNull$$$0(4);
        }
        if (file instanceof UmlVirtualFileSystem.UmlVirtualFile) {
            FileEditor fileEditor = UmlEditorProvider.createEditorFromPsiElement(project, (UmlVirtualFileSystem.UmlVirtualFile)file);
            if (fileEditor == null) {
                UmlEditorProvider.$$$reportNull$$$0(5);
            }
            return fileEditor;
        }
        UmlFileEditorImpl umlFileEditorImpl = new UmlFileEditorImpl(null, false, file, project);
        if (umlFileEditorImpl == null) {
            UmlEditorProvider.$$$reportNull$$$0(6);
        }
        return umlFileEditorImpl;
    }

    private static FileEditor createEditorFromPsiElement(@NotNull Project project, @NotNull UmlVirtualFileSystem.UmlVirtualFile file) {
        if (project == null) {
            UmlEditorProvider.$$$reportNull$$$0(7);
        }
        if (file == null) {
            UmlEditorProvider.$$$reportNull$$$0(8);
        }
        boolean initialized = UmlVirtualFileSystem.isInitialized(file);
        return new UmlFileEditorImpl(UmlEditorProvider.getElementFromFile(project, file), initialized, file, project);
    }

    public void disposeEditor(@NotNull FileEditor editor) {
        VirtualFile file;
        if (editor == null) {
            UmlEditorProvider.$$$reportNull$$$0(9);
        }
        if ((file = ((UmlFileEditorImpl)editor).getOriginalVirtualFile()) instanceof UmlVirtualFileSystem.UmlVirtualFile) {
            DiagramState state = (DiagramState)editor.getState(FileEditorStateLevel.FULL);
            ((UmlVirtualFileSystem.UmlVirtualFile)file).setState(state);
        }
        Disposer.dispose((Disposable)editor);
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        UmlVirtualFileSystem.UmlVirtualFile vf;
        if (sourceElement == null) {
            UmlEditorProvider.$$$reportNull$$$0(10);
        }
        if (project == null) {
            UmlEditorProvider.$$$reportNull$$$0(11);
        }
        if (file == null) {
            UmlEditorProvider.$$$reportNull$$$0(12);
        }
        if (file instanceof UmlVirtualFileSystem.UmlVirtualFile && (vf = (UmlVirtualFileSystem.UmlVirtualFile)file).getProject() == null) {
            vf.setProject(project);
        }
        DiagramState diagramState = DiagramState.read((Element)sourceElement);
        if (diagramState == null) {
            UmlEditorProvider.$$$reportNull$$$0(13);
        }
        return diagramState;
    }

    public void writeState(@NotNull FileEditorState editorState, @NotNull Project project, @NotNull Element element) {
        if (editorState == null) {
            UmlEditorProvider.$$$reportNull$$$0(14);
        }
        if (project == null) {
            UmlEditorProvider.$$$reportNull$$$0(15);
        }
        if (element == null) {
            UmlEditorProvider.$$$reportNull$$$0(16);
        }
        UmlEditorProvider.saveUmlState(editorState, element);
    }

    @NotNull
    @NonNls
    public String getEditorTypeId() {
        if ("UmlEditorProvider" == null) {
            UmlEditorProvider.$$$reportNull$$$0(17);
        }
        return "UmlEditorProvider";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.HIDE_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            UmlEditorProvider.$$$reportNull$$$0(18);
        }
        return fileEditorPolicy;
    }

    public static void saveUmlState(@NotNull FileEditorState editorState, @NotNull Element root) {
        if (editorState == null) {
            UmlEditorProvider.$$$reportNull$$$0(19);
        }
        if (root == null) {
            UmlEditorProvider.$$$reportNull$$$0(20);
        }
        if (editorState instanceof DiagramState) {
            ((DiagramState)editorState).write(root);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 13: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 13: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: 
            case 13: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/UmlEditorProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorState";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/UmlEditorProvider";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "readState";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorTypeId";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElementFromFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 5: 
            case 6: 
            case 13: 
            case 17: 
            case 18: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createEditorFromPsiElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "disposeEditor";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readState";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "writeState";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "saveUmlState";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$accept$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 13: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

