/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.settings;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramFileEditor;
import com.intellij.diagram.settings.DiagramConfiguration;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.uml.settings.DiagramSettingsForm;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class UmlConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    @NonNls
    private static final String NAME = "Diagrams";
    private DiagramSettingsForm settings;
    private final DiagramConfiguration myConfiguration;

    public UmlConfigurable(DiagramConfiguration configuration) {
        this.myConfiguration = configuration;
    }

    @Nls
    public String getDisplayName() {
        return NAME;
    }

    public String getHelpTopic() {
        return "reference.settings.ide.settings.uml";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            UmlConfigurable.$$$reportNull$$$0(0);
        }
        return string;
    }

    public JComponent createComponent() {
        if (this.settings == null) {
            this.settings = new DiagramSettingsForm(this.myConfiguration);
        }
        return this.settings.getJComponent();
    }

    public boolean isModified() {
        return this.settings.changed();
    }

    public void apply() {
        this.settings.apply();
        FileEditorManager manager = FileEditorManager.getInstance((Project)ProjectUtil.guessCurrentProject((JComponent)this.settings.getJComponent()));
        if (manager == null) {
            return;
        }
        for (FileEditor editor : manager.getAllEditors()) {
            if (!(editor instanceof DiagramFileEditor)) continue;
            DiagramBuilder builder = ((DiagramFileEditor)editor).getBuilder();
            builder.getDataModel().refreshDataModel();
            builder.update();
        }
    }

    public void reset() {
        this.settings.reset();
    }

    public void disposeUIResources() {
        this.settings = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/settings/UmlConfigurable", "getId"));
    }
}

