/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.braces;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.util.List;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSAddBracesIntention
extends JSMutablyNamedIntention {
    @NonNls
    private static final String IF_KEYWORD = "if";
    @NonNls
    private static final String ELSE_KEYWORD = "else";

    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        AddBracesPredicate addBracesPredicate = new AddBracesPredicate();
        if (addBracesPredicate == null) {
            JSAddBracesIntention.$$$reportNull$$$0(0);
        }
        return addBracesPredicate;
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        String keyword;
        JSElement parent = (JSElement)element.getParent();
        assert (parent != null);
        if (JSAddBracesIntention.isShorthandArrowFunction(element)) {
            return JSBundle.message((String)"js.add.braces.to.arrow.function", (Object[])new Object[0]);
        }
        if (parent instanceof JSIfStatement) {
            JSIfStatement ifStatement = (JSIfStatement)parent;
            JSStatement elseBranch = ifStatement.getElse();
            keyword = JSAddBracesIntention.quote(element.equals(elseBranch) ? ELSE_KEYWORD : IF_KEYWORD);
        } else {
            PsiElement firstChild = parent.getFirstChild();
            assert (firstChild != null);
            keyword = JSAddBracesIntention.quote(firstChild.getText());
        }
        return this.getText(keyword);
    }

    private static String quote(@NotNull String s) {
        if (s == null) {
            JSAddBracesIntention.$$$reportNull$$$0(1);
        }
        return '\'' + s + '\'';
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSAddBracesIntention.$$$reportNull$$$0(2);
        }
        if (JSAddBracesIntention.isShorthandArrowFunction(element)) {
            JSAddBracesIntention.addBracesToShorthandArrowFunction(element);
            return;
        }
        if (!(element instanceof JSStatement)) {
            return;
        }
        JSStatement statement = (JSStatement)element;
        JSElement parent = (JSElement)element.getParent();
        String text = element.getText();
        String newText = parent.getLastChild() instanceof PsiComment ? '{' + text + "\n}" : '{' + text + '}';
        JSAddBracesIntention.replaceAndReformat(statement, newText);
    }

    private static void replaceAndReformat(@NotNull JSStatement statement, @NotNull String text) {
        if (statement == null) {
            JSAddBracesIntention.$$$reportNull$$$0(3);
        }
        if (text == null) {
            JSAddBracesIntention.$$$reportNull$$$0(4);
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)statement.getProject());
        JSStatement newStatement = (JSStatement)codeStyleManager.performActionWithFormatterDisabled(() -> {
            if (text == null) {
                JSAddBracesIntention.$$$reportNull$$$0(12);
            }
            if (statement == null) {
                JSAddBracesIntention.$$$reportNull$$$0(13);
            }
            JSStatement replacement = (JSStatement)JSChangeUtil.createStatementPsiFromTextWithContext((String)text, (PsiElement)statement, JSStatement.class);
            return statement.replace(replacement);
        });
        PsiElement formatted = codeStyleManager.reformat((PsiElement)newStatement);
        codeStyleManager.reformatNewlyAddedElement(formatted.getNode().getTreeParent(), formatted.getNode());
    }

    private static void addBracesToShorthandArrowFunction(@NotNull PsiElement element) {
        if (element == null) {
            JSAddBracesIntention.$$$reportNull$$$0(5);
        }
        JSFunction dummyFunction = JSAddBracesIntention.createDummyArrowFunctionWithReturn(element);
        ASTNode arrow = JSPsiImplUtils.getFunctionArrowNode((JSFunction)((JSFunction)element));
        if (arrow == null) {
            return;
        }
        JSExpression expression = (JSExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)arrow.getPsi(), JSExpression.class);
        if (expression == null) {
            return;
        }
        JSReturnStatement returnStatement = (JSReturnStatement)PsiTreeUtil.findChildOfType((PsiElement)dummyFunction, JSReturnStatement.class);
        assert (returnStatement != null);
        returnStatement.getExpression().replace(expression);
        List<PsiElement> prefixElements = JSAddBracesIntention.collectSiblingsInRange(arrow.getPsi(), (PsiElement)expression);
        if (!prefixElements.isEmpty()) {
            prefixElements.forEach(el -> JSChangeUtil.doDoAddBeforePure((PsiElement)returnStatement.getParent(), (PsiElement)el, (PsiElement)returnStatement));
            element.getNode().removeRange(prefixElements.get(0).getNode(), expression.getNode());
        }
        JSBlockStatement block = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)dummyFunction, JSBlockStatement.class);
        assert (block != null);
        PsiElement replacedBody = expression.replace((PsiElement)block);
        FormatFixer.create((PsiElement)replacedBody, (FormatFixer.Mode)FormatFixer.Mode.ReformatExactRange).fixFormat();
    }

    @NotNull
    private static JSFunction createDummyArrowFunctionWithReturn(@NotNull PsiElement element) {
        if (element == null) {
            JSAddBracesIntention.$$$reportNull$$$0(6);
        }
        JSExpressionStatement dummySt = (JSExpressionStatement)JSChangeUtil.createStatementPsiFromTextWithContext((String)String.format("()=>{return a%s}", JSCodeStyleSettings.getSemicolon((PsiElement)element.getContainingFile())), (PsiElement)element, JSExpressionStatement.class);
        assert (dummySt != null && dummySt.getExpression() instanceof JSFunction);
        JSFunction jSFunction = (JSFunction)dummySt.getExpression();
        if (jSFunction == null) {
            JSAddBracesIntention.$$$reportNull$$$0(7);
        }
        return jSFunction;
    }

    @NotNull
    private static List<PsiElement> collectSiblingsInRange(@NotNull PsiElement from, @NotNull PsiElement toExcluding) {
        if (from == null) {
            JSAddBracesIntention.$$$reportNull$$$0(8);
        }
        if (toExcluding == null) {
            JSAddBracesIntention.$$$reportNull$$$0(9);
        }
        SmartList elements = new SmartList();
        for (PsiElement current = from.getNextSibling(); current != null && !current.equals(toExcluding); current = current.getNextSibling()) {
            elements.add(current);
        }
        SmartList smartList = elements;
        if (smartList == null) {
            JSAddBracesIntention.$$$reportNull$$$0(10);
        }
        return smartList;
    }

    private static boolean isShorthandArrowFunction(@NotNull PsiElement element) {
        if (element == null) {
            JSAddBracesIntention.$$$reportNull$$$0(11);
        }
        return element instanceof JSFunctionExpression && JSPsiImplUtils.isShorthandArrowFunction((JSFunction)((JSFunction)element));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toExcluding";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createDummyArrowFunctionWithReturn";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSiblingsInRange";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "quote";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replaceAndReformat";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addBracesToShorthandArrowFunction";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDummyArrowFunctionWithReturn";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectSiblingsInRange";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isShorthandArrowFunction";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$replaceAndReformat$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddBracesPredicate
    implements JSElementPredicate {
        private AddBracesPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                AddBracesPredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSStatement)) {
                return JSAddBracesIntention.isShorthandArrowFunction(element);
            }
            if (element instanceof JSBlockStatement) {
                return false;
            }
            PsiElement parentElement = element.getParent();
            if (!(parentElement instanceof JSElement)) {
                return false;
            }
            JSElement parent = (JSElement)parentElement;
            if (parent instanceof JSIfStatement) {
                JSIfStatement ifStatement = (JSIfStatement)parent;
                return !(element instanceof JSIfStatement) || !element.equals(ifStatement.getElse());
            }
            if (parent instanceof JSForStatement || parent instanceof JSForInStatement) {
                return element.equals(((JSLoopStatement)parent).getBody());
            }
            return parent instanceof JSWhileStatement || parent instanceof JSDoWhileStatement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention$AddBracesPredicate", "satisfiedBy"));
        }
    }
}

