/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml.ruby.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.haml.psi.HAMLTokenTypes;
import org.jetbrains.plugins.haml.psi.IHAMLOuterElementType;
import org.jetbrains.plugins.haml.ruby.HAMLRubyLexer;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsingUtils.ErrorMsg;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsingUtils.RBuilderImpl;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public class HAMLRubyBuilder
extends RBuilderImpl {
    private static final TokenSet SAME_INDENT_ELEMENTS = TokenSet.create((IElementType[])new IElementType[]{RubyTokenTypes.kELSIF, RubyTokenTypes.kELSE, RubyTokenTypes.kWHEN, RubyTokenTypes.kRESCUE});
    private final Stack<Pair<Integer, TokenSet>> myIndentsStack;
    private final HAMLRubyLexer myLexer;
    private boolean hamlEolSeen;
    private IElementType myLastTokenType;
    private IElementType myNextTokenType;
    private IElementType myNextNotEolTokenType;

    HAMLRubyBuilder(@NotNull PsiBuilder psiBuilder, LanguageLevel languageLevel) {
        if (psiBuilder == null) {
            HAMLRubyBuilder.$$$reportNull$$$0(0);
        }
        super(psiBuilder, languageLevel);
        this.myIndentsStack = new Stack();
        this.hamlEolSeen = false;
        this.myLexer = (HAMLRubyLexer)((PsiBuilderImpl)this.myBuilder).getLexer();
    }

    public void error(@NotNull String error) {
        if (error == null) {
            HAMLRubyBuilder.$$$reportNull$$$0(1);
        }
        if (error.equals(ErrorMsg.expected((IElementType)RubyTokenTypes.tASSOC))) {
            return;
        }
        super.error("[RUBY] " + error);
    }

    public boolean isAcceptableErrorToken(IElementType tokenType) {
        return tokenType instanceof IHAMLOuterElementType || super.isAcceptableErrorToken(tokenType);
    }

    public void startScope(TokenSet acceptedTokens) {
        super.startScope(acceptedTokens);
        this.hamlEolSeen = false;
        this.myIndentsStack.push((Object)Pair.create((Object)this.myLexer.getIndent(this.getTokenStart()), (Object)acceptedTokens));
    }

    public void finishScope() {
        super.finishScope();
        this.myIndentsStack.pop();
    }

    public IElementType getTokenType() {
        if (this.myNextTokenType == null) {
            this.myNextTokenType = this.fetchNextTokenType();
            return this.myNextTokenType;
        }
        return this.myNextTokenType;
    }

    private boolean checkIndent(int indentLength) {
        IElementType lookedAhead = this.myBuilder.lookAhead(2);
        boolean indentMightBeEqual = SAME_INDENT_ELEMENTS.contains(lookedAhead);
        return this.myIndentsStack.isEmpty() || (Integer)((Pair)this.myIndentsStack.peek()).first < indentLength || indentMightBeEqual && (Integer)((Pair)this.myIndentsStack.peek()).first == indentLength;
    }

    @Nullable
    private IElementType fetchNextTokenType() {
        IElementType tokenType = super.getTokenType();
        if (tokenType == null) {
            return null;
        }
        if (tokenType == HAMLTokenTypes.EOL) {
            return tokenType;
        }
        if (tokenType == HAMLTokenTypes.INDENT) {
            int indentLength = this.getTokenLength();
            assert (indentLength > 0) : "indent length cannot be 0";
            if (this.checkIndent(indentLength)) {
                super.advanceLexer();
                return this.fetchNextTokenType();
            }
            return null;
        }
        if (!this.hamlEolSeen || this.myIndentsStack.isEmpty()) {
            return tokenType;
        }
        Pair stackInfo = (Pair)this.myIndentsStack.peek();
        Integer stackIndent = (Integer)stackInfo.first;
        TokenSet acceptedTokens = (TokenSet)stackInfo.second;
        int tokenIndent = this.myLexer.getIndent(this.getTokenStart());
        if (stackIndent < tokenIndent || stackIndent == tokenIndent && (tokenType != HAMLTokenTypes.HAML_INJECTION_IN_RUBY || acceptedTokens.contains(tokenType))) {
            return tokenType;
        }
        return null;
    }

    public IElementType getNotEolTokenType() {
        if (this.myNextNotEolTokenType == null) {
            this.myNextNotEolTokenType = this.fetchNextNotEolTokenType();
            return this.myNextNotEolTokenType;
        }
        return this.myNextNotEolTokenType;
    }

    @Nullable
    private IElementType fetchNextNotEolTokenType() {
        IElementType notEolTokenType = super.getNotEolTokenType();
        if (notEolTokenType == null) {
            return null;
        }
        if (notEolTokenType == HAMLTokenTypes.EOL) {
            return notEolTokenType;
        }
        if (notEolTokenType == HAMLTokenTypes.INDENT) {
            int indentLength = this.getNotEolTokenLength();
            assert (indentLength > 0) : "indent length cannot be 0";
            if (this.checkIndent(indentLength)) {
                super.advanceLexer();
                return this.fetchNextNotEolTokenType();
            }
            return null;
        }
        if (!this.hamlEolSeen || this.myIndentsStack.isEmpty()) {
            return notEolTokenType;
        }
        Pair stackInfo = (Pair)this.myIndentsStack.peek();
        Integer stackIndent = (Integer)stackInfo.first;
        TokenSet acceptedTokens = (TokenSet)stackInfo.second;
        int tokenIndent = this.myLexer.getIndent(this.getTokenStart());
        if (stackIndent < tokenIndent || stackIndent == tokenIndent && (notEolTokenType != HAMLTokenTypes.HAML_INJECTION_IN_RUBY || acceptedTokens.contains(notEolTokenType))) {
            return notEolTokenType;
        }
        return null;
    }

    public void advanceLexer() {
        this.myLastTokenType = this.myNextTokenType;
        if (super.getTokenType() == HAMLTokenTypes.EOL) {
            this.hamlEolSeen = true;
        }
        super.advanceLexer();
    }

    public void matchIgnoreEOL(IElementType token) {
        if (token == RubyTokenTypes.kEND || token == RubyTokenTypes.tRBRACE) {
            IElementType notEolTokenType = this.getNotEolTokenType();
            if (this.myLastTokenType == HAMLTokenTypes.RUBY_CODE_MARKER && notEolTokenType == RubyTokenTypes.kEND) {
                this.error(RBundle.message((String)"parsing.haml.end"));
            }
            if (notEolTokenType != token) {
                return;
            }
        }
        super.matchIgnoreEOL(token);
    }

    public void invalidateNextTokens() {
        super.invalidateNextTokens();
        this.myNextTokenType = null;
        this.myNextNotEolTokenType = null;
    }

    public boolean passHeredocsAndLeadingEOLs() {
        boolean result = super.passHeredocsAndLeadingEOLs();
        while (this.compareAndEat(HAMLTokenTypes.EOL)) {
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiBuilder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/haml/ruby/parser/HAMLRubyBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

