/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.components;

import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.builder.DeleteProvider;
import com.intellij.openapi.graph.builder.EdgeCreationPolicy;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.hierarchic.HierarchicGroupLayouter;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.view.Arrow;
import com.intellij.openapi.graph.view.AutoRotationSliderEdgeLabelModel;
import com.intellij.openapi.graph.view.EdgeLabel;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.GenericNodeRealizer;
import com.intellij.openapi.graph.view.Graph2DNodeRealizer;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.LineType;
import com.intellij.openapi.graph.view.NodeCellEditor;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.PolyLineEdgeRealizer;
import com.intellij.util.ArrayUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicGraphPresentationModel<N, E>
extends GraphPresentationModel<N, E> {
    private Graph myGraph;
    private GraphBuilder<N, E> myGraphBuilder;
    private final GraphSettings mySettings = GraphSettings.create();
    private boolean myShowEdgeLabels;

    @Override
    @NotNull
    public GraphSettings getSettings() {
        GraphSettings graphSettings = this.mySettings;
        if (graphSettings == null) {
            BasicGraphPresentationModel.$$$reportNull$$$0(0);
        }
        return graphSettings;
    }

    public BasicGraphPresentationModel(Graph graph) {
        this.myGraph = graph;
    }

    public BasicGraphPresentationModel(GraphBuilder<N, E> graphBuilder) {
        this.myGraphBuilder = graphBuilder;
    }

    public Graph getGraph() {
        return this.myGraph;
    }

    public void setGraph(Graph graph) {
        this.myGraph = graph;
    }

    @Override
    @NotNull
    public NodeRealizer getNodeRealizer(@Nullable N n) {
        Graph2DNodeRealizer graph2DNodeRealizer = GraphManager.getGraphManager().createGraph2DNodeRealizer();
        if (graph2DNodeRealizer == null) {
            BasicGraphPresentationModel.$$$reportNull$$$0(1);
        }
        return graph2DNodeRealizer;
    }

    @Override
    @NotNull
    public EdgeRealizer getEdgeRealizer(@Nullable E e) {
        PolyLineEdgeRealizer edgeRealizer = GraphManager.getGraphManager().createPolyLineEdgeRealizer();
        edgeRealizer.setLineType(LineType.LINE_1);
        edgeRealizer.setLineColor(Color.GRAY);
        edgeRealizer.setArrow(Arrow.STANDARD);
        PolyLineEdgeRealizer polyLineEdgeRealizer = edgeRealizer;
        if (polyLineEdgeRealizer == null) {
            BasicGraphPresentationModel.$$$reportNull$$$0(2);
        }
        return polyLineEdgeRealizer;
    }

    @Override
    public String getNodeTooltip(@Nullable N n) {
        return null;
    }

    @Override
    public String getEdgeTooltip(@Nullable E e) {
        return null;
    }

    @Override
    public boolean editNode(N n) {
        return false;
    }

    @Override
    public boolean editEdge(E e) {
        return false;
    }

    @Override
    public NodeCellEditor getCustomNodeCellEditor(N n) {
        return null;
    }

    @Override
    public DefaultActionGroup getNodeActionGroup(N n) {
        return this.getCommonActionGroup();
    }

    @Override
    public DefaultActionGroup getEdgeActionGroup(E e) {
        return this.getCommonActionGroup();
    }

    @Override
    public DefaultActionGroup getPaperActionGroup() {
        return this.getCommonActionGroup();
    }

    protected DefaultActionGroup getCommonActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(GraphViewUtil.getCommonPopupActions());
        return group;
    }

    @Override
    @NotNull
    public Layouter getDefaultLayouter() {
        GraphBuilder<N, E> builder = this.getGraphBuilder();
        if (builder != null) {
            Layouter layouter = this.getSettings().getCurrentLayouter();
            if (layouter == null) {
                BasicGraphPresentationModel.$$$reportNull$$$0(3);
            }
            return layouter;
        }
        HierarchicGroupLayouter hierarchicGroupLayouter = GraphManager.getGraphManager().createHierarchicGroupLayouter();
        if (hierarchicGroupLayouter == null) {
            BasicGraphPresentationModel.$$$reportNull$$$0(4);
        }
        return hierarchicGroupLayouter;
    }

    public void dispose() {
        GenericNodeRealizer.Factory factory = GenericNodeRealizer.Statics.getFactory();
        Set configurations = factory.getAvailableConfigurations();
        for (Object object : ArrayUtil.toObjectArray((Collection)configurations)) {
            if (!(object instanceof String)) continue;
            factory.removeConfiguration((String)object);
        }
    }

    @Override
    public EdgeLabel[] getEdgeLabels(E e, String edgeName) {
        if (!this.isShowEdgeLabels()) {
            return EMPTY_LABELS;
        }
        EdgeLabel label = this.createLabel(edgeName);
        if (this.isAutoRotateLabels()) {
            AutoRotationSliderEdgeLabelModel labelModel = GraphManager.getGraphManager().createAutoRotationSliderEdgeLabelModel();
            labelModel.setDistance(-15.0);
            label.setLabelModel(labelModel);
            label.setModelParameter(labelModel.getDefaultParameter());
        }
        return new EdgeLabel[]{label};
    }

    public boolean isShowEdgeLabels() {
        return this.myShowEdgeLabels;
    }

    public void setShowEdgeLabels(boolean showEdgeLabels) {
        this.myShowEdgeLabels = showEdgeLabels;
    }

    protected EdgeLabel createLabel(String edgeName) {
        EdgeLabel label = GraphManager.getGraphManager().createEdgeLabel(edgeName, EdgeLabel.TWO_POS);
        label.setPosition(EdgeLabel.HEAD);
        label.setFontSize(10);
        label.setFontStyle(2);
        return label;
    }

    @Override
    public void customizeSettings(Graph2DView view, EditMode editMode) {
    }

    @Override
    public EdgeCreationPolicy<N> getEdgeCreationPolicy() {
        return new EdgeCreationPolicy<N>(){

            @Override
            public boolean acceptSource(N source) {
                return true;
            }

            @Override
            public boolean acceptTarget(N target) {
                return true;
            }
        };
    }

    @Override
    public DeleteProvider getDeleteProvider() {
        return null;
    }

    public boolean isAutoRotateLabels() {
        return false;
    }

    @NotNull
    public GraphBuilder<N, E> getGraphBuilder() {
        GraphBuilder<N, E> graphBuilder = this.myGraphBuilder;
        if (graphBuilder == null) {
            BasicGraphPresentationModel.$$$reportNull$$$0(5);
        }
        return graphBuilder;
    }

    public void setGraphBuilder(GraphBuilder<N, E> graphBuilder) {
        this.myGraphBuilder = graphBuilder;
    }

    @Override
    @NotNull
    public String getActionPlace() {
        if ("unknown" == null) {
            BasicGraphPresentationModel.$$$reportNull$$$0(6);
        }
        return "unknown";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/graph/builder/components/BasicGraphPresentationModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeRealizer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeRealizer";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLayouter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionPlace";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

