/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import java.lang.ref.SoftReference;

abstract class ThreadLocalCachedValue<T> {
    private final ThreadLocal<SoftReference<T>> myThreadLocal = new ThreadLocal();

    ThreadLocalCachedValue() {
    }

    public T getValue() {
        T value = ThreadLocalCachedValue.dereference(this.myThreadLocal.get());
        if (value == null) {
            value = this.create();
            this.myThreadLocal.set(new SoftReference<T>(value));
        }
        return value;
    }

    protected abstract T create();

    private static <T> T dereference(SoftReference<T> ref) {
        return ref == null ? null : (T)ref.get();
    }
}

