/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres.psi;

import com.intellij.database.util.Case;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.base.psi.SqlFunctionBodyInjector;
import com.intellij.sql.dialects.postgres.PgTypes;
import com.intellij.sql.dialects.postgres.PostgresDialect;
import com.intellij.sql.dialects.postgres.PostgresElementTypes;
import com.intellij.sql.dialects.postgres.PostgresOptionalKeywords;
import com.intellij.sql.dialects.postgres.PostgresReservedKeywords;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlStringLiteralExpressionImpl;
import com.intellij.sql.psi.stubs.SqlFileElementType;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionBodyInjector
extends SqlFunctionBodyInjector {
    @Override
    protected boolean canApply(PsiElement context) {
        return context instanceof SqlStringLiteralExpression && SqlImplUtil.getSqlDialectSafe(context).getDbms().isPostgres();
    }

    @Override
    @Nullable
    protected Pair<Language, String> calcBodyLanguage(@NotNull PsiElement context) {
        if (context == null) {
            FunctionBodyInjector.$$$reportNull$$$0(0);
        }
        return this.calcBodyLanguage(context.getNode(), context);
    }

    @Override
    @Nullable
    protected Pair<String, String> getPrefixSuffix(Language language) {
        return null;
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<SqlStringLiteralExpressionImpl>> list = Collections.singletonList(SqlStringLiteralExpressionImpl.class);
        if (list == null) {
            FunctionBodyInjector.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    private Pair<Language, String> calcBodyLanguage(@NotNull ASTNode node, @NotNull PsiElement context) {
        Object lang;
        SqlStatement statement;
        ASTNode nodeParent;
        if (node == null) {
            FunctionBodyInjector.$$$reportNull$$$0(2);
        }
        if (context == null) {
            FunctionBodyInjector.$$$reportNull$$$0(3);
        }
        if ((nodeParent = (ASTNode)ObjectUtils.assertNotNull((Object)node.getTreeParent())).getElementType() == PostgresElementTypes.Misc.PG_LAZY_CODE_BLOCK) {
            node = nodeParent;
        }
        if (!((statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)context, SqlStatement.class, (boolean)false)) instanceof SqlCreateProcedureStatement || statement != null && statement.getFirstChild().getNode().getElementType() == PgTypes.PG_DO)) {
            return null;
        }
        ASTNode asNode = TreeUtil.findSiblingBackward((ASTNode)node, (IElementType)PostgresReservedKeywords.PG_AS);
        if (statement instanceof SqlCreateProcedureStatement && asNode == null) {
            return null;
        }
        ASTNode langNode = null;
        for (ASTNode n = nodeParent.getFirstChildNode(); n != null; n = n.getTreeNext()) {
            ASTNode fc = n.getFirstChildNode();
            if (PsiUtilCore.getElementType((ASTNode)fc) != PostgresOptionalKeywords.PG_LANGUAGE) continue;
            langNode = fc;
            break;
        }
        Object v0 = lang = langNode == null ? null : SqlImplUtil.getSiblingToTheRightOfType(langNode.getPsi(), true, PsiElement.class);
        if (lang == context) {
            return null;
        }
        String text2 = lang == null ? null : lang.getText();
        return this.getLangBySpec(text2, context);
    }

    @Override
    protected Pair<Language, String> getLangBySpec(@Nullable String text2, @NotNull PsiElement host) {
        if (host == null) {
            FunctionBodyInjector.$$$reportNull$$$0(4);
        }
        return FunctionBodyInjector.getBlockByLangSpec(text2, host);
    }

    @Nullable
    @Contract(value="null,_->!null")
    public static Pair<Language, String> getBlockByLangSpec(@Nullable String text2, @Nullable PsiElement host) {
        String string = text2 = text2 == null ? null : Case.LOWER.apply(text2);
        if (text2 == null) {
            SqlFileElementType.setPlSubDialect(host, true);
            return Pair.create((Object)((Object)PostgresDialect.INSTANCE), null);
        }
        if ((text2 = text2.substring(text2.startsWith("plpg") ? 4 : (text2.startsWith("pl") ? 2 : 0), text2.endsWith("u") ? text2.length() - 1 : text2.length())).contains("sql")) {
            SqlFileElementType.setPlSubDialect(host, true);
            return new Pair((Object)PostgresDialect.INSTANCE, (Object)text2);
        }
        SqlFileElementType.setPlSubDialect(host, false);
        return SqlFunctionBodyInjector.getLangBySpecInner(text2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/postgres/psi/FunctionBodyInjector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/postgres/psi/FunctionBodyInjector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calcBodyLanguage";
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLangBySpec";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

