/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.util.ReflectionAssignabilityCache;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.TypeChooserManager;
import com.intellij.util.xml.highlighting.DomElementsAnnotator;
import com.intellij.util.xml.impl.DomImplementationClassEP;
import com.intellij.util.xml.impl.ImplementationClassCache;
import com.intellij.util.xml.impl.InvocationCache;
import com.intellij.util.xml.impl.StaticGenericInfo;
import com.intellij.util.xml.impl.VisitorDescription;
import gnu.trove.THashSet;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class DomApplicationComponent {
    private final Map<String, Set<DomFileDescription>> g = FactoryMap.create(string -> new THashSet());
    private final Set<DomFileDescription> c = new THashSet();
    private final ImplementationClassCache h = new ImplementationClassCache(DomImplementationClassEP.EP_NAME);
    private final TypeChooserManager a = new TypeChooserManager();
    final ReflectionAssignabilityCache assignabilityCache = new ReflectionAssignabilityCache();
    private final Map<Class, DomElementsAnnotator> d = ConcurrentFactoryMap.createMap(clazz -> {
        DomFileDescription domFileDescription = this.a((Class)clazz);
        return domFileDescription == null ? null : domFileDescription.createAnnotator();
    });
    private final Map<Class, StaticGenericInfo> f = ConcurrentFactoryMap.createMap(StaticGenericInfo::new, ContainerUtil::createConcurrentSoftValueMap);
    private final Map<Class, InvocationCache> b = ConcurrentFactoryMap.createMap(InvocationCache::new, ContainerUtil::createConcurrentSoftValueMap);
    private final Map<Class<? extends DomElementVisitor>, VisitorDescription> e = ConcurrentFactoryMap.createMap(VisitorDescription::new);

    public DomApplicationComponent() {
        for (DomFileDescription domFileDescription : DomFileDescription.EP_NAME.getExtensionList()) {
            this.registerFileDescription(domFileDescription);
        }
    }

    public static DomApplicationComponent getInstance() {
        return (DomApplicationComponent)ServiceManager.getService(DomApplicationComponent.class);
    }

    public int getCumulativeVersion(boolean forStubs) {
        int n2 = 0;
        for (DomFileDescription domFileDescription : this.getAllFileDescriptions()) {
            if (forStubs) {
                if (!domFileDescription.hasStubs()) continue;
                n2 += domFileDescription.getStubVersion();
                n2 += domFileDescription.getRootTagName().hashCode();
                continue;
            }
            n2 += domFileDescription.getVersion();
            n2 += domFileDescription.getRootTagName().hashCode();
        }
        return n2;
    }

    public final synchronized Set<DomFileDescription> getFileDescriptions(String rootTagName) {
        return this.g.get(rootTagName);
    }

    public final synchronized Set<DomFileDescription> getAcceptingOtherRootTagNameDescriptions() {
        return this.c;
    }

    public final synchronized void registerFileDescription(DomFileDescription description) {
        this.g.get(description.getRootTagName()).add(description);
        if (description.acceptsOtherRootTagNames()) {
            this.c.add(description);
        }
        Map map = description.getImplementations();
        for (Map.Entry entry : map.entrySet()) {
            this.registerImplementation((Class)entry.getKey(), (Class)entry.getValue(), null);
        }
        this.a.copyFrom(description.getTypeChooserManager());
    }

    public synchronized List<DomFileDescription> getAllFileDescriptions() {
        ArrayList arrayList = ContainerUtil.newArrayList();
        for (Set<DomFileDescription> set : this.g.values()) {
            arrayList.addAll(set);
        }
        arrayList.addAll(this.c);
        return arrayList;
    }

    @Nullable
    private synchronized DomFileDescription a(Class clazz) {
        for (Set<DomFileDescription> domFileDescription : this.g.values()) {
            for (DomFileDescription domFileDescription2 : domFileDescription) {
                if (domFileDescription2.getRootElementClass() != clazz) continue;
                return domFileDescription2;
            }
        }
        for (DomFileDescription domFileDescription : this.c) {
            if (domFileDescription.getRootElementClass() != clazz) continue;
            return domFileDescription;
        }
        return null;
    }

    public DomElementsAnnotator getAnnotator(Class rootElementClass) {
        return this.d.get(rootElementClass);
    }

    @Nullable
    final Class<? extends DomElement> getImplementation(Class concreteInterface) {
        return this.h.get(concreteInterface);
    }

    public final void registerImplementation(Class<? extends DomElement> domElementClass, Class<? extends DomElement> implementationClass, @Nullable Disposable parentDisposable) {
        this.h.registerImplementation(domElementClass, implementationClass, parentDisposable);
    }

    public TypeChooserManager getTypeChooserManager() {
        return this.a;
    }

    public final StaticGenericInfo getStaticGenericInfo(Type type) {
        return this.f.get(ReflectionUtil.getRawType((Type)type));
    }

    final InvocationCache getInvocationCache(Class type) {
        return this.b.get(type);
    }

    public final VisitorDescription getVisitorDescription(Class<? extends DomElementVisitor> aClass) {
        return this.e.get(aClass);
    }
}

