/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.erb.psi;

import com.intellij.lang.Language;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.erb.ERbFileViewProvider;
import org.jetbrains.plugins.ruby.erb.ERbLanguage;
import org.jetbrains.plugins.ruby.erb.psi.ERbFile;
import org.jetbrains.plugins.ruby.erb.psi.ERbTokenTypes;

public class ERbPsiUtil {
    private ERbPsiUtil() {
    }

    @Nullable
    public static ERbFile getERbFileRoot(PsiElement element) {
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        FileViewProvider fileViewProvider = psiFile.getViewProvider();
        PsiFile psiFile2 = fileViewProvider.getPsi(fileViewProvider.getBaseLanguage());
        return psiFile2 instanceof ERbFile ? (ERbFile)psiFile2 : null;
    }

    public static boolean isRubyCodeInjectionStart(IElementType tokenType) {
        return ERbTokenTypes.RHTML_SEPARATORS_STARTS.contains(tokenType);
    }

    public static boolean isRubyCodeInjectionEnd(IElementType tokenType) {
        return ERbTokenTypes.RHTML_SEPARATORS_ENDS.contains(tokenType);
    }

    public static boolean isInERbFile(PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        Language language = psiFile.getViewProvider().getBaseLanguage();
        return language == ERbLanguage.RHTML;
    }

    public static boolean isTemplateLanguageRoot(PsiFile file) {
        FileViewProvider fileViewProvider = file.getViewProvider();
        if (!(fileViewProvider instanceof ERbFileViewProvider)) {
            return false;
        }
        return file.getLanguage() == ((ERbFileViewProvider)fileViewProvider).getTemplateDataLanguage();
    }
}

