/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.model;

import b.h.la;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.InflectorService;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.StandardRailsPaths;
import org.jetbrains.plugins.ruby.rails.model.ModelsTableMappingUtil;
import org.jetbrains.plugins.ruby.rails.model.RailsModel;
import org.jetbrains.plugins.ruby.ruby.RubyPsiManager;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBodyStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.utils.RubyVirtualFileScanner;

public class ModelsInfo
implements Disposable {
    private static final Logger b;
    public static final int COLLECT_GC_THRESHOLD = 50;
    private final Module e;
    private VirtualFile f;
    private final BidirectionalMap<String, String> d = new BidirectionalMap();
    private final Map<VirtualFile, String> a = new HashMap<VirtualFile, String>();
    private MergingUpdateQueue g;
    private int c;
    private static final long h;

    public ModelsInfo(Module module, InflectorService inflectorService) {
        this.e = module;
        this.c = 0;
        if (inflectorService.isInflectorAvailable()) {
            this.parseModelsAndAttachModelsReparser();
        }
    }

    public static ModelsInfo getInstance(Module module) {
        return (ModelsInfo)ModuleServiceManager.getService((Module)module, ModelsInfo.class);
    }

    @Nullable
    public String[] getModelsNames(@NotNull String tableName) {
        List list2;
        if (tableName == null) {
            ModelsInfo.a(0);
        }
        if ((list2 = this.d.getKeysByValue((Object)tableName)) == null || list2.size() == 0) {
            return null;
        }
        return ArrayUtil.toStringArray((Collection)list2);
    }

    @Nullable
    public String getTableName(@NotNull String modelName) {
        if (modelName == null) {
            ModelsInfo.a(1);
        }
        return (String)this.d.get((Object)modelName);
    }

    public void dispose() {
        if (this.g != null) {
            this.g.cancelAllUpdates();
            Disposer.dispose((Disposable)this.g);
        }
    }

    void parseModelsAndAttachModelsReparser() {
        long l2 = h ^ 0x7CA7E1BADAF8L;
        StandardRailsPaths standardRailsPaths = RailsFacetUtil.getRailsAppPaths(this.e);
        if (standardRailsPaths == null) {
            return;
        }
        String string = standardRailsPaths.getModelsRootURL();
        this.f = VirtualFileManager.getInstance().refreshAndFindFileByUrl(string);
        if (this.f == null) {
            return;
        }
        final PsiManager psiManager = PsiManager.getInstance((Project)this.e.getProject());
        PsiDirectory psiDirectory = psiManager.findDirectory(this.f);
        this.g = new MergingUpdateQueue("Rails Models Info Updater", 5000, true, null).setRestartTimerOnAdd(true);
        this.e(null);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        RubyPsiManager.getInstance(this.e.getProject()).addChangeWatcher((PsiElement)psiDirectory, new RubyPsiManager.ChangesWatcher(){
            private long a;

            @Override
            public void onChange(PsiElement parentPsiElement) {
                VirtualFile virtualFile;
                long l2 = psiManager.getModificationTracker().getOutOfCodeBlockModificationCount();
                if (l2 <= this.a) {
                    return;
                }
                this.a = l2;
                PsiFile psiFile = parentPsiElement.getContainingFile();
                if (psiFile instanceof RFile) {
                    virtualFile = psiFile.getVirtualFile();
                } else if (parentPsiElement instanceof PsiDirectory) {
                    virtualFile = null;
                } else {
                    return;
                }
                if (parentPsiElement instanceof RFile || parentPsiElement instanceof PsiDirectory || parentPsiElement instanceof RClass || parentPsiElement instanceof RBodyStatement || parentPsiElement instanceof RCompoundStatement || parentPsiElement instanceof RCall || RubyPsiUtil.isRClassName(parentPsiElement) || RubyPsiUtil.getCoveringRCall(parentPsiElement) != null) {
                    ModelsInfo.this.b(virtualFile);
                }
            }
        });
    }

    private void b(@Nullable VirtualFile virtualFile) {
        Runnable runnable = () -> this.e(virtualFile);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.g.queue((Update)new ModelsInfoUpdate(this, virtualFile, runnable));
        } else {
            runnable.run();
        }
    }

    private void e(@Nullable VirtualFile virtualFile) {
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object;
            long l2 = h ^ 0x1D883BFDF35L;
            if (this.e.isDisposed() || this.f == null || !this.f.isValid() || virtualFile != null && !virtualFile.isValid()) {
                return;
            }
            ArrayList<RailsModel> arrayList = new ArrayList<RailsModel>();
            boolean bl2 = virtualFile == null;
            PsiManager psiManager = PsiManager.getInstance((Project)this.e.getProject());
            PsiFile psiFile = bl2 ? psiManager.findDirectory(this.f) : psiManager.findFile(virtualFile);
            ArrayList arrayList2 = new ArrayList();
            RubyVirtualFileScanner.addRubyFiles((PsiFileSystemItem)psiFile, arrayList2);
            for (RFile rFile : arrayList2) {
                object = PsiDocumentManager.getInstance((Project)rFile.getProject());
                Document document = object.getCachedDocument((PsiFile)rFile);
                if (document != null && object.isUncommited(document)) {
                    ApplicationManager.getApplication().invokeLater(() -> this.a((PsiDocumentManager)object, document, bl2, virtualFile));
                    return;
                }
                RailsModel railsModel = RailsModel.fromFile(this.e, rFile.getVirtualFile());
                if (railsModel == null) continue;
                arrayList.add(railsModel);
            }
            if (arrayList.isEmpty()) {
                return;
            }
            long l3 = System.currentTimeMillis();
            object = this;
            synchronized (object) {
                this.a(arrayList, bl2);
            }
            long l4 = System.currentTimeMillis() - l3;
            b.debug("Models Info: Reparsed " + arrayList.size() + " modles files in " + l4 + " ms");
        });
    }

    private void a(List<RailsModel> list2, boolean bl2) {
        if (bl2) {
            this.d.clear();
        }
        for (RailsModel railsModel : list2) {
            this.c(railsModel.getFile());
            RClass rClass = railsModel.getRClass();
            String string = ModelsTableMappingUtil.getTableNameIgnoringInheritance(rClass, this.e);
            String string2 = railsModel.getName();
            if (string == null) continue;
            this.d.put((Object)string2, (Object)string);
        }
        this.a();
    }

    private void c(VirtualFile virtualFile) {
        String string = this.a.remove(virtualFile);
        if (string != null) {
            this.d.remove((Object)string);
        }
    }

    private void a() {
        ++this.c;
        if (this.c < 50) {
            return;
        }
        this.c = 0;
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        for (Map.Entry<VirtualFile, String> virtualFile : this.a.entrySet()) {
            VirtualFile virtualFile2 = virtualFile.getKey();
            if (virtualFile2.isValid()) continue;
            this.d.remove((Object)virtualFile.getValue());
            arrayList.add(virtualFile2);
        }
        for (VirtualFile virtualFile : arrayList) {
            this.a.remove(virtualFile);
        }
    }

    private /* synthetic */ void a(PsiDocumentManager psiDocumentManager, Document document, boolean bl2, @Nullable VirtualFile virtualFile) {
        psiDocumentManager.commitDocument(document);
        this.b(bl2 ? null : virtualFile);
    }

    static {
        h = la.a(6848172387252781889L, -350016104242295606L, MethodHandles.lookup().lookupClass()).a(128141898203110L);
        b = Logger.getInstance(ModelsInfo.class);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = h ^ 0xCE04AB29732L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelName";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/model/ModelsInfo";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getModelsNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getTableName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ModelsInfoUpdate
    extends Update {
        private final VirtualFile a;
        private final Runnable b;

        public ModelsInfoUpdate(@NonNls Object identity, @Nullable VirtualFile file, Runnable runnable) {
            super(identity);
            this.a = file;
            this.b = runnable;
        }

        public void run() {
            this.b.run();
        }

        public boolean canEat(Update update) {
            VirtualFile virtualFile;
            if (!(update instanceof ModelsInfoUpdate)) {
                return false;
            }
            VirtualFile virtualFile2 = ((ModelsInfoUpdate)update).getFile();
            return Comparing.equal((Object)virtualFile2, (Object)(virtualFile = this.getFile())) || virtualFile == null;
        }

        public VirtualFile getFile() {
            return this.a;
        }
    }
}

