/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk;

import b.h.la;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NullableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.run.RubyLocalRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.version.management.SdkRefresher;

public class RubyVersionUtil {
    private static final List<String> d;
    public static final String JRUBY_9000 = "9.0.0.0.snapshot";
    @NonNls
    public static final String GET_PATCHLEVEL_SCRIPT = "print(defined?(RUBY_PATCHLEVEL) ? RUBY_PATCHLEVEL : 0)";
    protected static final Logger LOG;
    @NonNls
    private static final String b = "maglev";
    @NonNls
    private static final String e = "rubinius";
    private static final Pattern a;
    @NonNls
    private static final String c = "macruby";
    @NonNls
    private static final String f = "ir";
    private static final TreeMap<String, String> g;
    private static final long h;

    private RubyVersionUtil() {
    }

    @Nullable
    public static String extractPlatformFromVersion(@Nullable String version) {
        if (version == null) {
            return null;
        }
        int n2 = version.indexOf(91);
        int n3 = version.indexOf(93);
        if (n2 != -1 && n3 != -1) {
            return version.substring(n2 + 1, n3);
        }
        return null;
    }

    @Nullable
    static String getFullVersion(@Nullable Sdk sdk, @NotNull NullableConsumer<String> validationCallback) {
        RubyRunner rubyRunner;
        String string;
        Object object;
        if (validationCallback == null) {
            RubyVersionUtil.a(0);
        }
        if (sdk == null) {
            return null;
        }
        SdkAdditionalData sdkAdditionalData = sdk.getSdkAdditionalData();
        if (sdkAdditionalData instanceof RubySdkAdditionalData) {
            object = (RubySdkAdditionalData)sdkAdditionalData;
            String string2 = ((RubySdkAdditionalData)object).getNormalizedVersionString();
            if (string2 != null) {
                return string2;
            }
            string = ((RubySdkAdditionalData)object).getInterpreterPath(sdk);
            rubyRunner = ((RubySdkAdditionalData)object).getRunner(null);
        } else {
            string = sdk.getHomePath();
            assert (string != null);
            rubyRunner = RubyLocalRunner.getRunner(null);
        }
        object = null;
        try {
            object = RubyVersionUtil.getFullVersion(rubyRunner, string, true, validationCallback);
        }
        catch (ExecutionException executionException) {
            LOG.error((Throwable)executionException);
        }
        if (sdkAdditionalData instanceof RubySdkAdditionalData && SdkRefresher.isAutoRefreshable(sdk)) {
            ((RubySdkAdditionalData)sdkAdditionalData).setNormalizedVersionString((String)object);
        }
        return object;
    }

    @Nullable
    public static String getFullVersion(@NotNull RubyRunner runner, @NotNull String sdkHome, boolean doNormalize) throws ExecutionException {
        if (runner == null) {
            RubyVersionUtil.a(1);
        }
        if (sdkHome == null) {
            RubyVersionUtil.a(2);
        }
        return RubyVersionUtil.getFullVersion(runner, sdkHome, doNormalize, RubySdkType.DEFAULT_SDK_VALIDATION_CALLBACK);
    }

    @Nullable
    static String getFullVersion(@NotNull RubyRunner runner, @NotNull String sdkHome, boolean doNormalize, @NotNull NullableConsumer<String> validationCallback) throws ExecutionException {
        ProcessOutput processOutput;
        long l2 = h ^ 0x568D994C1005L;
        if (runner == null) {
            RubyVersionUtil.a(3);
        }
        if (sdkHome == null) {
            RubyVersionUtil.a(4);
        }
        if (validationCallback == null) {
            RubyVersionUtil.a(5);
        }
        if ((processOutput = runner.execute((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(sdkHome, d).inSameThread(30, RBundle.message((String)"ruby.fetching.version")))) == null) {
            return null;
        }
        String string = RubyVersionUtil.getSDKVersionByOutput(processOutput, doNormalize, validationCallback);
        String string2 = processOutput.getStdout();
        String[] stringArray = string2.split("\n");
        if (doNormalize && stringArray.length > 1) {
            String string3 = RubyVersionUtil.getPatchLevelFromText(stringArray[1]);
            return !StringUtil.isEmpty((String)string3) ? string + " p" + string3 : string;
        }
        return string;
    }

    private static boolean a(@NotNull ProcessOutput processOutput, @NotNull NullableConsumer<String> nullableConsumer) {
        String string;
        long l2 = h ^ 0x63B5C04F2A02L;
        if (processOutput == null) {
            RubyVersionUtil.a(6);
        }
        if (nullableConsumer == null) {
            RubyVersionUtil.a(7);
        }
        if ((string = processOutput.getStdout()).contains("JAVA_HOME")) {
            nullableConsumer.consume((Object)string);
            return false;
        }
        if (!StringUtil.isEmpty((String)processOutput.getStderr())) {
            String string2 = processOutput.getStderr();
            if (string2.contains("jdb was unexpected at this time.")) {
                string2 = string2 + RBundle.message((String)"sdk.error.old.x64");
            }
            if (processOutput.getExitCode() != 0 || processOutput.isTimeout()) {
                nullableConsumer.consume((Object)string2);
                return false;
            }
            LOG.warn("Unexpected output in stderr: " + string2);
        }
        return true;
    }

    @Nullable
    static String getSDKVersionByOutput(@NotNull ProcessOutput output, boolean doNormalize, @NotNull NullableConsumer<String> validationCallback) {
        String[] stringArray;
        if (output == null) {
            RubyVersionUtil.a(8);
        }
        if (validationCallback == null) {
            RubyVersionUtil.a(9);
        }
        if ((stringArray = output.getStdout().split("\n")).length == 0) {
            return null;
        }
        if (!RubyVersionUtil.a(output, validationCallback)) {
            return null;
        }
        String string = stringArray[0];
        return doNormalize ? RubyVersionUtil.normalizeSdkVersionText(string) : string;
    }

    @Nullable
    public static String getPatchLevel(@NotNull RubyRunner runner, @NotNull String sdkHome) throws IOException, ExecutionException {
        long l2 = h ^ 0x1D52BC7C8A8EL;
        if (runner == null) {
            RubyVersionUtil.a(10);
        }
        if (sdkHome == null) {
            RubyVersionUtil.a(11);
        }
        ProcessOutput processOutput = runner.executeInSameThread(RubyRunnerExecutionContext.create(RunnerUtil.collectCommands(sdkHome, GET_PATCHLEVEL_SCRIPT)));
        String string = processOutput.getStdout();
        if (!RubyVersionUtil.a(processOutput, RubySdkType.DEFAULT_SDK_VALIDATION_CALLBACK)) {
            return null;
        }
        return RubyVersionUtil.getPatchLevelFromText(string);
    }

    @Nullable
    public static String getPatchLevelFromText(String patchLevelText) {
        return TextUtil.isInteger(patchLevelText) ? patchLevelText : null;
    }

    public static String getPatchLevel(@NotNull String normalizedVersion) {
        int n2;
        if (normalizedVersion == null) {
            RubyVersionUtil.a(12);
        }
        if ((n2 = normalizedVersion.lastIndexOf(112)) > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i10 = n2 + 1; i10 < normalizedVersion.length() && StringUtil.isDecimalDigit((char)normalizedVersion.charAt(i10)); ++i10) {
                stringBuilder.append(normalizedVersion.charAt(i10));
            }
            return stringBuilder.toString();
        }
        return null;
    }

    static LanguageLevel extractLanguageLevelFromVersion(String version) {
        long l2 = h ^ 0x627998EF1984L;
        if (version == null) {
            return LanguageLevel.DEFAULT;
        }
        if (RubyVersionUtil.isRubinius(version) && VersionComparatorUtil.compare((String)RubyVersionUtil.getRubiniusShortVersion(version), (String)"2.0.0pre") >= 0) {
            return LanguageLevel.RUBY21;
        }
        if (VersionComparatorUtil.compare((String)JRubySdkUtil.getJRubyShortVersion(version), (String)"9.2.0.0") >= 0) {
            return LanguageLevel.RUBY25;
        }
        if (VersionComparatorUtil.compare((String)JRubySdkUtil.getJRubyShortVersion(version), (String)"9.1.0.0") >= 0) {
            return LanguageLevel.RUBY23;
        }
        if (VersionComparatorUtil.compare((String)JRubySdkUtil.getJRubyShortVersion(version), (String)JRUBY_9000) >= 0) {
            return LanguageLevel.RUBY22;
        }
        String string = RubyVersionUtil.a(version);
        if (VersionComparatorUtil.compare((String)string, (String)"2.6.0.preview1") >= 0) {
            return LanguageLevel.RUBY26;
        }
        if (VersionComparatorUtil.compare((String)string, (String)"2.5.0.preview1") >= 0) {
            return LanguageLevel.RUBY25;
        }
        if (VersionComparatorUtil.compare((String)string, (String)"2.4.0.preview1") >= 0) {
            return LanguageLevel.RUBY24;
        }
        if (VersionComparatorUtil.compare((String)string, (String)"2.3.0.preview1") >= 0) {
            return LanguageLevel.RUBY23;
        }
        if (VersionComparatorUtil.compare((String)string, (String)"2.2.0.preview1") >= 0) {
            return LanguageLevel.RUBY22;
        }
        if (VersionComparatorUtil.compare((String)string, (String)"2.1.0") >= 0) {
            return LanguageLevel.RUBY21;
        }
        if (version.contains("2.0.")) {
            return LanguageLevel.RUBY20;
        }
        if (version.contains("1.9.")) {
            return LanguageLevel.RUBY19;
        }
        if (version.contains("1.8.")) {
            return LanguageLevel.RUBY18;
        }
        return LanguageLevel.DEFAULT;
    }

    @NotNull
    static LanguageLevel extractLanguageLevelFromSdkName(@NotNull String sdkName) {
        if (sdkName == null) {
            RubyVersionUtil.a(13);
        }
        LanguageLevel languageLevel = RubyVersionUtil.extractLanguageLevelFromVersion(RubyVersionUtil.createFakeVersionStringFromSdkName(sdkName));
        if (languageLevel == null) {
            RubyVersionUtil.a(14);
        }
        return languageLevel;
    }

    @NotNull
    static String createFakeVersionStringFromSdkName(@NotNull String sdkName) {
        long l2 = h ^ 0x74220FD4DBB8L;
        if (sdkName == null) {
            RubyVersionUtil.a(15);
        }
        sdkName = StringUtil.trimStart((String)sdkName, (String)"RVM:").trim();
        sdkName = StringUtil.trimStart((String)sdkName, (String)"rbenv:").trim();
        sdkName = StringUtil.trimStart((String)sdkName, (String)"chruby:").trim();
        int n2 = (sdkName = StringUtil.trimStart((String)sdkName, (String)"asdf:").trim()).indexOf(32);
        if (n2 != -1) {
            sdkName = sdkName.substring(0, n2);
        }
        String string = "";
        int n3 = sdkName.indexOf("jruby-");
        if (n3 != -1) {
            Map.Entry<String, String> entry = g.floorEntry(sdkName = sdkName.substring(n3 + 6));
            String string2 = entry != null ? entry.getValue() : "1.1.1";
            string = " (" + string2 + ") VM";
        } else {
            n3 = sdkName.indexOf("ruby-");
            if (n3 != -1) {
                sdkName = sdkName.substring(n3 + 5);
            } else {
                n3 = sdkName.indexOf("rbx-");
                if (n3 != -1) {
                    String string3 = "rubinius " + sdkName.substring(n3 + 4) + " p0";
                    if (string3 == null) {
                        RubyVersionUtil.a(16);
                    }
                    return string3;
                }
            }
        }
        n3 = sdkName.indexOf(45);
        if (n3 > 0) {
            sdkName = sdkName.substring(0, n3);
        }
        String string4 = "ver." + sdkName + "p0" + string;
        if (string4 == null) {
            RubyVersionUtil.a(17);
        }
        return string4;
    }

    static String normalizeSdkVersionText(String rawVersionText) {
        long l2 = h ^ 0x210450D7DFADL;
        String string = rawVersionText.replaceFirst(" patchlevel \\d+\\s*\\)", ")");
        int n2 = (string = string.replace(") (", ", ")).indexOf(91);
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        string = string.replaceFirst("\\d{4}-\\d{2}-\\d{2}", "");
        string = string.replaceAll("\\(\\)", "");
        string = string.replaceAll("\\s\\s+", " ");
        string = string.replaceFirst("^j?ruby ", "ver.");
        string = string.replaceFirst("^IronRuby", "IR");
        string = string.replaceFirst("\\sversion\\s+", " ver.");
        string = string.trim();
        return string;
    }

    public static boolean isVersionGreaterOrEqual(@NotNull Sdk sdk, @NotNull String requiredVersionString) {
        String string;
        if (sdk == null) {
            RubyVersionUtil.a(18);
        }
        if (requiredVersionString == null) {
            RubyVersionUtil.a(19);
        }
        if ((string = sdk.getVersionString()) == null) {
            return false;
        }
        String string2 = RubyVersionUtil.getShortVersion(string);
        return string2 != null && VersionComparatorUtil.compare((String)string2, (String)requiredVersionString) >= 0;
    }

    @Nullable
    public static String getShortVersion(@NotNull String version) {
        String string;
        if (version == null) {
            RubyVersionUtil.a(20);
        }
        if ((string = RubyVersionUtil.a(version)) != null) {
            return string;
        }
        String string2 = JRubySdkUtil.getJRubyMRILikeShortVersion(version);
        if (string2 != null) {
            return string2;
        }
        return RubyVersionUtil.getRubiniusShortVersion(version);
    }

    @Nullable
    private static String a(@NotNull String string) {
        long l2 = h ^ 0x213C8038FC4EL;
        if (string == null) {
            RubyVersionUtil.a(21);
        }
        if (!string.startsWith("ver.") || string.contains("VM") || !string.contains("p")) {
            return null;
        }
        return string.substring(4, string.lastIndexOf(112)).trim();
    }

    @Nullable
    public static String getRubiniusShortVersion(@Nullable String version) {
        if (version == null) {
            return null;
        }
        Matcher matcher = a.matcher(version);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return version;
    }

    static boolean isIronRuby(@Nullable String version) {
        long l2 = h ^ 0x490435916E4CL;
        return version != null && version.toLowerCase(Locale.US).contains(f);
    }

    static boolean isMacRuby(@Nullable String version) {
        long l2 = h ^ 0x676F89CAC4D4L;
        return version != null && version.toLowerCase(Locale.US).contains(c);
    }

    static boolean isRubinius(@Nullable String version) {
        long l2 = h ^ 0x60A30F852E4CL;
        return version != null && version.toLowerCase(Locale.US).contains(e);
    }

    static boolean isMaglev(@Nullable String version) {
        long l2 = h ^ 0x6560EE8D1E8FL;
        return version != null && version.toLowerCase(Locale.US).contains(b);
    }

    static {
        h = la.a(-3188519463441393041L, 3463719084015412503L, MethodHandles.lookup().lookupClass()).a(30012908494303L);
        long l2 = h ^ 0x38567365A994L;
        d = Arrays.asList("-e", "puts RUBY_DESCRIPTION.strip; puts RUBY_PATCHLEVEL.to_s");
        LOG = Logger.getInstance(RubySdkType.class);
        a = Pattern.compile("rubinius\\s*([0-9]+(\\.[0-9A-z]+)*)\\s*.*");
        g = ContainerUtil.newTreeMap((Map)ContainerUtil.newHashMap(Arrays.asList("0", "1.6", "1.7", "9.0.0.0", "9.1.0.0", "9.2.0.0"), Arrays.asList("1.8.0", "1.9.0", "1.9.3", "2.2.0", "2.3.0", "2.5.0")));
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = h ^ 0xFC6125F3785L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validationCallback";
                break;
            }
            case 1: 
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 2: 
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "normalizedVersion";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkName";
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/sdk/RubyVersionUtil";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredVersionString";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/RubyVersionUtil";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "extractLanguageLevelFromSdkName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createFakeVersionStringFromSdkName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFullVersion";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "validateSDKVersionOutput";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSDKVersionByOutput";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPatchLevel";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "extractLanguageLevelFromSdkName";
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createFakeVersionStringFromSdkName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isVersionGreaterOrEqual";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getShortVersion";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getMriShortVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

