/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.gem.dependency;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.gem.dependency.DummyGemInfo;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;

public class GemDependencyElementManager
extends AbstractDiagramElementManager<GemInfo> {
    private Module myModule;

    @Nullable
    public GemInfo findInDataContext(DataContext context) {
        Module module = RModuleUtil.getInstance().getModule(context);
        if (module == null) {
            return null;
        }
        this.myModule = module;
        if (!BundlerUtil.hasGemfile((Module)module)) {
            return null;
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        if (sdk == null) {
            return null;
        }
        return new DummyGemInfo("Dummy", sdk, module);
    }

    public boolean isAcceptableAsNode(Object element) {
        return element instanceof GemInfo;
    }

    @Nullable
    public String getElementTitle(GemInfo element) {
        if (element instanceof DummyGemInfo && "Dummy".equals(element.getName())) {
            return ((DummyGemInfo)element).getModule().getName();
        }
        return element.getName();
    }

    @Nullable
    public SimpleColoredText getItemName(Object element, DiagramState presentation) {
        String text = "";
        if (element instanceof GemInfo) {
            text = ((GemInfo)element).getName();
        }
        return new SimpleColoredText(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    public String getNodeTooltip(GemInfo element) {
        return element.getName();
    }

    public String getEditorTitle(GemInfo element, DiagramState presentation, Collection<GemInfo> additionalElements) {
        return element instanceof DummyGemInfo ? ((DummyGemInfo)element).getModule().getName() : super.getEditorTitle((Object)element, presentation, additionalElements);
    }

    public Module getModule() {
        return this.myModule;
    }
}

