/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.check.CheckEngine;
import org.apache.ivy.core.deliver.DeliverEngine;
import org.apache.ivy.core.deliver.DeliverOptions;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.event.IvyListener;
import org.apache.ivy.core.install.InstallEngine;
import org.apache.ivy.core.install.InstallOptions;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.publish.PublishEngine;
import org.apache.ivy.core.publish.PublishOptions;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.repository.RepositoryManagementEngine;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.retrieve.RetrieveEngine;
import org.apache.ivy.core.retrieve.RetrieveOptions;
import org.apache.ivy.core.retrieve.RetrieveReport;
import org.apache.ivy.core.search.ModuleEntry;
import org.apache.ivy.core.search.OrganisationEntry;
import org.apache.ivy.core.search.RevisionEntry;
import org.apache.ivy.core.search.SearchEngine;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.core.sort.SortEngine;
import org.apache.ivy.core.sort.SortOptions;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.repository.TransferEvent;
import org.apache.ivy.plugins.repository.TransferListener;
import org.apache.ivy.plugins.resolver.BasicResolver;
import org.apache.ivy.util.HostUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.MessageLoggerEngine;

public class Ivy {
    private static final int KILO = 1024;
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final String IVY_VERSION;
    private static final String IVY_DATE;
    private boolean interrupted;
    private boolean bound;
    private IvySettings settings;
    private EventManager eventManager;
    private SortEngine sortEngine;
    private SearchEngine searchEngine;
    private CheckEngine checkEngine;
    private ResolveEngine resolveEngine;
    private RetrieveEngine retrieveEngine;
    private DeliverEngine deliverEngine;
    private PublishEngine publishEngine;
    private InstallEngine installEngine;
    private RepositoryManagementEngine repositoryEngine;
    private MessageLoggerEngine loggerEngine = new MessageLoggerEngine();

    public static String getIvyVersion() {
        return IVY_VERSION;
    }

    public static String getIvyDate() {
        return IVY_DATE;
    }

    public static String getIvyHomeURL() {
        return "http://ant.apache.org/ivy/";
    }

    public static Ivy newInstance() {
        Ivy ivy = new Ivy();
        ivy.bind();
        return ivy;
    }

    public static Ivy newInstance(IvySettings ivySettings) {
        Ivy ivy = new Ivy();
        ivy.setSettings(ivySettings);
        ivy.bind();
        return ivy;
    }

    public void bind() {
        this.pushContext();
        try {
            if (this.settings == null) {
                this.settings = new IvySettings();
            }
            if (this.eventManager == null) {
                this.eventManager = new EventManager();
            }
            if (this.sortEngine == null) {
                this.sortEngine = new SortEngine(this.settings);
            }
            if (this.searchEngine == null) {
                this.searchEngine = new SearchEngine(this.settings);
            }
            if (this.resolveEngine == null) {
                this.resolveEngine = new ResolveEngine(this.settings, this.eventManager, this.sortEngine);
            }
            if (this.retrieveEngine == null) {
                this.retrieveEngine = new RetrieveEngine(this.settings, this.eventManager);
            }
            if (this.deliverEngine == null) {
                this.deliverEngine = new DeliverEngine(this.settings);
            }
            if (this.publishEngine == null) {
                this.publishEngine = new PublishEngine(this.settings, this.eventManager);
            }
            if (this.installEngine == null) {
                this.installEngine = new InstallEngine(this.settings, this.searchEngine, this.resolveEngine);
            }
            if (this.repositoryEngine == null) {
                this.repositoryEngine = new RepositoryManagementEngine(this.settings, this.searchEngine, this.resolveEngine);
            }
            this.eventManager.addTransferListener(new TransferListener(){

                @Override
                public void transferProgress(TransferEvent transferEvent) {
                    switch (transferEvent.getEventType()) {
                        case 3: {
                            ResolveData resolveData = IvyContext.getContext().getResolveData();
                            if (resolveData != null && "quiet".equals(resolveData.getOptions().getLog())) break;
                            Message.progress();
                            break;
                        }
                        case 2: {
                            ResolveData resolveData = IvyContext.getContext().getResolveData();
                            if (resolveData != null && "quiet".equals(resolveData.getOptions().getLog())) break;
                            Message.endProgress(" (" + transferEvent.getTotalLength() / 1024L + "kB)");
                            break;
                        }
                    }
                }
            });
            this.bound = true;
        }
        finally {
            this.popContext();
        }
    }

    public Object execute(IvyCallback ivyCallback) {
        this.pushContext();
        try {
            Object object = ivyCallback.doInIvyContext(this, IvyContext.getContext());
            return object;
        }
        finally {
            this.popContext();
        }
    }

    public void pushContext() {
        if (IvyContext.getContext().peekIvy() != this) {
            IvyContext.pushNewContext();
            IvyContext.getContext().setIvy(this);
        } else {
            IvyContext.pushContext(IvyContext.getContext());
        }
    }

    public void popContext() {
        IvyContext.popContext();
    }

    public void configure(File file) throws ParseException, IOException {
        this.pushContext();
        try {
            this.assertBound();
            this.settings.load(file);
            this.postConfigure();
        }
        finally {
            this.popContext();
        }
    }

    public void configure(URL uRL) throws ParseException, IOException {
        this.pushContext();
        try {
            this.assertBound();
            this.settings.load(uRL);
            this.postConfigure();
        }
        finally {
            this.popContext();
        }
    }

    public void configureDefault() throws ParseException, IOException {
        this.pushContext();
        try {
            this.assertBound();
            this.settings.loadDefault();
            this.postConfigure();
        }
        finally {
            this.popContext();
        }
    }

    public void configureDefault14() throws ParseException, IOException {
        this.pushContext();
        try {
            this.assertBound();
            this.settings.loadDefault14();
            this.postConfigure();
        }
        finally {
            this.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check(URL uRL, String string) {
        this.pushContext();
        try {
            boolean bl = this.checkEngine.check(uRL, string);
            return bl;
        }
        finally {
            this.popContext();
        }
    }

    public ResolveReport resolve(File file) throws ParseException, IOException {
        this.pushContext();
        try {
            ResolveReport resolveReport = this.resolveEngine.resolve(file);
            return resolveReport;
        }
        finally {
            this.popContext();
        }
    }

    public ResolveReport resolve(URL uRL) throws ParseException, IOException {
        this.pushContext();
        try {
            ResolveReport resolveReport = this.resolveEngine.resolve(uRL);
            return resolveReport;
        }
        finally {
            this.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolveReport resolve(ModuleRevisionId moduleRevisionId, ResolveOptions resolveOptions, boolean bl) throws ParseException, IOException {
        this.pushContext();
        try {
            ResolveReport resolveReport = this.resolveEngine.resolve(moduleRevisionId, resolveOptions, bl);
            return resolveReport;
        }
        finally {
            this.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolveReport resolve(URL uRL, ResolveOptions resolveOptions) throws ParseException, IOException {
        this.pushContext();
        try {
            ResolveReport resolveReport = this.resolveEngine.resolve(uRL, resolveOptions);
            return resolveReport;
        }
        finally {
            this.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolveReport resolve(ModuleDescriptor moduleDescriptor, ResolveOptions resolveOptions) throws ParseException, IOException {
        this.pushContext();
        try {
            ResolveReport resolveReport = this.resolveEngine.resolve(moduleDescriptor, resolveOptions);
            return resolveReport;
        }
        finally {
            this.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolveReport install(ModuleRevisionId moduleRevisionId, String string, String string2, InstallOptions installOptions) throws IOException {
        this.pushContext();
        try {
            ResolveReport resolveReport = this.installEngine.install(moduleRevisionId, string, string2, installOptions);
            return resolveReport;
        }
        finally {
            this.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int retrieve(ModuleRevisionId moduleRevisionId, String string, RetrieveOptions retrieveOptions) throws IOException {
        this.pushContext();
        try {
            int n = this.retrieveEngine.retrieve(moduleRevisionId, string, retrieveOptions);
            return n;
        }
        finally {
            this.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetrieveReport retrieve(ModuleRevisionId moduleRevisionId, RetrieveOptions retrieveOptions) throws IOException {
        this.pushContext();
        try {
            RetrieveReport retrieveReport = this.retrieveEngine.retrieve(moduleRevisionId, retrieveOptions);
            return retrieveReport;
        }
        finally {
            this.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliver(ModuleRevisionId moduleRevisionId, String string, String string2) throws IOException, ParseException {
        this.pushContext();
        try {
            this.deliverEngine.deliver(moduleRevisionId, string, string2, DeliverOptions.newInstance(this.settings));
        }
        finally {
            this.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliver(String string, String string2, DeliverOptions deliverOptions) throws IOException, ParseException {
        this.pushContext();
        try {
            this.deliverEngine.deliver(string, string2, deliverOptions);
        }
        finally {
            this.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliver(ModuleRevisionId moduleRevisionId, String string, String string2, DeliverOptions deliverOptions) throws IOException, ParseException {
        this.pushContext();
        try {
            this.deliverEngine.deliver(moduleRevisionId, string, string2, deliverOptions);
        }
        finally {
            this.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection publish(ModuleRevisionId moduleRevisionId, Collection collection, String string, PublishOptions publishOptions) throws IOException {
        this.pushContext();
        try {
            Collection collection2 = this.publishEngine.publish(moduleRevisionId, collection, string, publishOptions);
            return collection2;
        }
        finally {
            this.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List sortNodes(Collection collection, SortOptions sortOptions) {
        this.pushContext();
        try {
            List list = this.getSortEngine().sortNodes(collection, sortOptions);
            return list;
        }
        finally {
            this.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List sortModuleDescriptors(Collection collection, SortOptions sortOptions) {
        this.pushContext();
        try {
            List list = this.getSortEngine().sortModuleDescriptors(collection, sortOptions);
            return list;
        }
        finally {
            this.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolvedModuleRevision findModule(ModuleRevisionId moduleRevisionId) {
        this.pushContext();
        try {
            ResolveOptions resolveOptions = new ResolveOptions();
            resolveOptions.setValidate(false);
            ResolvedModuleRevision resolvedModuleRevision = this.resolveEngine.findModule(moduleRevisionId, resolveOptions);
            return resolvedModuleRevision;
        }
        finally {
            this.popContext();
        }
    }

    public ModuleEntry[] listModuleEntries(OrganisationEntry organisationEntry) {
        this.pushContext();
        try {
            ModuleEntry[] moduleEntryArray = this.searchEngine.listModuleEntries(organisationEntry);
            return moduleEntryArray;
        }
        finally {
            this.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleId[] listModules(ModuleId moduleId, PatternMatcher patternMatcher) {
        this.pushContext();
        try {
            ModuleId[] moduleIdArray = this.searchEngine.listModules(moduleId, patternMatcher);
            return moduleIdArray;
        }
        finally {
            this.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleRevisionId[] listModules(ModuleRevisionId moduleRevisionId, PatternMatcher patternMatcher) {
        this.pushContext();
        try {
            ModuleRevisionId[] moduleRevisionIdArray = this.searchEngine.listModules(moduleRevisionId, patternMatcher);
            return moduleRevisionIdArray;
        }
        finally {
            this.popContext();
        }
    }

    public String[] listModules(String string) {
        this.pushContext();
        try {
            String[] stringArray = this.searchEngine.listModules(string);
            return stringArray;
        }
        finally {
            this.popContext();
        }
    }

    public OrganisationEntry[] listOrganisationEntries() {
        this.pushContext();
        try {
            OrganisationEntry[] organisationEntryArray = this.searchEngine.listOrganisationEntries();
            return organisationEntryArray;
        }
        finally {
            this.popContext();
        }
    }

    public String[] listOrganisations() {
        this.pushContext();
        try {
            String[] stringArray = this.searchEngine.listOrganisations();
            return stringArray;
        }
        finally {
            this.popContext();
        }
    }

    public RevisionEntry[] listRevisionEntries(ModuleEntry moduleEntry) {
        this.pushContext();
        try {
            RevisionEntry[] revisionEntryArray = this.searchEngine.listRevisionEntries(moduleEntry);
            return revisionEntryArray;
        }
        finally {
            this.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listRevisions(String string, String string2) {
        this.pushContext();
        try {
            String[] stringArray = this.searchEngine.listRevisions(string, string2);
            return stringArray;
        }
        finally {
            this.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listTokenValues(String string, Map map) {
        this.pushContext();
        try {
            String[] stringArray = this.searchEngine.listTokenValues(string, map);
            return stringArray;
        }
        finally {
            this.popContext();
        }
    }

    public void interrupt() {
        Thread thread = IvyContext.getContext().getOperatingThread();
        this.interrupt(thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt(Thread thread) {
        if (thread != null && thread.isAlive()) {
            if (thread == Thread.currentThread()) {
                throw new IllegalStateException("cannot call interrupt from ivy operating thread");
            }
            Message.verbose("interrupting operating thread...");
            thread.interrupt();
            Ivy ivy = this;
            synchronized (ivy) {
                this.interrupted = true;
            }
            try {
                Message.verbose("waiting clean interruption of operating thread");
                thread.join(this.settings.getInterruptTimeout());
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            if (thread.isAlive()) {
                Message.warn("waited clean interruption for too long: stopping operating thread");
                thread.stop();
            }
            ivy = this;
            synchronized (ivy) {
                this.interrupted = false;
            }
        }
    }

    public synchronized boolean isInterrupted() {
        return this.interrupted;
    }

    public void checkInterrupted() {
        if (this.isInterrupted()) {
            Message.info("operation interrupted");
            throw new RuntimeException("operation interrupted");
        }
    }

    public static String getWorkingRevision() {
        return "working@" + HostUtil.getLocalHostName();
    }

    public ResolutionCacheManager getResolutionCacheManager() {
        return this.settings.getResolutionCacheManager();
    }

    private void assertBound() {
        if (!this.bound) {
            this.bind();
        }
    }

    private void postConfigure() {
        List list = this.settings.getTriggers();
        for (Object object : list) {
            this.eventManager.addIvyListener((IvyListener)object, object.getEventFilter());
        }
        for (Object object : this.settings.getResolvers()) {
            if (!(object instanceof BasicResolver)) continue;
            ((BasicResolver)object).setEventManager(this.eventManager);
        }
    }

    public String getVariable(String string) {
        this.pushContext();
        try {
            this.assertBound();
            String string2 = this.settings.getVariable(string);
            return string2;
        }
        finally {
            this.popContext();
        }
    }

    public String substitute(String string) {
        this.pushContext();
        try {
            this.assertBound();
            String string2 = this.settings.substitute(string);
            return string2;
        }
        finally {
            this.popContext();
        }
    }

    public void setVariable(String string, String string2) {
        this.pushContext();
        try {
            this.assertBound();
            this.settings.setVariable(string, string2);
        }
        finally {
            this.popContext();
        }
    }

    public IvySettings getSettings() {
        return this.settings;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public CheckEngine getCheckEngine() {
        return this.checkEngine;
    }

    public void setCheckEngine(CheckEngine checkEngine) {
        this.checkEngine = checkEngine;
    }

    public DeliverEngine getDeliverEngine() {
        return this.deliverEngine;
    }

    public void setDeliverEngine(DeliverEngine deliverEngine) {
        this.deliverEngine = deliverEngine;
    }

    public InstallEngine getInstallEngine() {
        return this.installEngine;
    }

    public void setInstallEngine(InstallEngine installEngine) {
        this.installEngine = installEngine;
    }

    public PublishEngine getPublishEngine() {
        return this.publishEngine;
    }

    public void setPublishEngine(PublishEngine publishEngine) {
        this.publishEngine = publishEngine;
    }

    public ResolveEngine getResolveEngine() {
        return this.resolveEngine;
    }

    public void setResolveEngine(ResolveEngine resolveEngine) {
        this.resolveEngine = resolveEngine;
    }

    public RetrieveEngine getRetrieveEngine() {
        return this.retrieveEngine;
    }

    public void setRetrieveEngine(RetrieveEngine retrieveEngine) {
        this.retrieveEngine = retrieveEngine;
    }

    public SearchEngine getSearchEngine() {
        return this.searchEngine;
    }

    public void setSearchEngine(SearchEngine searchEngine) {
        this.searchEngine = searchEngine;
    }

    public SortEngine getSortEngine() {
        return this.sortEngine;
    }

    public void setSortEngine(SortEngine sortEngine) {
        this.sortEngine = sortEngine;
    }

    public RepositoryManagementEngine getRepositoryEngine() {
        return this.repositoryEngine;
    }

    public void setRepositoryEngine(RepositoryManagementEngine repositoryManagementEngine) {
        this.repositoryEngine = repositoryManagementEngine;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void setSettings(IvySettings ivySettings) {
        this.settings = ivySettings;
    }

    public MessageLoggerEngine getLoggerEngine() {
        return this.loggerEngine;
    }

    static {
        Properties properties = new Properties();
        URL uRL = Message.class.getResource("/module.properties");
        if (uRL != null) {
            try {
                InputStream inputStream = uRL.openStream();
                properties.load(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        IVY_VERSION = properties.getProperty("version", "non official version");
        IVY_DATE = properties.getProperty("date", "");
    }

    public static interface IvyCallback {
        public Object doInIvyContext(Ivy var1, IvyContext var2);
    }
}

