/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.r;

import org.graalvm.visualvm.heapviewer.truffle.TruffleLanguage;
import org.graalvm.visualvm.heapviewer.truffle.lang.r.RHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.lang.r.RNodes;
import org.graalvm.visualvm.heapviewer.truffle.lang.r.RObject;
import org.graalvm.visualvm.heapviewer.truffle.lang.r.RType;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.openide.util.Lookup;

public class RLanguage
extends TruffleLanguage<RObject, RType, RHeapFragment> {
    private static final String ID = "r";
    private static final String R_LANGINFO_ID = "R";
    private static RLanguage INSTANCE;

    static synchronized RLanguage instance() {
        if (INSTANCE == null) {
            Lookup.getDefault().lookup(RLanguage.class);
        }
        return INSTANCE;
    }

    public RLanguage() {
        INSTANCE = this;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    protected RHeapFragment createFragment(Heap heap) {
        Instance langID = RLanguage.getLanguageInfo(heap, R_LANGINFO_ID);
        if (langID == null) {
            return null;
        }
        JavaClass rMainClass = heap.getJavaClassByName("com.oracle.truffle.r.runtime.data.RBaseObject");
        if (rMainClass == null) {
            return null;
        }
        return new RHeapFragment(this, langID, heap);
    }

    @Override
    public Class<RObject> getLanguageObjectClass() {
        return RObject.class;
    }

    @Override
    public boolean isLanguageObject(Instance instance) {
        return RObject.isRObject(instance);
    }

    @Override
    public RObject createObject(Instance instance) {
        return new RObject(instance);
    }

    @Override
    public RType createType(String name) {
        return new RType(name);
    }

    public RNodes.RObjectNode createObjectNode(RObject object, String type) {
        return new RNodes.RObjectNode(object, type);
    }

    public RNodes.RLocalObjectNode createLocalObjectNode(RObject object, String type) {
        return new RNodes.RLocalObjectNode(object, type);
    }

    public RNodes.RTypeNode createTypeNode(RType type, Heap heap) {
        return new RNodes.RTypeNode(type);
    }
}

