/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.ui;

import java.util.Objects;
import javax.swing.table.TableColumn;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.ui.Bundle;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerNumberRenderer;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.ui.swing.renderer.HideableBarRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;

public class TreeTableViewColumn
extends TableColumn {
    private final int position;
    private final DataType dataType;
    private final boolean initiallyVisible;
    private final boolean initiallySorting;

    public TreeTableViewColumn(String name, int position, DataType dataType, boolean sortingColumn) {
        this(name, position, dataType, true, sortingColumn);
    }

    public TreeTableViewColumn(String name, int position, DataType dataType, boolean initiallyVisible, boolean initiallySorting) {
        this.position = position;
        this.dataType = dataType;
        this.initiallyVisible = initiallyVisible;
        this.initiallySorting = initiallySorting;
        this.setHeaderValue(name);
    }

    public int getPosition() {
        return this.position;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public boolean initiallyVisible() {
        return this.initiallyVisible;
    }

    public boolean initiallySorting() {
        return this.initiallySorting;
    }

    @Override
    public int getPreferredWidth() {
        return -1;
    }

    public ProfilerRenderer getRenderer() {
        return null;
    }

    public static TreeTableViewColumn[] classes(Heap heap, boolean sort) {
        return new TreeTableViewColumn[]{new Name(), new LogicalValue(), new Count(heap), new OwnSize(heap, true, sort), new RetainedSize(heap), new ObjectID(), new GCRoots(heap, false, false)};
    }

    public static TreeTableViewColumn[] classesMinimal(Heap heap, boolean sort) {
        return new TreeTableViewColumn[]{new Name(), new LogicalValue(), new Count(heap, false, false), new OwnSize(heap, false, false), new RetainedSize(heap, true, sort), new ObjectID()};
    }

    public static TreeTableViewColumn[] classesPlain(Heap heap) {
        return new TreeTableViewColumn[]{new Name(), new LogicalValue(), new Count(heap, false, false), new OwnSize(heap, false, false), new RetainedSize(heap, false, false), new ObjectID()};
    }

    public static TreeTableViewColumn[] instances(Heap heap, boolean sort) {
        return new TreeTableViewColumn[]{new Name(), new LogicalValue(), new OwnSize(heap, true, sort), new RetainedSize(heap), new ObjectID()};
    }

    public static TreeTableViewColumn[] instancesMinimal(Heap heap, boolean sort) {
        return new TreeTableViewColumn[]{new Name(), new LogicalValue(), new OwnSize(heap, false, false), new RetainedSize(heap, true, sort), new ObjectID()};
    }

    public static TreeTableViewColumn[] instancesPlain(Heap heap) {
        return new TreeTableViewColumn[]{new Name(), new LogicalValue(), new OwnSize(heap, false, false), new RetainedSize(heap, false, false), new ObjectID()};
    }

    public static abstract class Provider {
        public abstract TreeTableViewColumn[] getColumns(Heap var1, String var2);
    }

    public static class ObjectID
    extends TreeTableViewColumn {
        private final LabelRenderer renderer = new LabelRenderer(){

            public void setValue(Object value, int row) {
                if (value == null) {
                    this.setText("");
                } else if (Objects.equals(value, DataType.OBJECT_ID.getNoValue())) {
                    this.setText("-");
                } else if (Objects.equals(value, DataType.OBJECT_ID.getUnsupportedValue())) {
                    this.setText("");
                } else if (Objects.equals(value, DataType.OBJECT_ID.getNotAvailableValue())) {
                    this.setText("n/a");
                } else {
                    this.setText("0x" + Long.toHexString((Long)value));
                }
            }
        };
        private final int preferredWidth;

        public ObjectID() {
            this(false, false);
        }

        public ObjectID(boolean initiallyVisible, boolean initiallySorting) {
            super(Bundle.TreeTableViewColumn_ColObjectId(), 500, DataType.OBJECT_ID, initiallyVisible, initiallySorting);
            this.renderer.setHorizontalAlignment(11);
            this.renderer.setValue((Object)9223372036854775684L, -1);
            this.preferredWidth = this.renderer.getPreferredSize().width + 20;
        }

        @Override
        public int getPreferredWidth() {
            return this.preferredWidth;
        }

        @Override
        public ProfilerRenderer getRenderer() {
            return this.renderer;
        }
    }

    public static class RetainedSize
    extends TreeTableViewColumn {
        private final HideableBarRenderer renderer = new HideableBarRenderer((ProfilerRenderer)HeapViewerNumberRenderer.bytesInstance(DataType.RETAINED_SIZE));
        private final int preferredWidth;

        public RetainedSize(Heap heap) {
            this(heap, true, false);
        }

        public RetainedSize(Heap heap, boolean initiallyVisible, boolean initiallySorting) {
            super(Bundle.TreeTableViewColumn_ColRetained(), 400, DataType.RETAINED_SIZE, initiallyVisible, initiallySorting);
            this.renderer.setMaxValue(21474836L);
            this.preferredWidth = this.renderer.getMaxNoBarWidth() - 20;
            this.renderer.setMaxValue(heap.getSummary().getTotalLiveBytes());
        }

        @Override
        public int getPreferredWidth() {
            return this.preferredWidth;
        }

        @Override
        public ProfilerRenderer getRenderer() {
            return this.renderer;
        }
    }

    public static class OwnSize
    extends TreeTableViewColumn {
        private final HideableBarRenderer renderer = new HideableBarRenderer((ProfilerRenderer)HeapViewerNumberRenderer.bytesInstance(DataType.OWN_SIZE));
        private final int preferredWidth;

        public OwnSize(Heap heap) {
            this(heap, true, true);
        }

        public OwnSize(Heap heap, boolean initiallyVisible, boolean initiallySorting) {
            super(Bundle.TreeTableViewColumn_ColSize(), 300, DataType.OWN_SIZE, initiallyVisible, initiallySorting);
            this.renderer.setMaxValue(21474836L);
            this.preferredWidth = this.renderer.getMaxNoBarWidth() - 20;
            this.renderer.setMaxValue(heap.getSummary().getTotalLiveBytes());
        }

        @Override
        public int getPreferredWidth() {
            return this.preferredWidth;
        }

        @Override
        public ProfilerRenderer getRenderer() {
            return this.renderer;
        }
    }

    public static class GCRoots
    extends TreeTableViewColumn {
        private final HideableBarRenderer renderer = new HideableBarRenderer((ProfilerRenderer)HeapViewerNumberRenderer.decimalInstance(DataType.GCROOTS));
        private final int preferredWidth;

        public GCRoots(Heap heap) {
            this(heap, true, false);
        }

        public GCRoots(Heap heap, boolean initiallyVisible, boolean initiallySorting) {
            super(Bundle.TreeTableViewColumn_GCRoots(), 190, DataType.GCROOTS, initiallyVisible, initiallySorting);
            this.renderer.setMaxValue(2147483L);
            this.preferredWidth = this.renderer.getMaxNoBarWidth() - 20;
            this.renderer.setMaxValue((long)heap.getGCRoots().size());
        }

        @Override
        public int getPreferredWidth() {
            return this.preferredWidth;
        }

        @Override
        public ProfilerRenderer getRenderer() {
            return this.renderer;
        }
    }

    public static class Count
    extends TreeTableViewColumn {
        private final HideableBarRenderer renderer = new HideableBarRenderer((ProfilerRenderer)HeapViewerNumberRenderer.decimalInstance(DataType.COUNT));
        private final int preferredWidth;

        public Count(Heap heap) {
            this(heap, true, false);
        }

        public Count(Heap heap, boolean initiallyVisible, boolean initiallySorting) {
            super(Bundle.TreeTableViewColumn_ColCount(), 200, DataType.COUNT, initiallyVisible, initiallySorting);
            this.renderer.setMaxValue(2147483L);
            this.preferredWidth = this.renderer.getMaxNoBarWidth() - 20;
            this.renderer.setMaxValue(heap.getSummary().getTotalLiveInstances());
        }

        @Override
        public int getPreferredWidth() {
            return this.preferredWidth;
        }

        @Override
        public ProfilerRenderer getRenderer() {
            return this.renderer;
        }
    }

    public static class LogicalValue
    extends TreeTableViewColumn {
        private final LabelRenderer renderer = new LabelRenderer(){

            public void setValue(Object value, int row) {
                if (Objects.equals(value, DataType.OBJECT_ID.getNoValue())) {
                    this.setText("-");
                } else if (Objects.equals(value, DataType.OBJECT_ID.getUnsupportedValue())) {
                    this.setText("");
                } else if (Objects.equals(value, DataType.OBJECT_ID.getNotAvailableValue())) {
                    this.setText("n/a");
                } else {
                    super.setValue(value, row);
                }
            }
        };
        private final int preferredWidth;

        public LogicalValue() {
            this(false, false);
        }

        public LogicalValue(boolean initiallyVisible, boolean initiallySorting) {
            super(Bundle.TreeTableViewColumn_ColLogicalValue(), 150, DataType.LOGICAL_VALUE, initiallyVisible, initiallySorting);
            this.renderer.setValue((Object)"A typical-length logical value to setup the column width", -1);
            this.preferredWidth = this.renderer.getPreferredSize().width + 20;
        }

        @Override
        public int getPreferredWidth() {
            return this.preferredWidth;
        }

        @Override
        public ProfilerRenderer getRenderer() {
            return this.renderer;
        }
    }

    public static class Name
    extends TreeTableViewColumn {
        public Name() {
            this(false);
        }

        public Name(boolean initiallySorting) {
            super(Bundle.TreeTableViewColumn_ColName(), 100, DataType.NAME, true, initiallySorting);
        }
    }
}

