/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import java.util.LinkedList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.office.TableLine;
import writer2latex.util.Misc;

public class TableGridModel {
    private Node tableNode;
    private LinkedList cols = new LinkedList();
    private LinkedList rows = new LinkedList();
    private LinkedList cells = new LinkedList();
    private int nMaxCols = 0;

    public TableGridModel(Node node) {
        this.tableNode = node;
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nl = node.getChildNodes();
        int nLen = nl.getLength();
        int i = 0;
        while (i < nLen) {
            Node child = nl.item(i);
            if (child.getNodeType() == 1) {
                String sName = child.getNodeName();
                if (sName.equals("table:table-column")) {
                    this.readTableColumn(child, false, false);
                } else if (sName.equals("table:table-columns")) {
                    this.readTableColumns(child, false, false);
                } else if (sName.equals("table:table-column-group")) {
                    this.readTableColumnGroup(child, false, false);
                } else if (sName.equals("table:table-header-columns")) {
                    this.readTableHeaderColumns(child, false, false);
                } else if (sName.equals("table:table-row")) {
                    this.readTableRow(child, false, false);
                } else if (sName.equals("table:table-rows")) {
                    this.readTableRows(child, false, false);
                } else if (sName.equals("table:table-row-group")) {
                    this.readTableRowGroup(child, false, false);
                } else if (sName.equals("table:table-header-rows")) {
                    this.readTableHeaderRows(child, false, false);
                }
            }
            ++i;
        }
        int nRows = this.cells.size();
        int nRow = 0;
        while (nRow < nRows) {
            LinkedList row = (LinkedList)this.cells.get(nRow);
            int nCols = row.size();
            int nMaxCol = 0;
            int nCol = 0;
            while (nCol < nCols) {
                Element cell = (Element)row.get(nCol);
                if (cell.hasChildNodes() && (nMaxCol = nCol + Misc.getPosInteger(cell.getAttribute("table:number-columns-spanned"), 1)) > this.nMaxCols) {
                    this.nMaxCols = nMaxCol;
                }
                ++nCol;
            }
            ++nRow;
        }
    }

    private void readTableColumn(Node node, boolean bHeader, boolean bDisplay) {
        int nRepeat = Misc.getPosInteger(Misc.getAttribute(node, "table:number-columns-repeated"), 1);
        while (nRepeat-- > 0) {
            this.cols.add(new TableLine(node, bHeader, bDisplay));
        }
    }

    private void readTableColumns(Node node, boolean bHeader, boolean bDisplay) {
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nl = node.getChildNodes();
        int nLen = nl.getLength();
        int i = 0;
        while (i < nLen) {
            Node child = nl.item(i);
            if (child.getNodeType() == 1) {
                String sName = child.getNodeName();
                if (sName.equals("table:table-column")) {
                    this.readTableColumn(child, bHeader, bDisplay);
                } else if (sName.equals("table:table-column-group")) {
                    this.readTableColumnGroup(child, bHeader, bDisplay);
                }
            }
            ++i;
        }
    }

    private void readTableColumnGroup(Node node, boolean bHeader, boolean bDisplay) {
        boolean bl = bDisplay = !"false".equals(Misc.getAttribute(node, "table:display"));
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nl = node.getChildNodes();
        int nLen = nl.getLength();
        int i = 0;
        while (i < nLen) {
            Node child = nl.item(i);
            if (child.getNodeType() == 1) {
                String sName = child.getNodeName();
                if (sName.equals("table:table-header-columns")) {
                    this.readTableHeaderColumns(child, bHeader, bDisplay);
                } else if (sName.equals("table:table-column")) {
                    this.readTableColumn(child, bHeader, bDisplay);
                } else if (sName.equals("table:table-column-group")) {
                    this.readTableColumnGroup(child, bHeader, bDisplay);
                }
            }
            ++i;
        }
    }

    private void readTableHeaderColumns(Node node, boolean bHeader, boolean bDisplay) {
        this.readTableColumns(node, true, bDisplay);
    }

    private void readTableRow(Node node, boolean bHeader, boolean bDisplay) {
        int nRepeat = Misc.getPosInteger(Misc.getAttribute(node, "table:number-rows-repeated"), 1);
        while (nRepeat-- > 0) {
            this.rows.add(new TableLine(node, bHeader, bDisplay));
        }
        LinkedList<Element> row = new LinkedList<Element>();
        if (node.hasChildNodes()) {
            NodeList nl = node.getChildNodes();
            int nLen = nl.getLength();
            int i = 0;
            while (i < nLen) {
                Node child = nl.item(i);
                if (child.getNodeType() == 1) {
                    Element cell = (Element)child;
                    String sName = cell.getTagName();
                    if (sName.equals("table:table-cell")) {
                        nRepeat = Misc.getPosInteger(cell.getAttribute("table:number-columns-repeated"), 1);
                        while (nRepeat-- > 0) {
                            row.add(cell);
                        }
                    } else if (sName.equals("table:covered-table-cell")) {
                        nRepeat = Misc.getPosInteger(cell.getAttribute("table:number-columns-repeated"), 1);
                        while (nRepeat-- > 0) {
                            row.add(cell);
                        }
                    }
                }
                ++i;
            }
        }
        this.cells.add(row);
    }

    private void readTableRows(Node node, boolean bHeader, boolean bDisplay) {
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nl = node.getChildNodes();
        int nLen = nl.getLength();
        int i = 0;
        while (i < nLen) {
            Node child = nl.item(i);
            if (child.getNodeType() == 1) {
                String sName = child.getNodeName();
                if (sName.equals("table:table-row")) {
                    this.readTableRow(child, bHeader, bDisplay);
                } else if (sName.equals("table:table-row-group")) {
                    this.readTableRowGroup(child, bHeader, bDisplay);
                }
            }
            ++i;
        }
    }

    private void readTableRowGroup(Node node, boolean bHeader, boolean bDisplay) {
        boolean bl = bDisplay = !"false".equals(Misc.getAttribute(node, "table:display"));
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nl = node.getChildNodes();
        int nLen = nl.getLength();
        int i = 0;
        while (i < nLen) {
            Node child = nl.item(i);
            if (child.getNodeType() == 1) {
                String sName = child.getNodeName();
                if (sName.equals("table:table-header-rows")) {
                    this.readTableHeaderRows(child, bHeader, bDisplay);
                } else if (sName.equals("table:table-row")) {
                    this.readTableRow(child, bHeader, bDisplay);
                } else if (sName.equals("table:table-row-group")) {
                    this.readTableRowGroup(child, bHeader, bDisplay);
                }
            }
            ++i;
        }
    }

    private void readTableHeaderRows(Node node, boolean bHeader, boolean bDisplay) {
        this.readTableRows(node, true, bDisplay);
    }

    public int getColCount() {
        return this.cols.size();
    }

    public int getMaxColCount() {
        return this.nMaxCols;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Node getTableNode() {
        return this.tableNode;
    }

    public Node getCell(int nRow, int nCol) {
        if (nRow < 0 || nRow >= this.cells.size()) {
            return null;
        }
        LinkedList row = (LinkedList)this.cells.get(nRow);
        if (nCol < 0 || nCol >= row.size()) {
            return null;
        }
        return (Node)row.get(nCol);
    }

    public TableLine getRow(int nRow) {
        if (nRow < 0 || nRow >= this.rows.size()) {
            return null;
        }
        return (TableLine)this.rows.get(nRow);
    }

    public TableLine getCol(int nCol) {
        if (nCol < 0 || nCol >= this.cols.size()) {
            return null;
        }
        return (TableLine)this.cols.get(nCol);
    }
}

