/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.WaitStrategy;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TimeoutBlockingWaitStrategy
implements WaitStrategy {
    private final Lock lock = new ReentrantLock();
    private final Condition processorNotifyCondition = this.lock.newCondition();
    private final long timeoutInNanos;

    public TimeoutBlockingWaitStrategy(long timeout, TimeUnit units) {
        this.timeoutInNanos = units.toNanos(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long waitFor(long sequence, Sequence cursorSequence, Sequence dependentSequence, SequenceBarrier barrier) throws AlertException, InterruptedException, TimeoutException {
        long nanos = this.timeoutInNanos;
        long availableSequence = cursorSequence.get();
        if (availableSequence < sequence) {
            this.lock.lock();
            try {
                while ((availableSequence = cursorSequence.get()) < sequence) {
                    barrier.checkAlert();
                    if ((nanos = this.processorNotifyCondition.awaitNanos(nanos)) > 0L) continue;
                    throw TimeoutException.INSTANCE;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        while ((availableSequence = dependentSequence.get()) < sequence) {
            barrier.checkAlert();
        }
        return availableSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalAllWhenBlocking() {
        this.lock.lock();
        try {
            this.processorNotifyCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

