/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Variant {
    public static final int VT_EMPTY = 0;
    public static final int VT_NULL = 1;
    public static final int VT_I2 = 2;
    public static final int VT_I4 = 3;
    public static final int VT_R4 = 4;
    public static final int VT_R8 = 5;
    public static final int VT_CY = 6;
    public static final int VT_DATE = 7;
    public static final int VT_BSTR = 8;
    public static final int VT_DISPATCH = 9;
    public static final int VT_ERROR = 10;
    public static final int VT_BOOL = 11;
    public static final int VT_VARIANT = 12;
    public static final int VT_UNKNOWN = 13;
    public static final int VT_DECIMAL = 14;
    public static final int VT_I1 = 16;
    public static final int VT_UI1 = 17;
    public static final int VT_UI2 = 18;
    public static final int VT_UI4 = 19;
    public static final int VT_I8 = 20;
    public static final int VT_UI8 = 21;
    public static final int VT_INT = 22;
    public static final int VT_UINT = 23;
    public static final int VT_VOID = 24;
    public static final int VT_HRESULT = 25;
    public static final int VT_PTR = 26;
    public static final int VT_SAFEARRAY = 27;
    public static final int VT_CARRAY = 28;
    public static final int VT_USERDEFINED = 29;
    public static final int VT_LPSTR = 30;
    public static final int VT_LPWSTR = 31;
    public static final int VT_FILETIME = 64;
    public static final int VT_BLOB = 65;
    public static final int VT_STREAM = 66;
    public static final int VT_STORAGE = 67;
    public static final int VT_STREAMED_OBJECT = 68;
    public static final int VT_STORED_OBJECT = 69;
    public static final int VT_BLOB_OBJECT = 70;
    public static final int VT_CF = 71;
    public static final int VT_CLSID = 72;
    public static final int VT_VECTOR = 4096;
    public static final int VT_ARRAY = 8192;
    public static final int VT_BYREF = 16384;
    public static final int VT_RESERVED = 32768;
    public static final int VT_ILLEGAL = 65535;
    public static final int VT_ILLEGALMASKED = 4095;
    public static final int VT_TYPEMASK = 4095;
    private static Map numberToName;
    private static Map numberToLength;
    public static final Integer LENGTH_UNKNOWN;
    public static final Integer LENGTH_VARIABLE;
    public static final Integer LENGTH_0;
    public static final Integer LENGTH_2;
    public static final Integer LENGTH_4;
    public static final Integer LENGTH_8;

    public static String getVariantName(long variantType) {
        String name = (String)numberToName.get(new Long(variantType));
        return name != null ? name : "unknown variant type";
    }

    public static int getVariantLength(long variantType) {
        Long key = new Long((int)variantType);
        Long length = (Long)numberToLength.get(key);
        if (length == null) {
            return -2;
        }
        return length.intValue();
    }

    static {
        LENGTH_UNKNOWN = new Integer(-2);
        LENGTH_VARIABLE = new Integer(-1);
        LENGTH_0 = new Integer(0);
        LENGTH_2 = new Integer(2);
        LENGTH_4 = new Integer(4);
        LENGTH_8 = new Integer(8);
        HashMap<Long, Object> tm1 = new HashMap<Long, Object>();
        tm1.put(new Long(0L), "VT_EMPTY");
        tm1.put(new Long(1L), "VT_NULL");
        tm1.put(new Long(2L), "VT_I2");
        tm1.put(new Long(3L), "VT_I4");
        tm1.put(new Long(4L), "VT_R4");
        tm1.put(new Long(5L), "VT_R8");
        tm1.put(new Long(6L), "VT_CY");
        tm1.put(new Long(7L), "VT_DATE");
        tm1.put(new Long(8L), "VT_BSTR");
        tm1.put(new Long(9L), "VT_DISPATCH");
        tm1.put(new Long(10L), "VT_ERROR");
        tm1.put(new Long(11L), "VT_BOOL");
        tm1.put(new Long(12L), "VT_VARIANT");
        tm1.put(new Long(13L), "VT_UNKNOWN");
        tm1.put(new Long(14L), "VT_DECIMAL");
        tm1.put(new Long(16L), "VT_I1");
        tm1.put(new Long(17L), "VT_UI1");
        tm1.put(new Long(18L), "VT_UI2");
        tm1.put(new Long(19L), "VT_UI4");
        tm1.put(new Long(20L), "VT_I8");
        tm1.put(new Long(21L), "VT_UI8");
        tm1.put(new Long(22L), "VT_INT");
        tm1.put(new Long(23L), "VT_UINT");
        tm1.put(new Long(24L), "VT_VOID");
        tm1.put(new Long(25L), "VT_HRESULT");
        tm1.put(new Long(26L), "VT_PTR");
        tm1.put(new Long(27L), "VT_SAFEARRAY");
        tm1.put(new Long(28L), "VT_CARRAY");
        tm1.put(new Long(29L), "VT_USERDEFINED");
        tm1.put(new Long(30L), "VT_LPSTR");
        tm1.put(new Long(31L), "VT_LPWSTR");
        tm1.put(new Long(64L), "VT_FILETIME");
        tm1.put(new Long(65L), "VT_BLOB");
        tm1.put(new Long(66L), "VT_STREAM");
        tm1.put(new Long(67L), "VT_STORAGE");
        tm1.put(new Long(68L), "VT_STREAMED_OBJECT");
        tm1.put(new Long(69L), "VT_STORED_OBJECT");
        tm1.put(new Long(70L), "VT_BLOB_OBJECT");
        tm1.put(new Long(71L), "VT_CF");
        tm1.put(new Long(72L), "VT_CLSID");
        HashMap<Long, Object> tm2 = new HashMap<Long, Object>(tm1.size(), 1.0f);
        tm2.putAll(tm1);
        numberToName = Collections.unmodifiableMap(tm2);
        tm1.clear();
        tm1.put(new Long(0L), LENGTH_0);
        tm1.put(new Long(1L), LENGTH_UNKNOWN);
        tm1.put(new Long(2L), LENGTH_2);
        tm1.put(new Long(3L), LENGTH_4);
        tm1.put(new Long(4L), LENGTH_4);
        tm1.put(new Long(5L), LENGTH_8);
        tm1.put(new Long(6L), LENGTH_UNKNOWN);
        tm1.put(new Long(7L), LENGTH_UNKNOWN);
        tm1.put(new Long(8L), LENGTH_UNKNOWN);
        tm1.put(new Long(9L), LENGTH_UNKNOWN);
        tm1.put(new Long(10L), LENGTH_UNKNOWN);
        tm1.put(new Long(11L), LENGTH_UNKNOWN);
        tm1.put(new Long(12L), LENGTH_UNKNOWN);
        tm1.put(new Long(13L), LENGTH_UNKNOWN);
        tm1.put(new Long(14L), LENGTH_UNKNOWN);
        tm1.put(new Long(16L), LENGTH_UNKNOWN);
        tm1.put(new Long(17L), LENGTH_UNKNOWN);
        tm1.put(new Long(18L), LENGTH_UNKNOWN);
        tm1.put(new Long(19L), LENGTH_UNKNOWN);
        tm1.put(new Long(20L), LENGTH_UNKNOWN);
        tm1.put(new Long(21L), LENGTH_UNKNOWN);
        tm1.put(new Long(22L), LENGTH_UNKNOWN);
        tm1.put(new Long(23L), LENGTH_UNKNOWN);
        tm1.put(new Long(24L), LENGTH_UNKNOWN);
        tm1.put(new Long(25L), LENGTH_UNKNOWN);
        tm1.put(new Long(26L), LENGTH_UNKNOWN);
        tm1.put(new Long(27L), LENGTH_UNKNOWN);
        tm1.put(new Long(28L), LENGTH_UNKNOWN);
        tm1.put(new Long(29L), LENGTH_UNKNOWN);
        tm1.put(new Long(30L), LENGTH_VARIABLE);
        tm1.put(new Long(31L), LENGTH_UNKNOWN);
        tm1.put(new Long(64L), LENGTH_8);
        tm1.put(new Long(65L), LENGTH_UNKNOWN);
        tm1.put(new Long(66L), LENGTH_UNKNOWN);
        tm1.put(new Long(67L), LENGTH_UNKNOWN);
        tm1.put(new Long(68L), LENGTH_UNKNOWN);
        tm1.put(new Long(69L), LENGTH_UNKNOWN);
        tm1.put(new Long(70L), LENGTH_UNKNOWN);
        tm1.put(new Long(71L), LENGTH_UNKNOWN);
        tm1.put(new Long(72L), LENGTH_UNKNOWN);
        tm2 = new HashMap(tm1.size(), 1.0f);
        tm2.putAll(tm1);
        numberToLength = Collections.unmodifiableMap(tm2);
    }
}

