/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.util.Date;
import net.sf.samtools.util.Iso8601Date;

public class RelativeIso8601Date
extends Iso8601Date {
    public static final String LAZY_NOW_LABEL = "NOW";
    private boolean doSetTimeNextQuery;

    public static RelativeIso8601Date generateLazyNowInstance() {
        return new RelativeIso8601Date(LAZY_NOW_LABEL);
    }

    public RelativeIso8601Date(Date date) {
        super(date);
        this.doSetTimeNextQuery = false;
    }

    public RelativeIso8601Date(String dateStr) {
        super(LAZY_NOW_LABEL.equals(dateStr) ? new Iso8601Date(new Date()).toString() : dateStr);
        this.doSetTimeNextQuery = LAZY_NOW_LABEL.equals(dateStr);
    }

    private synchronized void conditionallyUpdateTime() {
        if (!this.doSetTimeNextQuery) {
            super.setTime(System.currentTimeMillis());
            this.doSetTimeNextQuery = false;
        }
    }

    @Override
    public String toString() {
        return this.doSetTimeNextQuery ? LAZY_NOW_LABEL : super.toString();
    }

    @Override
    public long getTime() {
        this.conditionallyUpdateTime();
        return super.getTime();
    }

    @Override
    public boolean after(Date when) {
        this.conditionallyUpdateTime();
        return super.after(when);
    }

    @Override
    public boolean before(Date when) {
        this.conditionallyUpdateTime();
        return super.before(when);
    }

    @Override
    public Object clone() {
        this.conditionallyUpdateTime();
        return super.clone();
    }

    @Override
    public int compareTo(Date anotherDate) {
        this.conditionallyUpdateTime();
        return super.compareTo(anotherDate);
    }

    @Override
    public boolean equals(Object obj) {
        this.conditionallyUpdateTime();
        return super.equals(obj);
    }

    @Override
    public int getDate() {
        this.conditionallyUpdateTime();
        return super.getDate();
    }

    @Override
    public int getDay() {
        this.conditionallyUpdateTime();
        return super.getDay();
    }

    @Override
    public int getHours() {
        this.conditionallyUpdateTime();
        return super.getHours();
    }

    @Override
    public int getMinutes() {
        this.conditionallyUpdateTime();
        return super.getMinutes();
    }

    @Override
    public int getMonth() {
        this.conditionallyUpdateTime();
        return super.getMonth();
    }

    @Override
    public int getSeconds() {
        this.conditionallyUpdateTime();
        return super.getSeconds();
    }

    @Override
    public int getTimezoneOffset() {
        this.conditionallyUpdateTime();
        return super.getTimezoneOffset();
    }

    @Override
    public int getYear() {
        this.conditionallyUpdateTime();
        return super.getYear();
    }

    @Override
    public int hashCode() {
        this.conditionallyUpdateTime();
        return super.hashCode();
    }

    @Override
    public void setDate(int date) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHours(int hours) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMinutes(int minutes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMonth(int month) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSeconds(int seconds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTime(long time) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setYear(int year) {
        throw new UnsupportedOperationException();
    }
}

