// Copyright 2013 The Go Authors.  All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.
//
// +build ignore

package cgotest

/*
// This file tests a bug found in the cgo -cdefs tool that incorrectly
// translated Go pointer arrays generated by the cgo godefs tool back into C
// pointer arrays.
//
// The comments below show how the type is translated from gcc-style C into Go
// and back into C for both the buggy version and the correct version

struct cdefsTest {
	// This was already being handled correctly
	// Correct: -> Array [20]int8 -> int8 array[20]
	char array1[20];

	// Buggy:   -> Array [20][20]int8 -> [20]int8 array[20]
	// Correct: -> Array [20][20]int8 -> int8 array[20][20]
	char array2[20][20];

	// Buggy:   -> Array [20]*int8 -> *int8 array[20]
	// Correct: -> Array [20]*int8 -> int8 *array[20]
	char *array3[20];

	// Buggy:   -> Array [20][20]*int8 -> [20]*int8 array[20]
	// Correct: -> Array [20]**int8 -> int8 *array[20][20]
	char *array4[20][20];

	// Buggy:   -> Array [20][20]**int8 -> [20]**int8 array[20]
	// Correct: -> Array [20][20]**int8 -> int8 **array[20][20]
	char **array5[20][20];
};

// Test that packed structures can be translated to C correctly too.
// See issue 8477.

struct packedTest {
	char first;
	int second;
	long long third;
} __attribute__((packed));

// Test that conflicting type definitions don't cause problems with cgo.
// See issue 8477.

typedef struct timespec {
	double bogus;
} pid_t;

*/
import "C"

type CdefsTest C.struct_cdefsTest

//type PackedTest C.struct_packedTest
