/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.glyphs.ClosedShape;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import net.claribole.zvtm.glyphs.projection.BProjectedCoordsP;

public class VShape
extends ClosedShape {
    long vs;
    BProjectedCoordsP[] pc;
    float[] vertices;
    int[] xcoords;
    int[] ycoords;
    int[] lxcoords;
    int[] lycoords;

    public VShape(float[] v) {
        this.vx = 0L;
        this.vy = 0L;
        this.vz = 0;
        this.vs = 10L;
        this.vertices = v;
        this.xcoords = new int[this.vertices.length];
        this.ycoords = new int[this.vertices.length];
        this.lxcoords = new int[this.vertices.length];
        this.lycoords = new int[this.vertices.length];
        this.computeSize();
        this.orient = 0.0f;
        this.setColor(Color.white);
        this.setBorderColor(Color.black);
    }

    public VShape(long x, long y, int z, long s, float[] v, Color c, float or) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.vs = s;
        this.vertices = v;
        this.xcoords = new int[this.vertices.length];
        this.ycoords = new int[this.vertices.length];
        this.lxcoords = new int[this.vertices.length];
        this.lycoords = new int[this.vertices.length];
        this.computeSize();
        this.orient = or;
        this.setColor(c);
        this.setBorderColor(this.bColor);
    }

    public VShape(long x, long y, int z, long s, float[] v, Color c, Color bc, float or) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.vs = s;
        this.vertices = v;
        this.xcoords = new int[this.vertices.length];
        this.ycoords = new int[this.vertices.length];
        this.lxcoords = new int[this.vertices.length];
        this.lycoords = new int[this.vertices.length];
        this.computeSize();
        this.orient = or;
        this.setColor(c);
        this.setBorderColor(bc);
    }

    public void initCams(int nbCam) {
        this.pc = new BProjectedCoordsP[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new BProjectedCoordsP();
        }
    }

    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                BProjectedCoordsP[] ta = this.pc;
                this.pc = new BProjectedCoordsP[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pc[i] = ta[i];
                }
                this.pc[this.pc.length - 1] = new BProjectedCoordsP();
            } else {
                System.err.println("VShape:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new BProjectedCoordsP[1];
            this.pc[0] = new BProjectedCoordsP();
        } else {
            System.err.println("VShape:Error while adding camera " + verifIndex);
        }
    }

    public void removeCamera(int index) {
        this.pc[index] = null;
    }

    public void resetMouseIn() {
        for (int i = 0; i < this.pc.length; ++i) {
            this.resetMouseIn(i);
        }
    }

    public void resetMouseIn(int i) {
        if (this.pc[i] != null) {
            this.pc[i].prevMouseIn = false;
        }
        this.borderColor = this.bColor;
    }

    public float getOrient() {
        return this.orient;
    }

    public void orientTo(float angle) {
        this.orient = angle;
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public float getSize() {
        return this.size;
    }

    void computeSize() {
        this.size = this.vs;
    }

    public void sizeTo(float radius) {
        this.size = radius;
        this.vs = Math.round(this.size);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void reSize(float factor) {
        this.size *= factor;
        this.vs = Math.round(this.size);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public boolean fillsView(long w, long h, int camIndex) {
        return this.pc[camIndex].p.contains(0, 0) && this.pc[camIndex].p.contains(w, 0.0) && this.pc[camIndex].p.contains(0.0, h) && this.pc[camIndex].p.contains(w, h);
    }

    public boolean coordInside(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        return this.pc[camIndex].p.contains(jpx, jpy);
    }

    public boolean visibleInDisc(long dvx, long dvy, long dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return this.pc[camIndex].p.intersects(jpx - dpr, jpy - dpr, 2 * dpr, 2 * dpr);
    }

    public short mouseInOut(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        if (this.coordInside(jpx, jpy, camIndex, cvx, cvy)) {
            if (!this.pc[camIndex].prevMouseIn) {
                this.pc[camIndex].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[camIndex].prevMouseIn) {
            this.pc[camIndex].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    public float[] getVertices() {
        return this.vertices;
    }

    public String getVerticesAsText() {
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < this.vertices.length - 1; ++i) {
            res.append(this.vertices[i] + ",");
        }
        res.append(this.vertices[this.vertices.length - 1]);
        return res.toString();
    }

    public void project(Camera c, Dimension d) {
        int j;
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = d.width / 2 + Math.round((float)(this.vx - c.posx) * this.coef);
        this.pc[i].cy = d.height / 2 - Math.round((float)(this.vy - c.posy) * this.coef);
        this.pc[i].cr = Math.round((float)this.vs * this.coef);
        float vertexAngle = this.orient;
        for (j = 0; j < this.vertices.length - 1; ++j) {
            this.xcoords[j] = (int)Math.round((double)this.pc[i].cx + (double)this.pc[i].cr * Math.cos(vertexAngle) * (double)this.vertices[j]);
            this.ycoords[j] = (int)Math.round((double)this.pc[i].cy - (double)this.pc[i].cr * Math.sin(vertexAngle) * (double)this.vertices[j]);
            vertexAngle = (float)((double)vertexAngle + Math.PI * 2 / (double)this.vertices.length);
        }
        this.xcoords[this.vertices.length - 1] = (int)Math.round((double)this.pc[i].cx + (double)this.pc[i].cr * Math.cos(vertexAngle) * (double)this.vertices[this.vertices.length - 1]);
        this.ycoords[this.vertices.length - 1] = (int)Math.round((double)this.pc[i].cy - (double)this.pc[i].cr * Math.sin(vertexAngle) * (double)this.vertices[this.vertices.length - 1]);
        if (this.pc[i].p == null) {
            this.pc[i].p = new Polygon(this.xcoords, this.ycoords, this.vertices.length);
        } else {
            this.pc[i].p.npoints = this.xcoords.length;
            for (j = 0; j < this.xcoords.length; ++j) {
                this.pc[i].p.xpoints[j] = this.xcoords[j];
                this.pc[i].p.ypoints[j] = this.ycoords[j];
            }
            this.pc[i].p.invalidate();
        }
    }

    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, long lensx, long lensy) {
        int j;
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * lensMag;
        this.pc[i].lcx = lensWidth / 2 + Math.round((float)(this.vx - lensx) * this.coef);
        this.pc[i].lcy = lensHeight / 2 - Math.round((float)(this.vy - lensy) * this.coef);
        this.pc[i].lcr = Math.round((float)this.vs * this.coef);
        float vertexAngle = this.orient;
        for (j = 0; j < this.vertices.length - 1; ++j) {
            this.lxcoords[j] = (int)Math.round((double)this.pc[i].lcx + (double)this.pc[i].lcr * Math.cos(vertexAngle) * (double)this.vertices[j]);
            this.lycoords[j] = (int)Math.round((double)this.pc[i].lcy - (double)this.pc[i].lcr * Math.sin(vertexAngle) * (double)this.vertices[j]);
            vertexAngle = (float)((double)vertexAngle + Math.PI * 2 / (double)this.vertices.length);
        }
        this.lxcoords[this.vertices.length - 1] = (int)Math.round((double)this.pc[i].lcx + (double)this.pc[i].lcr * Math.cos(vertexAngle) * (double)this.vertices[this.vertices.length - 1]);
        this.lycoords[this.vertices.length - 1] = (int)Math.round((double)this.pc[i].lcy - (double)this.pc[i].lcr * Math.sin(vertexAngle) * (double)this.vertices[this.vertices.length - 1]);
        if (this.pc[i].lp == null) {
            this.pc[i].lp = new Polygon(this.lxcoords, this.lycoords, this.vertices.length);
        } else {
            this.pc[i].lp.npoints = this.xcoords.length;
            for (j = 0; j < this.xcoords.length; ++j) {
                this.pc[i].lp.xpoints[j] = this.lxcoords[j];
                this.pc[i].lp.ypoints[j] = this.lycoords[j];
            }
            this.pc[i].lp.invalidate();
        }
    }

    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].cr > 1) {
            if (this.filled) {
                g.setColor(this.color);
                g.translate(dx, dy);
                g.fillPolygon(this.pc[i].p);
                g.translate(-dx, -dy);
            }
            if (this.paintBorder) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    g.translate(dx, dy);
                    g.drawPolygon(this.pc[i].p);
                    g.translate(-dx, -dy);
                    g.setStroke(stdS);
                } else {
                    g.translate(dx, dy);
                    g.drawPolygon(this.pc[i].p);
                    g.translate(-dx, -dy);
                }
            }
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
        }
    }

    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].lcr > 1) {
            if (this.filled) {
                g.setColor(this.color);
                g.translate(dx, dy);
                g.fillPolygon(this.pc[i].lp);
                g.translate(-dx, -dy);
            }
            if (this.paintBorder) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    g.translate(dx, dy);
                    g.drawPolygon(this.pc[i].lp);
                    g.translate(-dx, -dy);
                    g.setStroke(stdS);
                } else {
                    g.translate(dx, dy);
                    g.drawPolygon(this.pc[i].lp);
                    g.translate(-dx, -dy);
                }
            }
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
        }
    }

    public double getArea() {
        long[] xcoordsForArea = new long[this.vertices.length];
        long[] ycoordsForArea = new long[this.vertices.length];
        float vertexAngle = this.orient;
        for (int i = 0; i < this.vertices.length - 1; ++i) {
            xcoordsForArea[i] = Math.round((double)this.vx + (double)this.vs * Math.cos(vertexAngle) * (double)this.vertices[i]);
            ycoordsForArea[i] = Math.round((double)this.vy + (double)this.vs * Math.sin(vertexAngle) * (double)this.vertices[i]);
            vertexAngle = (float)((double)vertexAngle + Math.PI * 2 / (double)this.vertices.length);
        }
        xcoordsForArea[this.vertices.length - 1] = Math.round((double)this.vx + (double)this.vs * Math.cos(vertexAngle) * (double)this.vertices[this.vertices.length - 1]);
        ycoordsForArea[this.vertices.length - 1] = Math.round((double)this.vy + (double)this.vs * Math.sin(vertexAngle) * (double)this.vertices[this.vertices.length - 1]);
        double res = 0.0;
        for (int j = 0; j < this.vertices.length; ++j) {
            int k = (j + 1) % this.vertices.length;
            res += (double)(xcoordsForArea[j] * ycoordsForArea[k] - ycoordsForArea[j] * xcoordsForArea[k]);
        }
        return (res /= 2.0) < 0.0 ? -res : res;
    }

    public Point2D.Double getPreciseCentroid() {
        int k;
        int j;
        long[] xcoordsForArea = new long[this.vertices.length];
        long[] ycoordsForArea = new long[this.vertices.length];
        float vertexAngle = this.orient;
        for (int i = 0; i < this.vertices.length - 1; ++i) {
            xcoordsForArea[i] = Math.round((double)this.vx + (double)this.vs * Math.cos(vertexAngle) * (double)this.vertices[i]);
            ycoordsForArea[i] = Math.round((double)this.vy + (double)this.vs * Math.sin(vertexAngle) * (double)this.vertices[i]);
            vertexAngle = (float)((double)vertexAngle + Math.PI * 2 / (double)this.vertices.length);
        }
        xcoordsForArea[this.vertices.length - 1] = Math.round((double)this.vx + (double)this.vs * Math.cos(vertexAngle) * (double)this.vertices[this.vertices.length - 1]);
        ycoordsForArea[this.vertices.length - 1] = Math.round((double)this.vy + (double)this.vs * Math.sin(vertexAngle) * (double)this.vertices[this.vertices.length - 1]);
        double area = 0.0;
        for (j = 0; j < this.vertices.length; ++j) {
            k = (j + 1) % this.vertices.length;
            area += (double)(xcoordsForArea[j] * ycoordsForArea[k] - ycoordsForArea[j] * xcoordsForArea[k]);
        }
        area /= 2.0;
        double factor = 0.0;
        double cx = 0.0;
        double cy = 0.0;
        for (j = 0; j < this.vertices.length; ++j) {
            k = (j + 1) % this.vertices.length;
            factor = xcoordsForArea[j] * ycoordsForArea[k] - xcoordsForArea[k] * ycoordsForArea[j];
            cx += (double)(xcoordsForArea[j] + xcoordsForArea[k]) * factor;
            cy += (double)(ycoordsForArea[j] + ycoordsForArea[k]) * factor;
        }
        factor = 1.0 / (area *= 6.0);
        Point2D.Double res = new Point2D.Double(cx *= factor, cy *= factor);
        return res;
    }

    public LongPoint getCentroid() {
        Point2D.Double p2dd = this.getPreciseCentroid();
        return new LongPoint(Math.round(p2dd.getX()), Math.round(p2dd.getY()));
    }

    public Object clone() {
        VShape res = new VShape(this.vx, this.vy, 0, this.vs, (float[])this.vertices.clone(), this.color, this.borderColor, this.orient);
        res.mouseInsideColor = this.mouseInsideColor;
        return res;
    }
}

