/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui;

import java.io.File;
import org.wiztools.filechooser.FileFilter;
import org.wiztools.restclient.FileType;

public class RCFileFilter
implements FileFilter {
    private final String type;

    public RCFileFilter(String type) {
        this.type = type;
    }

    @Override
    public final boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String path = f.getAbsolutePath().toLowerCase();
        if (".rcq".equals(this.type) && path.endsWith(".rcq")) {
            return true;
        }
        if (".rcs".equals(this.type) && path.endsWith(".rcs")) {
            return true;
        }
        return ".rcr".equals(this.type) && path.endsWith(".rcr");
    }

    @Override
    public final String getDescription() {
        return FileType.getNameFromExt(this.type);
    }

    public String getFileTypeExt() {
        return this.type;
    }
}

