/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.HtmlViewerPanel;
import net.sourceforge.squirrel_sql.client.resources.SquirrelResources;

public class HtmlViewerSheet
extends JFrame {
    private final IApplication _app;
    private URL _documentURL;

    public HtmlViewerSheet(IApplication app, String title) {
        this(app, title, null);
    }

    public HtmlViewerSheet(IApplication app, String title, URL url) {
        super(title);
        if (app == null) {
            throw new IllegalArgumentException("IApplication == null");
        }
        this._app = app;
        this._documentURL = url;
        this.createGUI();
    }

    public URL getURL() {
        return this._documentURL;
    }

    private void createGUI() {
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)new HtmlViewerPanel(this._documentURL), "Center");
        SquirrelResources rsrc = this._app.getResources();
        ImageIcon icon = rsrc.getIcon("AppIcon");
        if (icon != null) {
            this.setIconImage(icon.getImage());
        }
        this.pack();
    }
}

