/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.fonts;

import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.util.Map;
import net.sourceforge.napkinlaf.fonts.MergedGlyphVector;
import net.sourceforge.napkinlaf.fonts.PatchedFontUIResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergedFont
extends PatchedFontUIResource {
    private final Font backingFont;

    public MergedFont(Font primaryFont, Font backingFont) {
        super(primaryFont);
        if (backingFont == null) {
            throw new NullPointerException("backingFont");
        }
        this.backingFont = backingFont;
    }

    public static Font mergeFonts(Font primaryFont, Font ... backingFonts) {
        if (backingFonts == null || backingFonts.length == 0) {
            return primaryFont;
        }
        if (backingFonts.length == 1) {
            return new MergedFont(primaryFont, backingFonts[0]);
        }
        return new MergedFont(primaryFont, MergedFont.doMergeFonts(backingFonts, 0));
    }

    private static Font doMergeFonts(Font[] backingFonts, int pos) {
        Font first = backingFonts[pos];
        if (pos == backingFonts.length - 1) {
            return first;
        }
        return new MergedFont(first, MergedFont.doMergeFonts(backingFonts, pos + 1));
    }

    public Font getBackingFont() {
        return this.backingFont;
    }

    private GlyphVector processGlyphVector(FontRenderContext frc, GlyphVector gVector, GlyphVector gVector2) {
        GlyphVector result;
        int glyphCount = gVector.getNumGlyphs();
        if (glyphCount == 0) {
            result = gVector;
        } else {
            int badCode = this.getMissingGlyphCode();
            int badCode2 = this.backingFont.getMissingGlyphCode();
            MergedGlyphVector mgv = new MergedGlyphVector(this, frc);
            boolean replaced = false;
            for (int i = 0; i < glyphCount; ++i) {
                GlyphVector curGVector = gVector;
                if (gVector.getGlyphCode(i) == badCode && gVector2.getGlyphCode(i) != badCode2) {
                    curGVector = gVector2;
                    replaced = true;
                }
                Point2D origPos = curGVector.getGlyphPosition(i);
                Point2D curPos = gVector.getGlyphPosition(i);
                AffineTransform matrix = AffineTransform.getTranslateInstance(curPos.getX() - origPos.getX(), curPos.getY() - origPos.getY());
                Shape outline = curGVector.getGlyphOutline(i);
                Shape logicalBounds = curGVector.getGlyphLogicalBounds(i);
                Shape visualBounds = curGVector.getGlyphVisualBounds(i);
                outline = matrix.createTransformedShape(outline);
                logicalBounds = matrix.createTransformedShape(logicalBounds);
                visualBounds = matrix.createTransformedShape(visualBounds);
                GlyphMetrics metrics = curGVector.getGlyphMetrics(i);
                float advanceX = metrics.getAdvanceX();
                Rectangle2D metricsBounds = metrics.getBounds2D();
                metricsBounds.setRect(curPos.getX(), curPos.getY(), metricsBounds.getWidth(), metricsBounds.getHeight());
                metrics = new GlyphMetrics(metrics.getAdvance() == advanceX, advanceX, metrics.getAdvanceY(), metricsBounds, (byte)metrics.getType());
                Font glyphFont = curGVector instanceof MergedGlyphVector ? ((MergedGlyphVector)curGVector).getGlyphFont(i) : curGVector.getFont();
                mgv.appendGlyph(curGVector.getGlyphCode(i), outline, curPos, curGVector.getGlyphTransform(i), logicalBounds, visualBounds, metrics, curGVector.getGlyphJustificationInfo(i), glyphFont);
            }
            result = replaced ? mgv : gVector;
        }
        return result;
    }

    private boolean isPrimarySufficient(String str) {
        int i;
        int n = str.length();
        for (i = 0; i < n && super.canDisplay(str.charAt(i)); ++i) {
        }
        return i == n;
    }

    private boolean isPrimarySufficient(char[] text, int start, int limit) {
        int i;
        for (i = start; i < limit && super.canDisplay(text[i]); ++i) {
        }
        return i == limit;
    }

    private boolean isPrimarySufficient(CharacterIterator iter) {
        int limit = iter.getEndIndex();
        char c = iter.setIndex(iter.getBeginIndex());
        while (iter.getIndex() < limit && super.canDisplay(c)) {
            c = iter.next();
        }
        return iter.getIndex() == limit;
    }

    @Override
    public GlyphVector createGlyphVector(FontRenderContext frc, char[] chars) {
        GlyphVector gVector = super.createGlyphVector(frc, chars);
        if (this.isPrimarySufficient(chars, 0, chars.length)) {
            return gVector;
        }
        GlyphVector backVector = this.backingFont.createGlyphVector(frc, chars);
        return this.processGlyphVector(frc, gVector, backVector);
    }

    @Override
    public GlyphVector createGlyphVector(FontRenderContext frc, String str) {
        GlyphVector gVector = super.createGlyphVector(frc, str);
        if (this.isPrimarySufficient(str)) {
            return gVector;
        }
        GlyphVector backVector = this.backingFont.createGlyphVector(frc, str);
        return this.processGlyphVector(frc, gVector, backVector);
    }

    @Override
    public GlyphVector createGlyphVector(FontRenderContext frc, CharacterIterator ci) {
        GlyphVector gVector = super.createGlyphVector(frc, ci);
        if (this.isPrimarySufficient(ci)) {
            return gVector;
        }
        GlyphVector backVector = this.backingFont.createGlyphVector(frc, ci);
        return this.processGlyphVector(frc, gVector, backVector);
    }

    @Override
    public GlyphVector createGlyphVector(FontRenderContext frc, int[] glyphCodes) {
        GlyphVector gVector = super.createGlyphVector(frc, glyphCodes);
        return this.processGlyphVector(frc, gVector, this.backingFont.createGlyphVector(frc, glyphCodes));
    }

    @Override
    public GlyphVector layoutGlyphVector(FontRenderContext frc, char[] text, int start, int limit, int flags) {
        GlyphVector gVector = super.layoutGlyphVector(frc, text, start, limit, flags);
        if (this.isPrimarySufficient(text, start, limit)) {
            return gVector;
        }
        GlyphVector backVector = this.backingFont.layoutGlyphVector(frc, text, start, limit, flags);
        return this.processGlyphVector(frc, gVector, backVector);
    }

    @Override
    public boolean canDisplay(char c) {
        return super.canDisplay(c) || this.backingFont.canDisplay(c);
    }

    @Override
    public boolean canDisplay(int codePoint) {
        return super.canDisplay(codePoint) || this.backingFont.canDisplay(codePoint);
    }

    @Override
    public String toString() {
        return "MergedFont{" + super.toString() + ":" + this.backingFont + "}";
    }

    @Override
    public boolean equals(Object that) {
        if (that == this) {
            return true;
        }
        return super.equals(that) && that instanceof MergedFont && this.backingFont.equals(((MergedFont)that).backingFont);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.backingFont.hashCode();
    }

    @Override
    public byte getBaselineFor(char c) {
        if (!super.canDisplay(c) && this.backingFont.canDisplay(c)) {
            return this.backingFont.getBaselineFor(c);
        }
        return super.getBaselineFor(c);
    }

    @Override
    public int getNumGlyphs() {
        return Math.max(super.getNumGlyphs(), this.backingFont.getNumGlyphs());
    }

    @Override
    public Font deriveFont(float newSize) {
        Font topFont = super.deriveFont(newSize);
        float backSize = newSize * this.backingFont.getSize2D() / this.getSize2D();
        return new MergedFont(topFont, this.backingFont.deriveFont(backSize));
    }

    @Override
    public Font deriveFont(int newStyle) {
        Font topFont = super.deriveFont(newStyle);
        int styleMask = this.getStyle() ^ newStyle;
        int overridingStyles = newStyle & styleMask;
        int backStyle = this.backingFont.getStyle();
        backStyle &= ~styleMask;
        return new MergedFont(topFont, this.backingFont.deriveFont(backStyle |= overridingStyles));
    }

    @Override
    public Font deriveFont(AffineTransform trans) {
        try {
            AffineTransform inv = this.getTransform().createInverse();
            inv.concatenate(this.backingFont.getTransform());
            AffineTransform backingTrans = (AffineTransform)trans.clone();
            backingTrans.concatenate(inv);
            return new MergedFont(super.deriveFont(trans), this.backingFont.deriveFont(backingTrans));
        }
        catch (NoninvertibleTransformException ex) {
            return new MergedFont(super.deriveFont(trans), this.backingFont.deriveFont(trans));
        }
    }

    @Override
    public Font deriveFont(Map<? extends AttributedCharacterIterator.Attribute, ?> attrs) {
        Map<TextAttribute, ?> topAttrs = this.getAttributes();
        if (attrs == topAttrs || attrs != null && ((Object)attrs).equals(topAttrs)) {
            return this;
        }
        return new MergedFont(super.deriveFont(attrs), this.backingFont.deriveFont(attrs));
    }

    @Override
    public Font deriveFont(int newStyle, AffineTransform trans) {
        return this.deriveFont(newStyle).deriveFont(trans);
    }

    @Override
    public Font deriveFont(int newStyle, float newSize) {
        return this.deriveFont(newSize).deriveFont(newStyle);
    }
}

