/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax;

import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.syntax.AutoCorrectData;
import net.sourceforge.squirrel_sql.plugins.syntax.AutoCorrectDlg;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPlugin;

public class AutoCorrectController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AutoCorrectController.class);
    private AutoCorrectDlg _dlg;
    private SyntaxPlugin _syntaxPugin;

    public AutoCorrectController(SyntaxPlugin syntaxPugin, Frame parent) {
        this._syntaxPugin = syntaxPugin;
        this._dlg = new AutoCorrectDlg(parent);
        AutoCorrectData autoCorrectData = syntaxPugin.getAutoCorrectProviderImpl().getAutoCorrectData();
        Vector data = new Vector();
        Enumeration<String> e = autoCorrectData.getAutoCorrectsHash().keys();
        while (e.hasMoreElements()) {
            String error = e.nextElement();
            Vector<String> row = new Vector<String>();
            row.add(error);
            String corr = autoCorrectData.getAutoCorrectsHash().get(error);
            corr = corr.replaceAll("\n", "\\\\n");
            row.add(corr);
            data.add(row);
        }
        Collections.sort(data, new Comparator<Vector<String>>(){

            @Override
            public int compare(Vector<String> row1, Vector<String> row2) {
                return row1.get(0).compareTo(row2.get(0));
            }
        });
        Vector<String> colHeaders = new Vector<String>();
        colHeaders.add(s_stringMgr.getString("syntax.errAbrev"));
        colHeaders.add(s_stringMgr.getString("syntax.corExt"));
        DefaultTableModel dtm = new DefaultTableModel();
        dtm.setDataVector(data, colHeaders);
        this._dlg.tblAutoCorrects.setModel(dtm);
        this._dlg.chkEnable.setSelected(autoCorrectData.isEnableAutoCorrects());
        this._dlg.setSize(550, 280);
        GUIUtils.centerWithinParent((Window)this._dlg);
        this._dlg.setVisible(true);
        this._dlg.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoCorrectController.this.onApply();
            }
        });
        this._dlg.btnAddRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoCorrectController.this.onAddRow();
            }
        });
        this._dlg.btnRemoveRows.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoCorrectController.this.onRemoveRows();
            }
        });
        this._dlg.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoCorrectController.this.onClose();
            }
        });
    }

    private void onClose() {
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }

    private void onRemoveRows() {
        DefaultTableModel dtm = (DefaultTableModel)this._dlg.tblAutoCorrects.getModel();
        int selRow = this._dlg.tblAutoCorrects.getSelectedRow();
        while (-1 != selRow) {
            dtm.removeRow(selRow);
            selRow = this._dlg.tblAutoCorrects.getSelectedRow();
        }
    }

    private void onApply() {
        TableCellEditor cellEditor = this._dlg.tblAutoCorrects.getCellEditor();
        if (null != cellEditor) {
            cellEditor.stopCellEditing();
        }
        DefaultTableModel dtm = (DefaultTableModel)this._dlg.tblAutoCorrects.getModel();
        Vector<Vector> dataVector = dtm.getDataVector();
        Hashtable<String, String> newAutoCorrects = new Hashtable<String, String>();
        for (int i = 0; i < dataVector.size(); ++i) {
            Vector row = dataVector.get(i);
            String error = (String)row.get(0);
            String corr = (String)row.get(1);
            if (null == error || null == corr || 0 == error.trim().length() || 0 == corr.trim().length() || error.equals(corr)) continue;
            corr = corr.replaceAll("\\\\n", "\n");
            newAutoCorrects.put(error.trim().toUpperCase(), corr);
        }
        this._syntaxPugin.getAutoCorrectProviderImpl().setAutoCorrects(newAutoCorrects, this._dlg.chkEnable.isSelected());
    }

    private void onAddRow() {
        DefaultTableModel dtm = (DefaultTableModel)this._dlg.tblAutoCorrects.getModel();
        Vector<String> newRow = new Vector<String>();
        newRow.add("");
        newRow.add("");
        dtm.addRow(newRow);
    }
}

