/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.apache.cassandra.io.util.ChecksumWriter;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.io.util.SequentialWriterOption;

public class ChecksummedSequentialWriter
extends SequentialWriter {
    private static final SequentialWriterOption CRC_WRITER_OPTION = SequentialWriterOption.newBuilder().bufferSize(8192).build();
    private final SequentialWriter crcWriter;
    private final ChecksumWriter crcMetadata;
    private final Optional<File> digestFile;

    public ChecksummedSequentialWriter(File file, File crcPath, File digestFile, SequentialWriterOption option) {
        super(file, option);
        this.crcWriter = new SequentialWriter(crcPath, CRC_WRITER_OPTION);
        this.crcMetadata = new ChecksumWriter(this.crcWriter);
        this.crcMetadata.writeChunkSize(this.buffer.capacity());
        this.digestFile = Optional.ofNullable(digestFile);
    }

    @Override
    protected void flushData() {
        super.flushData();
        ByteBuffer toAppend = this.buffer.duplicate();
        toAppend.position(0);
        toAppend.limit(this.buffer.position());
        this.crcMetadata.appendDirect(toAppend, false);
    }

    @Override
    protected SequentialWriter.TransactionalProxy txnProxy() {
        return new TransactionalProxy();
    }

    protected class TransactionalProxy
    extends SequentialWriter.TransactionalProxy {
        protected TransactionalProxy() {
            super(ChecksummedSequentialWriter.this);
        }

        @Override
        protected Throwable doCommit(Throwable accumulate) {
            return super.doCommit(ChecksummedSequentialWriter.this.crcWriter.commit(accumulate));
        }

        @Override
        protected Throwable doAbort(Throwable accumulate) {
            return super.doAbort(ChecksummedSequentialWriter.this.crcWriter.abort(accumulate));
        }

        @Override
        protected void doPrepare() {
            ChecksummedSequentialWriter.this.syncInternal();
            ChecksummedSequentialWriter.this.digestFile.ifPresent(ChecksummedSequentialWriter.this.crcMetadata::writeFullChecksum);
            ChecksummedSequentialWriter.this.crcWriter.prepareToCommit();
        }
    }
}

