/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.query;

import java.util.Objects;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xpack.sql.querydsl.query.LeafQuery;
import org.elasticsearch.xpack.sql.tree.Source;

public class TermQuery
extends LeafQuery {
    private final String term;
    private final Object value;

    public TermQuery(Source source, String term, Object value) {
        super(source);
        this.term = term;
        this.value = value;
    }

    public String term() {
        return this.term;
    }

    public Object value() {
        return this.value;
    }

    @Override
    public QueryBuilder asBuilder() {
        return QueryBuilders.termQuery((String)this.term, (Object)this.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.term, this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TermQuery other = (TermQuery)obj;
        return Objects.equals(this.term, other.term) && Objects.equals(this.value, other.value);
    }

    @Override
    protected String innerToString() {
        return this.term + ":" + this.value;
    }
}

