/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.util.Mutable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public final class SubCommand {
    private volatile ArgumentParser globalArgumentParser;
    private final ArgumentParser subcommandArgumentParser;
    private volatile boolean isPresent;
    private final LinkedHashMap<String[], String> exampleUsages;
    private final Map<String, ObjectPair<String, Boolean>> names;
    private final String description;

    public SubCommand(String name, String description, ArgumentParser parser, LinkedHashMap<String[], String> exampleUsages) throws ArgumentException {
        this.names = new LinkedHashMap<String, ObjectPair<String, Boolean>>(5);
        this.addName(name);
        this.description = description;
        if (description == null || description.isEmpty()) {
            throw new ArgumentException(ArgsMessages.ERR_SUBCOMMAND_DESCRIPTION_NULL_OR_EMPTY.get());
        }
        this.subcommandArgumentParser = parser;
        if (parser == null) {
            throw new ArgumentException(ArgsMessages.ERR_SUBCOMMAND_PARSER_NULL.get());
        }
        if (parser.allowsTrailingArguments()) {
            throw new ArgumentException(ArgsMessages.ERR_SUBCOMMAND_PARSER_ALLOWS_TRAILING_ARGS.get());
        }
        if (parser.hasSubCommands()) {
            throw new ArgumentException(ArgsMessages.ERR_SUBCOMMAND_PARSER_HAS_SUBCOMMANDS.get());
        }
        this.exampleUsages = exampleUsages == null ? new LinkedHashMap(10) : new LinkedHashMap<String[], String>(exampleUsages);
        this.isPresent = false;
        this.globalArgumentParser = null;
    }

    private SubCommand(SubCommand source) {
        this.names = new LinkedHashMap<String, ObjectPair<String, Boolean>>(source.names);
        this.description = source.description;
        this.subcommandArgumentParser = new ArgumentParser(source.subcommandArgumentParser, this);
        this.exampleUsages = new LinkedHashMap<String[], String>(source.exampleUsages);
        this.isPresent = false;
        this.globalArgumentParser = null;
    }

    public String getPrimaryName() {
        return this.names.values().iterator().next().getFirst();
    }

    public List<String> getNames() {
        return this.getNames(true);
    }

    public List<String> getNames(boolean includeHidden) {
        ArrayList<String> nameList = new ArrayList<String>(this.names.size());
        for (ObjectPair<String, Boolean> p : this.names.values()) {
            if (!includeHidden && p.getSecond().booleanValue()) continue;
            nameList.add(p.getFirst());
        }
        return Collections.unmodifiableList(nameList);
    }

    public boolean hasName(String name) {
        return this.names.containsKey(StaticUtils.toLowerCase(name));
    }

    public void addName(String name) throws ArgumentException {
        this.addName(name, false);
    }

    public void addName(String name, boolean isHidden) throws ArgumentException {
        if (name == null || name.isEmpty()) {
            throw new ArgumentException(ArgsMessages.ERR_SUBCOMMAND_NAME_NULL_OR_EMPTY.get());
        }
        String lowerName = StaticUtils.toLowerCase(name);
        if (this.names.containsKey(lowerName)) {
            throw new ArgumentException(ArgsMessages.ERR_SUBCOMMAND_NAME_ALREADY_IN_USE.get(name));
        }
        if (this.globalArgumentParser != null) {
            this.globalArgumentParser.addSubCommand(name, this);
        }
        this.names.put(lowerName, new ObjectPair<String, Boolean>(name, isHidden));
    }

    public String getDescription() {
        return this.description;
    }

    public ArgumentParser getArgumentParser() {
        return this.subcommandArgumentParser;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    void setPresent() {
        this.isPresent = true;
    }

    ArgumentParser getGlobalArgumentParser() {
        return this.globalArgumentParser;
    }

    void setGlobalArgumentParser(ArgumentParser globalArgumentParser) {
        this.globalArgumentParser = globalArgumentParser;
    }

    public LinkedHashMap<String[], String> getExampleUsages() {
        return this.exampleUsages;
    }

    public SubCommand getCleanCopy() {
        return new SubCommand(this);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("SubCommand(");
        if (this.names.size() == 1) {
            buffer.append("name='");
            buffer.append(this.names.values().iterator().next());
            buffer.append('\'');
        } else {
            buffer.append("names={");
            Iterator<ObjectPair<String, Boolean>> iterator = this.names.values().iterator();
            while (iterator.hasNext()) {
                buffer.append('\'');
                buffer.append(iterator.next().getFirst());
                buffer.append('\'');
                if (!iterator.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append('}');
        }
        buffer.append(", description='");
        buffer.append(this.description);
        buffer.append("', parser=");
        this.subcommandArgumentParser.toString(buffer);
        buffer.append(')');
    }
}

