/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest;

import io.netty.handler.ssl.SslHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.net.ssl.SSLEngine;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.netty4.Netty4HttpRequest;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.rest.RestRequestFilter;
import org.elasticsearch.xpack.core.ssl.TLSv1DeprecationHandler;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.rest.RemoteHostHeader;
import org.elasticsearch.xpack.security.transport.ServerTransportFilter;

public class SecurityRestFilter
implements RestHandler {
    private static final Logger logger = LogManager.getLogger(SecurityRestFilter.class);
    private final RestHandler restHandler;
    private final AuthenticationService service;
    private final XPackLicenseState licenseState;
    private final ThreadContext threadContext;
    private final boolean extractClientCertificate;
    private final TLSv1DeprecationHandler tlsDeprecationHandler;

    public SecurityRestFilter(XPackLicenseState licenseState, ThreadContext threadContext, AuthenticationService service, RestHandler restHandler, boolean extractClientCertificate, TLSv1DeprecationHandler tlsDeprecationHandler) {
        this.restHandler = restHandler;
        this.service = service;
        this.licenseState = licenseState;
        this.threadContext = threadContext;
        this.extractClientCertificate = extractClientCertificate;
        this.tlsDeprecationHandler = tlsDeprecationHandler;
    }

    public void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
        if (this.tlsDeprecationHandler.shouldLogWarnings()) {
            SSLEngine engine = this.getSslEngine((Netty4HttpRequest)request);
            this.tlsDeprecationHandler.checkAndLog(engine.getSession(), () -> "HTTP connection from " + this.remoteHost(request));
        }
        if (this.licenseState.isAuthAllowed() && request.method() != RestRequest.Method.OPTIONS) {
            if (this.extractClientCertificate) {
                Netty4HttpRequest nettyHttpRequest = (Netty4HttpRequest)request;
                SSLEngine engine = this.getSslEngine(nettyHttpRequest);
                ServerTransportFilter.extractClientCertificates(logger, this.threadContext, engine, nettyHttpRequest.getChannel());
            }
            this.service.authenticate(this.maybeWrapRestRequest(request), (ActionListener<Authentication>)ActionListener.wrap(authentication -> {
                RemoteHostHeader.process(request, this.threadContext);
                this.restHandler.handleRequest(request, channel, client);
            }, e -> {
                try {
                    channel.sendResponse((RestResponse)new BytesRestResponse(channel, e));
                }
                catch (Exception inner) {
                    inner.addSuppressed((Throwable)e);
                    logger.error(() -> new ParameterizedMessage("failed to send failure response for uri [{}]", (Object)request.uri()), (Throwable)inner);
                }
            }));
        } else {
            this.restHandler.handleRequest(request, channel, client);
        }
    }

    private String remoteHost(RestRequest request) {
        SocketAddress address = request.getRemoteAddress();
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inet = (InetSocketAddress)address;
            return inet.getHostString();
        }
        return address.toString();
    }

    private SSLEngine getSslEngine(Netty4HttpRequest nettyHttpRequest) {
        SslHandler handler = (SslHandler)nettyHttpRequest.getChannel().pipeline().get(SslHandler.class);
        assert (handler != null);
        return handler.engine();
    }

    RestRequest maybeWrapRestRequest(RestRequest restRequest) throws IOException {
        if (this.restHandler instanceof RestRequestFilter) {
            return ((RestRequestFilter)this.restHandler).getFilteredRequest(restRequest);
        }
        return restRequest;
    }
}

