/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.indexlifecycle;

import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.indices.rollover.RolloverInfo;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.indexlifecycle.ClusterStateActionStep;
import org.elasticsearch.xpack.core.indexlifecycle.LifecycleExecutionState;
import org.elasticsearch.xpack.core.indexlifecycle.LifecycleSettings;
import org.elasticsearch.xpack.core.indexlifecycle.RolloverAction;
import org.elasticsearch.xpack.core.indexlifecycle.Step;

public class UpdateRolloverLifecycleDateStep
extends ClusterStateActionStep {
    private static final Logger logger = LogManager.getLogger(UpdateRolloverLifecycleDateStep.class);
    public static final String NAME = "update-rollover-lifecycle-date";
    private final LongSupplier fallbackTimeSupplier;

    public UpdateRolloverLifecycleDateStep(Step.StepKey key, Step.StepKey nextStepKey, LongSupplier fallbackTimeSupplier) {
        super(key, nextStepKey);
        this.fallbackTimeSupplier = fallbackTimeSupplier;
    }

    @Override
    public ClusterState performAction(Index index, ClusterState currentState) {
        long newIndexTime;
        IndexMetaData indexMetaData = currentState.metaData().getIndexSafe(index);
        boolean indexingComplete = (Boolean)LifecycleSettings.LIFECYCLE_INDEXING_COMPLETE_SETTING.get(indexMetaData.getSettings());
        if (indexingComplete) {
            logger.trace(indexMetaData.getIndex() + " has lifecycle complete set, skipping " + NAME);
            newIndexTime = this.fallbackTimeSupplier.getAsLong();
        } else {
            String rolloverAlias = (String)RolloverAction.LIFECYCLE_ROLLOVER_ALIAS_SETTING.get(indexMetaData.getSettings());
            if (Strings.isNullOrEmpty((String)rolloverAlias)) {
                throw new IllegalStateException("setting [index.lifecycle.rollover_alias] is not set on index [" + indexMetaData.getIndex().getName() + "]");
            }
            RolloverInfo rolloverInfo = (RolloverInfo)indexMetaData.getRolloverInfos().get((Object)rolloverAlias);
            if (rolloverInfo == null) {
                throw new IllegalStateException("no rollover info found for [" + indexMetaData.getIndex().getName() + "] with alias [" + rolloverAlias + "], the index has not yet rolled over with that alias");
            }
            newIndexTime = rolloverInfo.getTime();
        }
        LifecycleExecutionState.Builder newLifecycleState = LifecycleExecutionState.builder(LifecycleExecutionState.fromIndexMetadata(indexMetaData));
        newLifecycleState.setIndexCreationDate(newIndexTime);
        IndexMetaData.Builder newIndexMetadata = IndexMetaData.builder((IndexMetaData)indexMetaData);
        newIndexMetadata.putCustom("ilm", newLifecycleState.build().asMap());
        return ClusterState.builder((ClusterState)currentState).metaData(MetaData.builder((MetaData)currentState.metaData()).put(newIndexMetadata)).build();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && super.equals(obj);
    }
}

