/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.gss;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssConditionalRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDefinitionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssUnknownAtRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.ErrorManager;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssError;
import com.google.gwt.thirdparty.common.css.compiler.ast.VisitController;

public class ValidateRuntimeConditionalNode
extends DefaultTreeVisitor
implements CssCompilerPass {
    private final VisitController visitController;
    private final ErrorManager errorManager;
    private final boolean lenient;
    private int cssConditionalRuleNodes;

    public ValidateRuntimeConditionalNode(VisitController visitController, ErrorManager errorManager, boolean lenient) {
        this.visitController = visitController;
        this.errorManager = errorManager;
        this.lenient = lenient;
    }

    public boolean enterDefinition(CssDefinitionNode node) {
        if (this.inConditionalRule()) {
            if (this.lenient) {
                this.errorManager.reportWarning(new GssError("You should not define a constant inside a ConditionalNode that will be evaluated at runtime. This will be disallowed in the next version of GWT.", node.getSourceCodeLocation()));
            } else {
                this.errorManager.report(new GssError("You cannot define a constant inside a ConditionalNode that will be evaluated at runtime.", node.getSourceCodeLocation()));
            }
        }
        return false;
    }

    public boolean enterUnknownAtRule(CssUnknownAtRuleNode node) {
        if (this.inConditionalRule() && "external".equals(node.getName().getValue())) {
            if (this.lenient) {
                this.errorManager.reportWarning(new GssError("You should not define a external at-rule inside a  ConditionalNode that will be evaluated at runtime. This will be disallowed in the next version of GWT.", node.getSourceCodeLocation()));
            } else {
                this.errorManager.report(new GssError("You cannot define a external at-rule inside a ConditionalNode that will be evaluated at runtime.", node.getSourceCodeLocation()));
            }
        }
        return super.enterUnknownAtRule(node);
    }

    public boolean enterConditionalRule(CssConditionalRuleNode node) {
        ++this.cssConditionalRuleNodes;
        return true;
    }

    public void leaveConditionalRule(CssConditionalRuleNode node) {
        --this.cssConditionalRuleNodes;
    }

    public void runPass() {
        this.cssConditionalRuleNodes = 0;
        this.visitController.startVisit((CssTreeVisitor)this);
    }

    private boolean inConditionalRule() {
        return this.cssConditionalRuleNodes > 0;
    }
}

