/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap.ant;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.ant.FlaggedOptionConfiguration;
import com.martiansoftware.jsap.ant.ParameterConfiguration;
import com.martiansoftware.jsap.ant.SwitchConfiguration;
import com.martiansoftware.jsap.ant.UnflaggedOptionConfiguration;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class JSAPAntTask
extends Task {
    private boolean isPublic = false;
    private File srcDir = null;
    private String className = null;
    private Vector parameterConfigs = new Vector();
    private JSAP jsap = null;
    private boolean containsFlaggedOptions = false;
    private boolean containsUnflaggedOptions = false;
    private boolean containsSwitches = false;
    private boolean hasProperties = false;

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public void setSrcdir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setClassname(String className) {
        this.className = className.trim();
    }

    public void addConfiguredFlaggedoption(FlaggedOptionConfiguration flaggedOptionConfig) {
        this.containsFlaggedOptions = true;
        this.parameterConfigs.add(flaggedOptionConfig);
    }

    public void addConfiguredUnflaggedoption(UnflaggedOptionConfiguration unflaggedOptionConfig) {
        this.containsUnflaggedOptions = true;
        this.parameterConfigs.add(unflaggedOptionConfig);
    }

    public void addConfiguredSwitch(SwitchConfiguration switchConfig) {
        this.containsSwitches = true;
        this.parameterConfigs.add(switchConfig);
    }

    private void buildJSAP() throws JSAPException {
        JSAP jsap = new JSAP();
        Enumeration e = this.parameterConfigs.elements();
        while (e.hasMoreElements()) {
            ParameterConfiguration pc = (ParameterConfiguration)e.nextElement();
            if (pc.hasProperties()) {
                this.hasProperties = true;
            }
            jsap.registerParameter(pc.getParameter());
        }
    }

    private void writeJSAP() throws IOException {
        int lastDotPos = this.className.lastIndexOf(".");
        String packageName = "";
        String shortClassName = this.className;
        if (lastDotPos > -1) {
            packageName = this.className.substring(0, lastDotPos);
            shortClassName = this.className.substring(lastDotPos + 1);
        }
        System.out.println("package name: [" + packageName + "]");
        System.out.println("shortClassName: [" + shortClassName + "]");
        File classFileDir = new File(this.srcDir.getCanonicalPath() + File.separatorChar + packageName.replace('.', File.separatorChar));
        File classFile = new File(classFileDir, shortClassName + ".java");
        System.out.println("Creating directory \"" + classFileDir.toString() + "\"");
        classFileDir.mkdirs();
        System.out.println("Creating JSAP class file \"" + classFile + "\"");
        classFile.createNewFile();
        System.out.println("Created");
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(classFile)));
        this.createJavaFile(shortClassName, packageName, out);
        out.close();
    }

    private String properCase(String s) {
        String result = null;
        if (s != null) {
            result = s.length() < 2 ? s.toUpperCase() : s.toUpperCase().charAt(0) + s.substring(1);
        }
        return result;
    }

    private void createJavaFile(String shortClassName, String packageName, PrintStream out) throws IOException {
        ParameterConfiguration pc;
        if (packageName.length() > 0) {
            out.println("package " + packageName + ";");
            out.println();
        }
        out.println(" /*");
        out.println("  * THIS FILE IS AUTOMATICALLY GENERATED - DO NOT EDIT");
        out.println("  */");
        out.println();
        out.println("import com.martiansoftware.jsap.JSAP;");
        out.println("import com.martiansoftware.jsap.JSAPException;");
        if (this.containsSwitches) {
            out.println("import com.martiansoftware.jsap.Switch;");
        }
        if (this.containsFlaggedOptions) {
            out.println("import com.martiansoftware.jsap.FlaggedOption;");
        }
        if (this.containsUnflaggedOptions) {
            out.println("import com.martiansoftware.jsap.UnflaggedOption;");
        }
        if (this.hasProperties) {
            out.println("import com.martiansoftware.jsap.PropertyStringParser;");
        }
        out.println();
        if (this.isPublic) {
            out.print("public ");
        }
        out.println("class " + shortClassName + " extends JSAP {");
        out.println();
        out.println("    public " + shortClassName + "() {");
        out.println("        super();");
        out.println("        try {");
        out.println("            init();");
        out.println("        } catch (JSAPException e) {");
        out.println("            throw(new IllegalStateException(e.getMessage()));");
        out.println("        }");
        out.println("    }");
        out.println();
        out.println("    private void init() throws JSAPException {");
        Enumeration e1 = this.parameterConfigs.elements();
        while (e1.hasMoreElements()) {
            pc = (ParameterConfiguration)e1.nextElement();
            out.println("        this.registerParameter( create" + this.properCase(pc.getId()) + "() );");
        }
        out.println("    }");
        out.println();
        e1 = this.parameterConfigs.elements();
        while (e1.hasMoreElements()) {
            pc = (ParameterConfiguration)e1.nextElement();
            pc.createMethod("create" + this.properCase(pc.getId()), out);
            out.println();
        }
        out.println("}");
    }

    public void execute() throws BuildException {
        if (this.srcDir == null) {
            throw new BuildException("srcdir is required.");
        }
        if (this.className == null || this.className.length() == 0) {
            throw new BuildException("classname is required.");
        }
        if (!this.srcDir.isDirectory()) {
            throw new BuildException("srcdir must be a directory.");
        }
        System.out.println("srcDir=[" + this.srcDir + "]");
        System.out.println("className=[" + this.className + "]");
        System.out.println("public=" + this.isPublic);
        try {
            this.buildJSAP();
            this.writeJSAP();
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage());
        }
    }
}

