/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.ResourceTree;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.Utilities;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LoadFromServerAction
extends MenuAction {
    static Logger log = Logger.getLogger(LoadFromServerAction.class);
    IGV mainFrame;
    static HashSet<String> failedURLs = new HashSet();

    public LoadFromServerAction(String label, int mnemonic, IGV mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
    }

    public static String getGenomeDataURL(String genomeId) {
        String urlString = PreferencesManager.getPreferences().getDataServerURL();
        String genomeURL = urlString.replaceAll("\\$\\$", genomeId);
        return genomeURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent evt) {
        this.mainFrame.setStatusBarMessage("Loading ...");
        String genomeId = GenomeManager.getInstance().getGenomeId();
        String genomeURL = LoadFromServerAction.getGenomeDataURL(genomeId);
        try {
            LinkedHashSet<String> nodeURLs = LoadFromServerAction.getNodeURLs(genomeURL);
            if (nodeURLs == null || nodeURLs.isEmpty()) {
                MessageUtils.showMessage("No datasets are available for the current genome (" + genomeId + ").");
            } else {
                List<ResourceLocator> locators = this.loadNodes(nodeURLs);
                if (locators != null) {
                    this.mainFrame.loadTracks(locators);
                }
            }
        }
        finally {
            this.mainFrame.showLoadedTrackCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedHashSet<String> getNodeURLs(String genomeURL) {
        InputStream is = null;
        LinkedHashSet<String> nodeURLs = null;
        try {
            is = ParsingUtils.openInputStreamGZ(new ResourceLocator(genomeURL));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));
            nodeURLs = LoadFromServerAction.getResourceUrls(bufferedReader);
        }
        catch (IOException e) {
            log.error((Object)"Error loading genome registry file", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error closing input stream", (Throwable)e);
                }
            }
        }
        return nodeURLs;
    }

    private List<ResourceLocator> loadNodes(LinkedHashSet<String> xmlUrls) {
        if (xmlUrls == null || xmlUrls.isEmpty()) {
            log.error((Object)"No datasets are available from this server for the current genome (");
            return null;
        }
        try {
            Document masterDocument = LoadFromServerAction.createMasterDocument(xmlUrls);
            LoadFromServerAction loadFromServerAction = this;
            LinkedHashSet<ResourceLocator> selectedLocators = ResourceTree.showResourceTreeDialog(loadFromServerAction.mainFrame.getMainFrame(), masterDocument, "Available Datasets");
            ArrayList<ResourceLocator> newLoadList = new ArrayList<ResourceLocator>();
            if (selectedLocators != null) {
                for (ResourceLocator locator : selectedLocators) {
                    if (IGV.getInstance().getDataResourceLocators().contains(locator)) continue;
                    newLoadList.add(locator);
                }
            }
            return newLoadList;
        }
        catch (Exception e) {
            log.error((Object)"Could not load information from server", (Throwable)e);
            return null;
        }
    }

    public static Document createMasterDocument(Collection<String> xmlUrls) throws ParserConfigurationException {
        StringBuffer buffer = new StringBuffer();
        Document masterDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element rootNode = masterDocument.createElement("Global");
        rootNode.setAttribute("name", "Available Datasets");
        rootNode.setAttribute("version", "1");
        masterDocument.appendChild(rootNode);
        for (String url : xmlUrls) {
            if (failedURLs.contains(url)) continue;
            try {
                Document xmlDocument = LoadFromServerAction.readXMLDocument(url, buffer);
                if (xmlDocument == null) continue;
                Element global = xmlDocument.getDocumentElement();
                masterDocument.getDocumentElement().appendChild(masterDocument.importNode(global, true));
            }
            catch (Exception e) {
                String message = "Cannot create an XML Document from " + url.toString();
                log.error((Object)message, (Throwable)e);
            }
        }
        if (buffer.length() > 0) {
            String message = "<html>The following urls could not be processed due to load failures:<br>" + buffer.toString();
            MessageUtils.showMessage(message);
        }
        return masterDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document readXMLDocument(String url, StringBuffer errors) {
        InputStream is = null;
        Document xmlDocument = null;
        try {
            is = ParsingUtils.openInputStreamGZ(new ResourceLocator(url));
            xmlDocument = Utilities.createDOMDocumentFromXmlStream(is);
            xmlDocument = LoadFromServerAction.resolveIncludes(xmlDocument, errors);
        }
        catch (SAXException e) {
            log.error((Object)("Invalid XML resource: " + url), (Throwable)e);
            errors.append(url + "<br><i>" + e.getMessage());
        }
        catch (SocketTimeoutException e) {
            log.error((Object)"Connection time out", (Throwable)e);
            errors.append(url + "<br><i>Connection time out");
        }
        catch (IOException e) {
            log.error((Object)("Error accessing " + url.toString()), (Throwable)e);
            errors.append(url + "<br><i>" + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            log.error((Object)("Parser configuration error for:" + url), (Throwable)e);
            errors.append(url + "<br><i>" + e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error((Object)("Error closing stream for: " + url), (Throwable)e);
                }
            }
        }
        return xmlDocument;
    }

    private static Document resolveIncludes(Document document, StringBuffer errors) {
        NodeList includeNodes = document.getElementsByTagName("Include");
        if (includeNodes.getLength() == 0) {
            return document;
        }
        int size = includeNodes.getLength();
        Node[] tmp = new Node[size];
        for (int i = 0; i < size; ++i) {
            tmp[i] = includeNodes.item(i);
        }
        for (Node item : tmp) {
            NamedNodeMap nodeMap = item.getAttributes();
            if (nodeMap == null) {
                log.info((Object)("XML node " + item.getNodeName() + " has no attributes"));
                continue;
            }
            Attr path = (Attr)item.getAttributes().getNamedItem("path");
            if (path == null) {
                log.info((Object)("XML node " + item.getNodeName() + " is missing a path attribute"));
                continue;
            }
            Node parent = item.getParentNode();
            Document doc = LoadFromServerAction.readXMLDocument(path.getValue(), errors);
            if (doc == null) continue;
            Element global = doc.getDocumentElement();
            Node expandedNode = parent.getOwnerDocument().importNode(global, true);
            parent.replaceChild(expandedNode, item);
        }
        return document;
    }

    private static LinkedHashSet<String> getResourceUrls(BufferedReader bufferedReader) throws IOException {
        String xmlFileUrl;
        LinkedHashSet<String> xmlFileUrls = new LinkedHashSet<String>();
        while ((xmlFileUrl = bufferedReader.readLine()) != null) {
            if ((xmlFileUrl = xmlFileUrl.trim()).length() == 0 || xmlFileUrl.startsWith("#")) continue;
            xmlFileUrls.add(xmlFileUrl);
        }
        return xmlFileUrls;
    }
}

