/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.history.ClearCaseRepository;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryEntry;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.Repository;
import org.opensolaris.opengrok.util.Executor;

class ClearCaseHistoryParser
implements Executor.StreamHandler {
    private History history;
    private ClearCaseRepository repository = new ClearCaseRepository();

    ClearCaseHistoryParser() {
    }

    History parse(File file, Repository repos) throws HistoryException {
        this.repository = (ClearCaseRepository)repos;
        try {
            Executor executor = this.repository.getHistoryLogExecutor(file);
            int status = executor.exec(true, this);
            if (status != 0) {
                throw new HistoryException("Failed to get history for: \"" + file.getAbsolutePath() + "\" Exit code: " + status);
            }
            return this.history;
        }
        catch (IOException e) {
            throw new HistoryException("Failed to get history for: \"" + file.getAbsolutePath() + "\"", e);
        }
    }

    @Override
    public void processStream(InputStream input) throws IOException {
        String s;
        DateFormat df = this.repository.getDateFormat();
        BufferedReader in = new BufferedReader(new InputStreamReader(input));
        ArrayList<HistoryEntry> entries = new ArrayList<HistoryEntry>();
        HistoryEntry entry = null;
        while ((s = in.readLine()) != null) {
            if (!"create version".equals(s) && !"create directory version".equals(s)) {
                while ((s = in.readLine()) != null && !".".equals(s)) {
                }
                continue;
            }
            entry = new HistoryEntry();
            s = in.readLine();
            if (s != null) {
                try {
                    entry.setDate(df.parse(s));
                }
                catch (ParseException pe) {
                    OpenGrokLogger.getLogger().log(Level.WARNING, "Could not parse date: " + s, pe);
                }
            }
            if ((s = in.readLine()) != null) {
                entry.setAuthor(s);
            }
            if ((s = in.readLine()) != null) {
                s = s.replace('\\', '/');
                entry.setRevision(s);
            }
            StringBuffer message = new StringBuffer();
            String glue = "";
            while ((s = in.readLine()) != null && !".".equals(s)) {
                if ("".equals(s)) continue;
                message.append(glue);
                message.append(s.trim());
                glue = "\n";
            }
            entry.setMessage(message.toString());
            entry.setActive(true);
            entries.add(entry);
        }
        this.history = new History();
        this.history.setHistoryEntries(entries);
    }

    History parse(String buffer) throws IOException {
        this.processStream(new ByteArrayInputStream(buffer.getBytes("UTF-8")));
        return this.history;
    }
}

