/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.history.Annotation;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.Repository;
import org.opensolaris.opengrok.history.SubversionHistoryParser;
import org.opensolaris.opengrok.util.Executor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class SubversionRepository
extends Repository {
    private static final long serialVersionUID = 1L;
    public static final String CMD_PROPERTY_KEY = "org.opensolaris.opengrok.history.Subversion";
    public static final String CMD_FALLBACK = "svn";
    protected String reposPath;

    public SubversionRepository() {
        this.type = "Subversion";
        this.datePattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    }

    private String getValue(Node node) {
        if (node == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 3) continue;
            sb.append(n.getNodeValue());
        }
        return sb.toString();
    }

    @Override
    public void setDirectoryName(String directoryName) {
        super.setDirectoryName(directoryName);
        if (this.isWorking()) {
            Boolean rootFound = Boolean.FALSE;
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(this.cmd);
            cmd.add("info");
            cmd.add("--xml");
            File directory = new File(this.getDirectoryName());
            Executor executor = new Executor(cmd, directory);
            if (executor.exec() == 0) {
                try {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document document = builder.parse(executor.getOutputStream());
                    String url = this.getValue(document.getElementsByTagName("url").item(0));
                    if (url == null) {
                        OpenGrokLogger.getLogger().warning("svn info did not contain an URL for [" + directoryName + "]. Assuming remote repository.");
                        this.setRemote(true);
                    } else if (!url.startsWith("file")) {
                        this.setRemote(true);
                    }
                    String root = this.getValue(document.getElementsByTagName("root").item(0));
                    if (url != null && root != null) {
                        this.reposPath = url.substring(root.length());
                        rootFound = Boolean.TRUE;
                    }
                }
                catch (SAXException saxe) {
                    OpenGrokLogger.getLogger().log(Level.WARNING, "Parser error parsing svn output", saxe);
                }
                catch (ParserConfigurationException pce) {
                    OpenGrokLogger.getLogger().log(Level.WARNING, "Parser configuration error parsing svn output", pce);
                }
                catch (IOException ioe) {
                    OpenGrokLogger.getLogger().log(Level.WARNING, "IOException reading from svn process", ioe);
                }
            } else {
                OpenGrokLogger.getLogger().warning("Failed to execute svn info for [" + directoryName + "]. Repository disabled.");
            }
            this.setWorking(rootFound);
        }
    }

    Executor getHistoryLogExecutor(File file, String sinceRevision) {
        String abs;
        try {
            abs = file.getCanonicalPath();
        }
        catch (IOException exp) {
            OpenGrokLogger.getLogger().log(Level.SEVERE, "Failed to get canonical path: {0}", exp.getClass().toString());
            return null;
        }
        String filename = "";
        if (abs.length() > this.directoryName.length()) {
            filename = abs.substring(this.directoryName.length() + 1);
        }
        ArrayList<String> cmd = new ArrayList<String>();
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        cmd.add(this.cmd);
        cmd.add("log");
        cmd.add("--trust-server-cert");
        cmd.add("--non-interactive");
        cmd.add("--xml");
        cmd.add("-v");
        if (sinceRevision != null) {
            cmd.add("-r");
            cmd.add("BASE:" + sinceRevision);
        }
        if (filename.length() > 0) {
            cmd.add(this.escapeFileName(filename));
        }
        return new Executor(cmd, new File(this.directoryName));
    }

    @Override
    public InputStream getHistoryGet(String parent, String basename, String rev) {
        String filepath;
        InputStream ret = null;
        File directory = new File(this.directoryName);
        try {
            filepath = new File(parent, basename).getCanonicalPath();
        }
        catch (IOException exp) {
            OpenGrokLogger.getLogger().log(Level.SEVERE, "Failed to get canonical path: {0}", exp.getClass().toString());
            return null;
        }
        String filename = filepath.substring(this.directoryName.length() + 1);
        ArrayList<String> cmd = new ArrayList<String>();
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        cmd.add(this.cmd);
        cmd.add("cat");
        cmd.add("-r");
        cmd.add(rev);
        cmd.add(this.escapeFileName(filename));
        Executor executor = new Executor(cmd, directory);
        if (executor.exec() == 0) {
            ret = executor.getOutputStream();
        }
        return ret;
    }

    @Override
    boolean hasHistoryForDirectories() {
        return true;
    }

    @Override
    History getHistory(File file) throws HistoryException {
        return this.getHistory(file, null);
    }

    @Override
    History getHistory(File file, String sinceRevision) throws HistoryException {
        return new SubversionHistoryParser().parse(file, this, sinceRevision);
    }

    private String escapeFileName(String name) {
        if (name.length() == 0) {
            return name;
        }
        return name + "@";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Annotation annotate(File file, String revision) throws IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = null;
        try {
            saxParser = factory.newSAXParser();
        }
        catch (Exception ex) {
            IOException err = new IOException("Failed to create SAX parser", ex);
            throw err;
        }
        ArrayList<String> argv = new ArrayList<String>();
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        argv.add(this.cmd);
        argv.add("annotate");
        argv.add("--trust-server-cert");
        argv.add("--non-interactive");
        argv.add("--xml");
        if (revision != null) {
            argv.add("-r");
            argv.add(revision);
        }
        argv.add(this.escapeFileName(file.getName()));
        ProcessBuilder pb = new ProcessBuilder(argv);
        pb.directory(file.getParentFile());
        Process process = null;
        Annotation ret = null;
        try {
            process = pb.start();
            AnnotateHandler handler = new AnnotateHandler(file.getName());
            try (BufferedInputStream in = new BufferedInputStream(process.getInputStream());){
                saxParser.parse((InputStream)in, (DefaultHandler)handler);
                ret = handler.annotation;
            }
            catch (Exception e) {
                OpenGrokLogger.getLogger().log(Level.SEVERE, "An error occurred while parsing the xml output", e);
            }
        }
        finally {
            if (process != null) {
                try {
                    process.exitValue();
                }
                catch (IllegalThreadStateException e) {
                    process.destroy();
                }
            }
        }
        return ret;
    }

    @Override
    public boolean fileHasAnnotation(File file) {
        return true;
    }

    @Override
    public boolean fileHasHistory(File file) {
        return true;
    }

    @Override
    public void update() throws IOException {
        File directory = new File(this.getDirectoryName());
        ArrayList<String> cmd = new ArrayList<String>();
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        cmd.add(this.cmd);
        cmd.add("update");
        cmd.add("--trust-server-cert");
        cmd.add("--non-interactive");
        Executor executor = new Executor(cmd, directory);
        if (executor.exec() != 0) {
            throw new IOException(executor.getErrorString());
        }
    }

    @Override
    boolean isRepositoryFor(File file) {
        if (file.isDirectory()) {
            File f = new File(file, ".svn");
            return f.exists() && f.isDirectory();
        }
        return false;
    }

    @Override
    public boolean isWorking() {
        if (this.working == null) {
            this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
            this.working = SubversionRepository.checkCmd(this.cmd, "--help");
        }
        return this.working;
    }

    private static class AnnotateHandler
    extends DefaultHandler2 {
        String rev;
        String author;
        final Annotation annotation;
        final StringBuilder sb;

        AnnotateHandler(String filename) {
            this.annotation = new Annotation(filename);
            this.sb = new StringBuilder();
        }

        @Override
        public void startElement(String uri, String localName, String qname, Attributes attr) {
            this.sb.setLength(0);
            if ("entry".equals(qname)) {
                this.rev = null;
                this.author = null;
            } else if ("commit".equals(qname)) {
                this.rev = attr.getValue("revision");
            }
        }

        @Override
        public void endElement(String uri, String localName, String qname) {
            if ("author".equals(qname)) {
                this.author = this.sb.toString();
            } else if ("entry".equals(qname)) {
                this.annotation.addLine(this.rev, this.author, true);
            }
        }

        @Override
        public void characters(char[] arg0, int arg1, int arg2) {
            this.sb.append(arg0, arg1, arg2);
        }
    }
}

