import rox
from rox import choices, g

mode = 'Random'
change_time = g.Adjustment(0, lower = 0, upper = 999, step_incr = 1)
advanced_command = 'xearth -png -nice 4'

try:
	options = choices.load('Wallpaper', 'Options')
	if options:
		for line in file(options):
			key, value = line.strip().split('=')
			if key == 'change_time':
				change_time.set_value(int(value))
			elif key == 'advanced_command':
				advanced_command = value
			elif key == 'mode':
				assert value in ('Random', 'Advanced')
				mode = value
except:
	rox.report_exception()

def save():
	path = choices.save('Wallpaper', 'Options')
	if not path:
		rox.croak("Can't save settings; saving is disabled by CHOICESPATH!")
	print >>file(path, 'w'), "mode=%s\nchange_time=%d\nadvanced_command=%s" % \
			(mode, change_time.value, advanced_command)
